/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.renderers;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.AxisAlignedBB;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.Vector3f;
import net.montoyo.wd.utilities.Vector3i;
import org.lwjgl.opengl.GL11;

public class ScreenRenderer
extends TileEntitySpecialRenderer<TileEntityScreen> {
    private final Vector3f mid = new Vector3f();
    private final Vector3i tmpi = new Vector3i();
    private final Vector3f tmpf = new Vector3f();

    public void render(TileEntityScreen te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (!te.isLoaded()) {
            return;
        }
        RenderHelper.func_74518_a();
        this.func_190053_a(true);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        for (int i = 0; i < te.screenCount(); ++i) {
            TileEntityScreen.Screen scr = te.getScreen(i);
            if (scr.browser == null) {
                scr.browser = ((ClientProxy)WebDisplays.PROXY).getMCEF().createBrowser(WebDisplays.applyBlacklist(scr.url));
                if (scr.rotation.isVertical) {
                    scr.browser.resize(scr.resolution.y, scr.resolution.x);
                } else {
                    scr.browser.resize(scr.resolution.x, scr.resolution.y);
                }
                scr.doTurnOnAnim = true;
                scr.turnOnTime = System.currentTimeMillis();
            }
            this.tmpi.set(scr.side.right);
            this.tmpi.mul(scr.size.x);
            this.tmpi.addMul(scr.side.up, scr.size.y);
            this.tmpf.set(this.tmpi);
            this.mid.set(x + 0.5, y + 0.5, z + 0.5);
            this.mid.addMul(this.tmpf, 0.5f);
            this.tmpf.set(scr.side.left);
            this.mid.addMul(this.tmpf, 0.5f);
            this.tmpf.set(scr.side.down);
            this.mid.addMul(this.tmpf, 0.5f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.mid.x, (float)this.mid.y, (float)this.mid.z);
            switch (scr.side) {
                case BOTTOM: {
                    GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case TOP: {
                    GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case NORTH: {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            if (scr.doTurnOnAnim) {
                long lt = System.currentTimeMillis() - scr.turnOnTime;
                float ft = (float)lt / 100.0f;
                if (ft >= 1.0f) {
                    ft = 1.0f;
                    scr.doTurnOnAnim = false;
                }
                GL11.glScalef((float)ft, (float)ft, (float)1.0f);
            }
            if (!scr.rotation.isNull) {
                GL11.glRotatef((float)scr.rotation.angle, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            float sw = (float)scr.size.x * 0.5f - 0.125f;
            float sh = (float)scr.size.y * 0.5f - 0.125f;
            if (scr.rotation.isVertical) {
                float tmp = sw;
                sw = sh;
                sh = tmp;
            }
            GL11.glBindTexture((int)3553, (int)scr.browser.getTextureID());
            GL11.glBegin((int)7);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)1.0f);
            GL11.glVertex3f((float)(-sw), (float)(-sh), (float)0.505f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTexCoord2f((float)1.0f, (float)1.0f);
            GL11.glVertex3f((float)sw, (float)(-sh), (float)0.505f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTexCoord2f((float)1.0f, (float)0.0f);
            GL11.glVertex3f((float)sw, (float)sh, (float)0.505f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glTexCoord2f((float)0.0f, (float)0.0f);
            GL11.glVertex3f((float)(-sw), (float)sh, (float)0.505f);
            GL11.glEnd();
            GlStateManager.func_179144_i((int)0);
            GL11.glPopMatrix();
        }
        RenderHelper.func_74519_b();
        this.func_190053_a(false);
        GL11.glEnable((int)2884);
    }

    public void renderAABB(AxisAlignedBB bb) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2884);
        GL11.glColor4f((float)0.0f, (float)0.5f, (float)1.0f, (float)0.75f);
        GL11.glDepthMask((boolean)false);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder vb = t.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        vb.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        vb.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        vb.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        vb.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        vb.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        vb.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        vb.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        vb.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        vb.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        vb.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        vb.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        vb.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        vb.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        vb.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        vb.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        vb.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        vb.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        vb.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        vb.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        vb.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        vb.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        vb.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        vb.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        vb.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        t.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public boolean isGlobalRenderer(TileEntityScreen te) {
        return te.isLoaded();
    }
}

