/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.missile.tracker;

import icbm.classic.ICBMClassic;
import icbm.classic.api.events.MissileChunkEvent;
import icbm.classic.config.ConfigDebug;
import icbm.classic.content.missile.entity.explosive.EntityExplosiveMissile;
import icbm.classic.content.missile.logic.flight.DeadFlightLogic;
import icbm.classic.content.missile.tracker.LoadedChunkPair;
import icbm.classic.content.missile.tracker.MissileTrackerData;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.logging.log4j.Level;

public class MissileTrackerWorld
extends WorldSavedData {
    private final int speedPerSecond = 10;
    private final int unloadChunkCooldown = 60;
    private final int preLoadChunkTimer = 5;
    private LinkedList<MissileTrackerData> missileList = new LinkedList();
    private LinkedList<MissileTrackerData> missileSpawnList;
    private ForgeChunkManager.Ticket chunkLoadTicket;
    private LinkedList<LoadedChunkPair> currentLoadedChunks = new LinkedList();
    private int ticks = 0;

    public MissileTrackerWorld(String identifier) {
        super(identifier);
        this.missileSpawnList = new LinkedList();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)ICBMClassic.INSTANCE, (tickets, world) -> {});
    }

    void simulateMissile(EntityExplosiveMissile missile) {
        if (ConfigDebug.DEBUG_MISSILE_TRACKER) {
            String formatted = String.format("MissileTracker[%s]: Simulating missile: %s", missile.field_70170_p.field_73011_w.getDimension(), missile);
            ICBMClassic.logger().info(formatted);
        }
        if (!missile.field_70170_p.field_72995_K && missile.getMissileCapability().getTargetData() != null) {
            missile.getMissileCapability().setFlightLogic(null);
            MissileTrackerData mtd = new MissileTrackerData(missile);
            double dx = missile.getMissileCapability().getTargetData().getX() - missile.field_70165_t;
            double dz = missile.getMissileCapability().getTargetData().getZ() - missile.field_70161_v;
            double dst = Math.sqrt(dx * dx + dz * dz);
            mtd.ticksLeftToTarget = (int)Math.round(dst / 10.0);
            this.missileList.add(mtd);
            missile.func_70106_y();
            this.func_76185_a();
        }
    }

    public void onWorldTick(World world) {
        if (this.ticks++ >= 20) {
            this.ticks = 0;
            int mIndex = 0;
            Iterator missileIterator = this.missileList.iterator();
            while (missileIterator.hasNext()) {
                MissileTrackerData missile = (MissileTrackerData)missileIterator.next();
                if (missile.ticksLeftToTarget <= 0) {
                    if (this.chunkLoadTicket == null) {
                        this.chunkLoadTicket = ForgeChunkManager.requestTicket((Object)ICBMClassic.INSTANCE, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                        if (this.chunkLoadTicket != null) {
                            for (ChunkPos cp : this.chunkLoadTicket.getChunkList()) {
                                this.currentLoadedChunks.add(new LoadedChunkPair(cp, 60));
                            }
                        }
                    }
                    if (this.chunkLoadTicket != null) {
                        ChunkPos currentLoadedChunk = new ChunkPos((int)missile.targetPos.x() >> 4, (int)missile.targetPos.z() >> 4);
                        this.forceChunk(currentLoadedChunk, this.chunkLoadTicket);
                        currentLoadedChunk = new ChunkPos(1 + ((int)missile.targetPos.x() >> 4), (int)missile.targetPos.z() >> 4);
                        this.forceChunk(currentLoadedChunk, this.chunkLoadTicket);
                        currentLoadedChunk = new ChunkPos(-1 + ((int)missile.targetPos.x() >> 4), (int)missile.targetPos.z() >> 4);
                        this.forceChunk(currentLoadedChunk, this.chunkLoadTicket);
                        currentLoadedChunk = new ChunkPos((int)missile.targetPos.x() >> 4, 1 + ((int)missile.targetPos.z() >> 4));
                        this.forceChunk(currentLoadedChunk, this.chunkLoadTicket);
                        currentLoadedChunk = new ChunkPos((int)missile.targetPos.x() >> 4, -1 + ((int)missile.targetPos.z() >> 4));
                        this.forceChunk(currentLoadedChunk, this.chunkLoadTicket);
                    } else {
                        ICBMClassic.logger().warn("Unable to receive chunkloading ticket. You could try to increase the maximum loaded chunks for ICBM.");
                    }
                    missile.preLoadChunkTimer = 5;
                    this.missileSpawnList.add(missile);
                    missileIterator.remove();
                } else {
                    --missile.ticksLeftToTarget;
                    if (ConfigDebug.DEBUG_MISSILE_TRACKER) {
                        ICBMClassic.logger().log(Level.INFO, "MissileTracker Missile [" + mIndex + "]: Simulation ticks left: " + missile.ticksLeftToTarget);
                    }
                }
                ++mIndex;
            }
            for (int i = 0; i < this.currentLoadedChunks.size(); ++i) {
                ChunkPos chunkPos = this.currentLoadedChunks.get((int)i).chunkPos;
                int waitTime = this.currentLoadedChunks.get((int)i).timeLeft - 1;
                if (waitTime <= 0) {
                    if (MinecraftForge.EVENT_BUS.post((Event)new MissileChunkEvent.Unload(new LoadedChunkPair(chunkPos, waitTime), this.chunkLoadTicket))) continue;
                    ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkLoadTicket, (ChunkPos)chunkPos);
                    this.currentLoadedChunks.remove(i);
                    continue;
                }
                this.currentLoadedChunks.set(i, new LoadedChunkPair(chunkPos, waitTime));
            }
            Iterator spawnIterator = this.missileSpawnList.iterator();
            while (spawnIterator.hasNext()) {
                MissileTrackerData mtd = (MissileTrackerData)spawnIterator.next();
                --mtd.preLoadChunkTimer;
                if (mtd.preLoadChunkTimer > 0) continue;
                this.spawnMissileOnDestination(world, mtd);
                spawnIterator.remove();
            }
            this.func_76185_a();
        }
    }

    private void spawnMissileOnDestination(World world, MissileTrackerData mtd) {
        EntityExplosiveMissile missile = new EntityExplosiveMissile(world);
        missile.func_70037_a(mtd.missileData);
        missile.field_70163_u = 250.0;
        missile.field_70165_t = mtd.targetPos.x();
        missile.field_70161_v = mtd.targetPos.z();
        missile.field_70181_x = -2.0;
        missile.field_70179_y = 0.0;
        missile.field_70159_w = 0.0;
        missile.rotateTowardsMotion(1.0f);
        if (missile.getMissileCapability().getFlightLogic() == null) {
            missile.getMissileCapability().setFlightLogic(new DeadFlightLogic(100));
        }
        missile.getMissileCapability().launch();
        missile.world().func_72838_d((Entity)missile);
        if (ConfigDebug.DEBUG_MISSILE_TRACKER) {
            ICBMClassic.logger().info("MissileTracker[" + missile.field_70170_p.field_73011_w.getDimension() + "]: Missile spawned by missile tracker: " + missile);
        }
    }

    private void forceChunk(ChunkPos chunkPos, ForgeChunkManager.Ticket ticket) {
        for (int i = 0; i < this.currentLoadedChunks.size(); ++i) {
            if (this.currentLoadedChunks.get((int)i).chunkPos != chunkPos) continue;
            this.currentLoadedChunks.set(i, new LoadedChunkPair(chunkPos, 60));
            return;
        }
        LoadedChunkPair pair = new LoadedChunkPair(chunkPos, 60);
        if (!MinecraftForge.EVENT_BUS.post((Event)new MissileChunkEvent.Load(pair, ticket))) {
            this.currentLoadedChunks.add(pair);
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        MissileTrackerData mtd;
        NBTTagCompound missileSave;
        int i;
        NBTTagList list = nbt.func_150295_c("missiles", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            missileSave = list.func_150305_b(i);
            mtd = new MissileTrackerData(missileSave);
            this.missileList.add(mtd);
        }
        list = nbt.func_150295_c("spawns", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            missileSave = list.func_150305_b(i);
            mtd = new MissileTrackerData(missileSave);
            this.missileSpawnList.add(mtd);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagCompound compound;
        NBTTagList list = new NBTTagList();
        for (MissileTrackerData mtd : this.missileList) {
            compound = new NBTTagCompound();
            mtd.writeToNBT(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("missiles", (NBTBase)list);
        list = new NBTTagList();
        for (MissileTrackerData mtd : this.missileSpawnList) {
            compound = new NBTTagCompound();
            mtd.writeToNBT(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("spawns", (NBTBase)list);
        return nbt;
    }

    public void destroy() {
        this.missileList.clear();
        this.missileSpawnList.clear();
        this.chunkLoadTicket = null;
        this.currentLoadedChunks.clear();
    }
}

