/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.explosive.reg;

import icbm.classic.api.ICBMClassicAPI;
import icbm.classic.api.data.EntityTickFunction;
import icbm.classic.api.data.WorldEntityIntSupplier;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.api.reg.content.IExGrenadeRegistry;
import icbm.classic.content.reg.ItemReg;
import icbm.classic.lib.explosive.reg.ExplosiveContentRegistry;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.ResourceLocation;

public class ExGrenadeContentReg
extends ExplosiveContentRegistry
implements IExGrenadeRegistry {
    private final HashMap<ResourceLocation, WorldEntityIntSupplier> fuseSetSupplierMap = new HashMap();
    private final HashMap<ResourceLocation, EntityTickFunction> fuseTickCallbackMap = new HashMap();
    private final IntHashMap<WorldEntityIntSupplier> fuseSetSupplier = new IntHashMap();
    private final IntHashMap<EntityTickFunction> fuseTickCallback = new IntHashMap();

    public ExGrenadeContentReg() {
        super(ICBMClassicAPI.EX_GRENADE);
    }

    @Override
    public ItemStack getDeviceStack(ResourceLocation regName) {
        IExplosiveData ex = this.getExplosive(regName);
        if (ex != null) {
            return new ItemStack(ItemReg.itemGrenade, 1, ex.getRegistryID());
        }
        return null;
    }

    @Override
    public void lockRegistry() {
        if (this.isLocked()) {
            throw new RuntimeException(this + ": Registry was locked twice!");
        }
        super.lockRegistry();
        this.fuseSetSupplierMap.forEach((regName, func) -> {
            IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData((ResourceLocation)regName);
            if (data != null) {
                this.fuseSetSupplier.func_76038_a(data.getRegistryID(), func);
            }
        });
        this.fuseTickCallbackMap.forEach((regName, func) -> {
            IExplosiveData data = ICBMClassicAPI.EXPLOSIVE_REGISTRY.getExplosiveData((ResourceLocation)regName);
            if (data != null) {
                this.fuseTickCallback.func_76038_a(data.getRegistryID(), func);
            }
        });
    }

    @Override
    public void setFuseSupplier(ResourceLocation exName, WorldEntityIntSupplier fuseTimer) {
        this.fuseSetSupplierMap.put(exName, fuseTimer);
    }

    @Override
    public void setFuseTickListener(ResourceLocation exName, EntityTickFunction function) {
        this.fuseTickCallbackMap.put(exName, function);
    }

    @Override
    public void tickFuse(Entity entity, IExplosiveData data, int ticksExisted) {
        EntityTickFunction function = (EntityTickFunction)this.fuseTickCallback.func_76041_a(data != null ? data.getRegistryID() : 0);
        if (function != null) {
            function.onTick(entity, ticksExisted);
        }
    }

    @Override
    public int getFuseTime(Entity entity, IExplosiveData data) {
        WorldEntityIntSupplier function = (WorldEntityIntSupplier)this.fuseSetSupplier.func_76041_a(data != null ? data.getRegistryID() : 0);
        if (function != null) {
            return function.get(entity);
        }
        return 100;
    }
}

