/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.tracker;

import icbm.classic.lib.tracker.EventTrackerEntry;
import icbm.classic.lib.tracker.EventTrackerType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;

public class EventTrackerField<DATA> {
    private final ResourceLocation key;
    private final Type type;
    private int index;
    private EventTrackerType parent;
    private final Function<EventTrackerEntry, DATA> accessor;

    public EventTrackerField(ResourceLocation key, Type type, Function<EventTrackerEntry, DATA> accessor) {
        this.key = key;
        this.type = type;
        this.accessor = accessor;
    }

    public DATA get(EventTrackerEntry entry) {
        return Optional.ofNullable(this.accessor).map(f -> f.apply(entry)).orElse(null);
    }

    public EventTrackerField<DATA> copy() {
        return new EventTrackerField<DATA>(this.key, this.type, this.accessor);
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public Type getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public EventTrackerType getParent() {
        return this.parent;
    }

    void setParent(EventTrackerType parent) {
        this.parent = parent;
    }
}

