/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.lib.tracker;

import com.google.common.collect.ImmutableList;
import icbm.classic.lib.tracker.EventTrackerEntry;
import icbm.classic.lib.tracker.EventTrackerField;
import icbm.classic.lib.tracker.IEventTrackerListener;
import icbm.classic.lib.tracker.ListenerEntry;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class EventTrackerType {
    private int id;
    private final ResourceLocation name;
    private final boolean isError;
    private final boolean isWarn;
    private final List<EventTrackerField> fields;
    private final List<ListenerEntry> listeners;
    private final HashMap<ResourceLocation, EventTrackerField> keyToField = new HashMap();

    private EventTrackerType(ResourceLocation name, boolean isError, boolean isWarn, List<EventTrackerField> fields, List<ListenerEntry> listeners) {
        this.name = name;
        this.isError = isError;
        this.isWarn = isWarn;
        this.fields = fields;
        this.fields.forEach(field -> this.keyToField.put(field.getKey(), (EventTrackerField)field));
        this.listeners = listeners;
    }

    public <DATA> EventTrackerField<DATA> getField(int index) {
        return this.fields.get(index);
    }

    public <DATA> EventTrackerField<DATA> getField(ResourceLocation key) {
        return this.keyToField.get(key);
    }

    public String toString() {
        return String.format("%s(%s, %s)", this.getClass().getName(), this.id, this.name);
    }

    void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public boolean isError() {
        return this.isError;
    }

    public boolean isWarn() {
        return this.isWarn;
    }

    public List<ListenerEntry> getListeners() {
        return this.listeners;
    }

    public static final class Builder {
        private final ResourceLocation name;
        private boolean isError = false;
        private boolean isWarn = false;
        private List<EventTrackerField> fields = new ArrayList<EventTrackerField>();
        private List<ListenerEntry> listeners = new ArrayList<ListenerEntry>();

        public Builder(ResourceLocation name) {
            this.name = name;
        }

        public Builder asError() {
            this.isError = true;
            this.isWarn = false;
            return this;
        }

        public Builder asWarn() {
            this.isError = false;
            this.isWarn = true;
            return this;
        }

        public Builder with(EventTrackerField field) {
            this.fields.add(field);
            return this;
        }

        public Builder with(ResourceLocation key, Type type, Function<EventTrackerEntry, Object> accessor) {
            return this.with(new EventTrackerField<Object>(key, type, accessor));
        }

        public Builder withString(ResourceLocation key, Function<EventTrackerEntry, String> accessor) {
            return this.with(new EventTrackerField<String>(key, (Type)((Object)String.class), accessor));
        }

        public Builder withInt(ResourceLocation key, Function<EventTrackerEntry, Integer> accessor) {
            return this.with(new EventTrackerField<Integer>(key, (Type)((Object)Integer.class), accessor));
        }

        public Builder withDouble(ResourceLocation key, Function<EventTrackerEntry, Double> accessor) {
            return this.with(new EventTrackerField<Double>(key, (Type)((Object)Double.class), accessor));
        }

        public Builder withBlockPos(ResourceLocation prefix, Function<EventTrackerEntry, BlockPos> accessor) {
            return this.withInt(this.suffix(prefix, "x"), entry -> Optional.ofNullable(accessor.apply((EventTrackerEntry)entry)).map(Vec3i::func_177958_n).orElse(null)).withInt(this.suffix(prefix, "y"), entry -> Optional.ofNullable(accessor.apply((EventTrackerEntry)entry)).map(Vec3i::func_177956_o).orElse(null)).withInt(this.suffix(prefix, "z"), entry -> Optional.ofNullable(accessor.apply((EventTrackerEntry)entry)).map(Vec3i::func_177952_p).orElse(null));
        }

        public Builder withVec3d(ResourceLocation prefix, Function<EventTrackerEntry, Vec3d> accessor) {
            return this.withDouble(this.suffix(prefix, "x"), entry -> Optional.ofNullable(accessor.apply((EventTrackerEntry)entry)).map(v -> v.field_72450_a).orElse(null)).withDouble(this.suffix(prefix, "y"), entry -> Optional.ofNullable(accessor.apply((EventTrackerEntry)entry)).map(v -> v.field_72448_b).orElse(null)).withDouble(this.suffix(prefix, "z"), entry -> Optional.ofNullable(accessor.apply((EventTrackerEntry)entry)).map(v -> v.field_72449_c).orElse(null));
        }

        private ResourceLocation suffix(ResourceLocation prefix, String suffix) {
            return new ResourceLocation(prefix.func_110624_b(), prefix.func_110623_a() + "." + suffix);
        }

        public Builder listen(ResourceLocation name, IEventTrackerListener listener) {
            this.listeners.add(new ListenerEntry(name, listener));
            return this;
        }

        public Builder listen(ResourceLocation name, Supplier<Boolean> conditional, IEventTrackerListener listener) {
            this.listeners.add(new ListenerEntry(name, listener));
            return this;
        }

        public EventTrackerType build() {
            ImmutableList fields = ImmutableList.copyOf(this.fields);
            ImmutableList listeners = ImmutableList.copyOf(this.listeners);
            EventTrackerType type = new EventTrackerType(this.name, this.isError, this.isWarn, (List)fields, (List)listeners);
            for (int i = 0; i < fields.size(); ++i) {
                ((EventTrackerField)fields.get(i)).setIndex(i);
                ((EventTrackerField)fields.get(i)).setParent(type);
            }
            return type;
        }
    }
}

