/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.prefab.gui.button;

import icbm.classic.lib.data.FaceRotations;
import icbm.classic.prefab.gui.IGuiComponent;
import icbm.classic.prefab.gui.button.GuiButtonBase;
import icbm.classic.prefab.gui.tooltip.IToolTip;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class FaceRotationButton
extends GuiButtonBase<FaceRotationButton>
implements IGuiComponent,
IToolTip {
    public static final ITextComponent TOOLTIP = new TextComponentTranslation("gui.icbmclassic:button.face.tooltip", new Object[0]);
    private static final int WIDTH = 15;
    private static final int HEIGHT = 15;
    private final Supplier<EnumFacing> currentRotationGetter;
    private final Supplier<EnumFacing> blockFaceGetter;
    private EnumFacing prevSide;

    public FaceRotationButton(int buttonId, int x, int y, Supplier<EnumFacing> blockFaceGetter, Supplier<EnumFacing> currentRotationGetter, Consumer<EnumFacing> setter, Runnable networkCall) {
        super(buttonId, x, y, 15, 15, "-");
        this.blockFaceGetter = blockFaceGetter;
        this.currentRotationGetter = currentRotationGetter;
        this.setAction(() -> {
            setter.accept(this.rotate());
            networkCall.run();
        });
        this.setTooltip(() -> TOOLTIP);
    }

    protected EnumFacing rotate() {
        EnumFacing currentRotation = this.currentRotationGetter.get();
        EnumFacing blockFace = this.blockFaceGetter.get();
        if (GuiContainer.func_146272_n()) {
            return FaceRotations.rotateLeft(blockFace, currentRotation);
        }
        return FaceRotations.rotateRight(blockFace, currentRotation);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        EnumFacing side = this.currentRotationGetter.get();
        if (this.prevSide != side) {
            this.prevSide = side;
            this.field_146126_j = side.name().toUpperCase().substring(0, 1);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        return super.func_146116_c(mc, mouseX, mouseY) && (GuiContainer.func_175283_s() || GuiContainer.func_146272_n());
    }
}

