/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.client.gui.config;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.mcft.copy.backpacks.client.gui.Direction;
import net.mcft.copy.backpacks.client.gui.GuiContainer;
import net.mcft.copy.backpacks.client.gui.GuiElementBase;
import net.mcft.copy.backpacks.client.gui.GuiLayout;
import net.mcft.copy.backpacks.client.gui.config.IConfigEntry;
import net.mcft.copy.backpacks.client.gui.control.GuiButton;
import net.mcft.copy.backpacks.config.Status;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class BaseEntryList<T>
extends GuiLayout
implements IConfigEntry {
    protected final List<T> defaultValue;
    protected final List<T> previousValue;
    public final GuiLayout layoutList;
    public final GuiButton buttonAdd;

    public BaseEntryList(int width, List<T> defaultValue, List<T> previousValue) {
        super(Direction.VERTICAL);
        this.setCenteredHorizontal(width);
        this.defaultValue = defaultValue;
        this.previousValue = previousValue;
        this.layoutList = new GuiLayout(Direction.VERTICAL);
        this.layoutList.setFillHorizontal();
        this.buttonAdd = new GuiButton(0, 18, TextFormatting.GREEN + "+");
        this.buttonAdd.setFill();
        this.buttonAdd.setAction(this::addButtonPressed);
        this.addFixed(this.layoutList);
        this.addFixed(this.buttonAdd);
        this.setValue(previousValue);
    }

    protected abstract Entry<T> createListEntry();

    protected void addButtonPressed() {
        this.addEntry();
    }

    public void addEntry(T value) {
        this.addEntry().setValue(value);
    }

    public Entry<T> addEntry() {
        Entry<T> entry = this.createListEntry();
        this.layoutList.addFixed(entry);
        return entry;
    }

    public Stream<Entry<T>> getEntries() {
        return this.layoutList.getChildren().stream().filter(Entry.class::isInstance).map(Entry.class::cast);
    }

    public Stream<T> getValueAsStream() {
        return this.getEntries().map(Entry::getValue);
    }

    public List<T> getValue() {
        return this.getValueAsStream().collect(Collectors.toList());
    }

    public void setValue(List<T> value) {
        this.layoutList.clear();
        value.forEach(this::addEntry);
    }

    @Override
    public boolean isChanged() {
        return !BaseEntryList.iteratorEquals(this.getValueAsStream().iterator(), this.previousValue.iterator());
    }

    @Override
    public boolean isDefault() {
        return BaseEntryList.iteratorEquals(this.getValueAsStream().iterator(), this.defaultValue.iterator());
    }

    @Override
    public final boolean isValid() {
        return this.getEntries().allMatch(entry -> Status.getSeverity(entry.getStatus()) != Status.Severity.ERROR);
    }

    @Override
    public void undoChanges() {
        this.setValue(this.previousValue);
    }

    @Override
    public void setToDefault() {
        this.setValue(this.defaultValue);
    }

    private static boolean iteratorEquals(Iterator<?> it1, Iterator<?> it2) {
        while (it1.hasNext() && it2.hasNext()) {
            if (Objects.equals(it1.next(), it2.next())) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    public static abstract class Entry<T>
    extends GuiLayout {
        public final MoveButton buttonMove;
        public final GuiButton buttonRemove;

        public Entry(BaseEntryList<T> owningList) {
            super(Direction.HORIZONTAL);
            this.setFillHorizontal();
            this.buttonMove = new MoveButton();
            this.buttonRemove = new GuiButton(18, 18, TextFormatting.RED + "x");
            this.buttonRemove.setAction(() -> owningList.layoutList.remove(this));
        }

        public abstract T getValue();

        public abstract void setValue(T var1);

        public abstract List<Status> getStatus();

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)this.buttonMove.renderYOffset, (float)0.0f);
            Status.Severity severity = Status.getSeverity(this.getStatus());
            Entry.enableBlendAlphaStuffs();
            Entry.drawColoredRectARGB(-4, -1, this.getWidth() + 8, this.getHeight() + 2, severity.backgroundColor);
            Entry.disableBlendAlphaStuffs();
            super.draw(mouseX, mouseY, partialTicks);
            GlStateManager.func_179121_F();
        }

        public class MoveButton
        extends GuiButton {
            public static final int WIDTH = 12;
            protected int yOffset;
            protected float renderYOffset;

            public MoveButton() {
                super(12, 16, "=");
                this.yOffset = 0;
                this.renderYOffset = 0.0f;
                this.setCenteredVertical();
            }

            @Override
            public boolean canDrag() {
                return true;
            }

            @Override
            public void onDragged(int mouseX, int mouseY, int deltaX, int deltaY, int startX, int startY) {
                GuiContainer parent = Entry.this.getParent();
                List<GuiElementBase> elements = parent.getChildren();
                int currentIndex = elements.indexOf(Entry.this);
                int elementY = parent.getChildY(Entry.this);
                int elementHeight = Entry.this.getHeight();
                int elementCenter = elementY + elementHeight / 2;
                this.yOffset = Math.max(Math.min(mouseY - startY, parent.getHeight() - elementCenter), -elementCenter);
                int sign = Integer.signum(this.yOffset);
                while (sign != 0 && sign == Integer.signum(this.yOffset)) {
                    int targetIndex = currentIndex + sign;
                    if (this.yOffset < 0 ? targetIndex < 0 : targetIndex > elements.size() - 1) {
                        return;
                    }
                    Entry target = (Entry)elements.get(targetIndex);
                    if (!target.buttonMove.isEnabled()) {
                        return;
                    }
                    int targetY = parent.getChildY(target);
                    int targetHeight = target.getHeight();
                    if (this.yOffset < 0 ? elementY + this.yOffset > targetY + targetHeight / 4 : elementY + elementHeight + this.yOffset < targetY + targetHeight * 3 / 4) {
                        return;
                    }
                    int diff = targetY - elementY;
                    elementY += diff;
                    this.yOffset -= diff;
                    this.renderYOffset -= (float)diff;
                    target.buttonMove.renderYOffset += (float)diff;
                    parent.move(currentIndex, targetIndex);
                    currentIndex = targetIndex;
                }
            }

            @Override
            public void onMouseUp(int mouseButton, int mouseX, int mouseY) {
                this.yOffset = 0;
            }

            @Override
            public void draw(int mouseX, int mouseY, float partialTicks) {
                float speed = 0.25f;
                this.renderYOffset = this.renderYOffset * (1.0f - speed) + (float)this.yOffset * speed;
                super.draw(mouseX, mouseY, partialTicks);
            }
        }
    }
}

