/*
 * Decompiled with CFR 0.152.
 */
package net.mcft.copy.backpacks.misc.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public final class ReflectUtils {
    private static Map<Pair<Class<?>, String>, Field> _cachedFields = new HashMap();
    private static Map<Triple<Class<?>, String, Class<?>[]>, Method> _cachedMethods = new HashMap();

    private ReflectUtils() {
    }

    public static Field findField(Class<?> clazz, String mcpName, String srgName) {
        return _cachedFields.computeIfAbsent(Pair.of(clazz, (Object)mcpName), key -> {
            Field field = null;
            for (String name : new String[]{srgName, mcpName}) {
                try {
                    field = clazz.getDeclaredField(name);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                if (field == null) continue;
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException ex) {
                    throw new RuntimeException(ex);
                }
                return field;
            }
            throw new RuntimeException(String.format("Could not find field '%s'/'%s' for class %s", mcpName, srgName, clazz.getName()));
        });
    }

    public static <T, V> V get(Class<? extends T> clazz, T instance, String mcpName, String srgName) {
        try {
            return (V)ReflectUtils.findField(clazz, mcpName, srgName).get(instance);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T, V> V get(Class<T> clazz, String mcpName, String srgName) {
        return ReflectUtils.get(clazz, null, mcpName, srgName);
    }

    public static <T, V> V get(T instance, String mcpName, String srgName) {
        return ReflectUtils.get(instance.getClass(), instance, mcpName, srgName);
    }

    public static <T, V> void set(Class<? extends T> clazz, T instance, String mcpName, String srgName, V value) {
        try {
            ReflectUtils.findField(clazz, mcpName, srgName).set(instance, value);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <T, V> void set(Class<T> clazz, String mcpName, String srgName, V value) {
        ReflectUtils.set(clazz, null, mcpName, srgName, value);
    }

    public static <T, V> void set(T instance, String mcpName, String srgName, V value) {
        ReflectUtils.set(instance.getClass(), instance, mcpName, srgName, value);
    }

    public static Method findMethod(Class<?> clazz, String mcpName, String srgName, Class<?> ... parameterTypes) {
        return _cachedMethods.computeIfAbsent(Triple.of(clazz, (Object)mcpName, parameterTypes), key -> {
            for (String name : new String[]{srgName, mcpName}) {
                Method method;
                try {
                    method = clazz.getDeclaredMethod(name, parameterTypes);
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
                if (method == null) continue;
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException ex) {
                    throw new RuntimeException(ex);
                }
                return method;
            }
            throw new RuntimeException(String.format("Could not find method '%s'/'%s' for class %s", mcpName, srgName, clazz.getName()));
        });
    }
}

