/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.filter.IAEItemFilter;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WrapperFilteredItemHandler
implements IItemHandlerModifiable {
    private final IItemHandler handler;
    private final IAEItemFilter filter;

    public WrapperFilteredItemHandler(@Nonnull IItemHandler handler, @Nonnull IAEItemFilter filter) {
        this.handler = handler;
        this.filter = filter;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        ItemHandlerUtil.setStackInSlot(this.handler, slot, stack);
    }

    public int getSlots() {
        return this.handler.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.filter.allowInsert(this.handler, slot, stack)) {
            return stack;
        }
        return this.handler.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.filter.allowExtract(this.handler, slot, amount)) {
            return ItemStack.field_190927_a;
        }
        return this.handler.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.handler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (!this.filter.allowInsert(this.handler, slot, stack)) {
            return false;
        }
        return this.handler.isItemValid(slot, stack);
    }
}

