/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.command;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.integration.CompatibilityMgr;
import zmaster587.advancedRocketry.item.ItemData;
import zmaster587.advancedRocketry.item.ItemMultiData;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.network.PacketStellarInfo;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.unit.IngameTestOrchestrator;
import zmaster587.advancedRocketry.world.util.TeleporterNoPortal;
import zmaster587.advancedRocketry.world.util.TeleporterNoPortalSeekBlock;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class WorldCommand
implements ICommand {
    private List<String> aliases = new ArrayList<String>();

    public WorldCommand() {
        this.aliases.add("advancedRocketry");
        this.aliases.add("advRocketry");
    }

    @Nonnull
    public String func_71517_b() {
        return "advancedRocketry";
    }

    @Nonnull
    public String func_71518_a(@Nullable ICommandSender sender) {
        return "advancedRocketry help";
    }

    @Nonnull
    public List<String> func_71514_a() {
        return this.aliases;
    }

    private void commandAddTorch(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length >= 2 && cmdstring[1].equalsIgnoreCase("help")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.aliases.get(0) + " " + cmdstring[0] + " - Adds the currently held block to the list of objects that drop when there's no atmosphere"));
            return;
        }
        Entity player = sender.func_174793_f();
        if (!(player instanceof EntityPlayer)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Not a player entity"));
            return;
        }
        Block block = Block.func_149634_a((Item)((EntityPlayer)player).func_184614_ca().func_77973_b());
        if (block != Blocks.field_150350_a) {
            if (ARConfiguration.getCurrentConfig().torchBlocks.contains(block)) {
                sender.func_145747_a((ITextComponent)new TextComponentString(block.func_149732_F() + " is already in the torch list"));
            } else {
                ARConfiguration.getCurrentConfig().addTorchblock(block);
                sender.func_145747_a((ITextComponent)new TextComponentString(block.func_149732_F() + " added to the torch list"));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Held block cannot be added to torch list"));
        }
    }

    private void commandAddSolidBlockOverride(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length >= 2 && cmdstring[1].equalsIgnoreCase("help")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.aliases.get(0) + " " + cmdstring[0] + " - Adds the currently held block to the list of blocks that can hold a seal"));
            return;
        }
        Entity player = sender.func_174793_f();
        if (!(player instanceof EntityPlayer)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Not a player entity"));
            return;
        }
        Block block = Block.func_149634_a((Item)((EntityPlayer)player).func_184614_ca().func_77973_b());
        if (block != Blocks.field_150350_a) {
            if (ARConfiguration.getCurrentConfig().torchBlocks.contains(block)) {
                sender.func_145747_a((ITextComponent)new TextComponentString(block.func_149732_F() + " is already in the sealed blocks list"));
            } else {
                ARConfiguration.getCurrentConfig().addSealedBlock(block);
                sender.func_145747_a((ITextComponent)new TextComponentString(block.func_149732_F() + " added to the sealed block list"));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Held block cannot be added to sealed block list"));
        }
    }

    private void commandGiveStation(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length < 2 || cmdstring[1].equalsIgnoreCase("help")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.aliases.get(0) + " " + cmdstring[0] + " - Gives the player playerName (if supplied) a spacestation with ID stationID"));
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /advRocketry " + cmdstring[0] + " <stationId> [PlayerName]"));
            return;
        }
        EntityPlayer player = null;
        if (cmdstring.length >= 3) {
            player = this.getPlayerByName(cmdstring[2]);
            if (player == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Player " + cmdstring[2] + " not found"));
                return;
            }
        } else if (sender.func_174793_f() != null) {
            player = (EntityPlayer)sender;
        }
        if (player != null) {
            int stationId = Integer.parseInt(cmdstring[1]);
            ItemStack stack = new ItemStack(AdvancedRocketryItems.itemSpaceStationChip);
            ItemStationChip.setUUID(stack, stationId);
            player.field_71071_by.func_70441_a(stack);
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Usage: /advRocketry " + cmdstring[0] + " <stationId> [PlayerName]"));
        }
    }

    private void commandFillData(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length < 2) {
            return;
        }
        if (sender.func_174793_f() != null) {
            ItemStack stack = ((EntityPlayer)sender.func_174793_f()).func_184586_b(EnumHand.MAIN_HAND);
            if (cmdstring[1].equalsIgnoreCase("help")) {
                sender.func_145747_a((ITextComponent)new TextComponentString(this.aliases.get(0) + " " + cmdstring[0] + " [datatype] [amountFill]\n"));
                sender.func_145747_a((ITextComponent)new TextComponentString("Fills the amount of the data type specifies into the chip being held."));
                sender.func_145747_a((ITextComponent)new TextComponentString("If the datatype is not specified then command fills all datatypes, if no amountFill is specified completely fills the chip"));
                return;
            }
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemData) {
                DataStorage.DataType dataType;
                ItemData item = (ItemData)stack.func_77973_b();
                int dataAmount = item.getMaxData(stack.func_77952_i());
                try {
                    dataType = DataStorage.DataType.valueOf(cmdstring[1].toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Did you mean: /advRocketry" + cmdstring[0] + " [datatype] [amountFill]"));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Not a valid datatype"));
                    StringBuilder value = new StringBuilder();
                    for (DataStorage.DataType data : DataStorage.DataType.values()) {
                        if (data.name().equals("UNDEFINED")) continue;
                        value.append(data.name().toLowerCase()).append(", ");
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString("Try " + value));
                    return;
                }
                if (cmdstring.length >= 3) {
                    try {
                        dataAmount = Integer.parseInt(cmdstring[2]);
                    }
                    catch (NumberFormatException e) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Did you mean: /advRocketry" + cmdstring[0] + " [datatype] [amountFill]"));
                        sender.func_145747_a((ITextComponent)new TextComponentString("Not a valid number"));
                        return;
                    }
                }
                item.setData(stack, dataAmount, dataType);
                sender.func_145747_a((ITextComponent)new TextComponentString("Data filled!"));
            } else if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemMultiData) {
                DataStorage.DataType dataType;
                ItemMultiData item = (ItemMultiData)stack.func_77973_b();
                int dataAmount = item.getMaxData(stack);
                try {
                    dataType = DataStorage.DataType.valueOf(cmdstring[1].toUpperCase(Locale.ENGLISH));
                }
                catch (IllegalArgumentException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Did you mean: /advRocketry" + cmdstring[0] + " [datatype] [amountFill]"));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Not a valid datatype"));
                    StringBuilder value = new StringBuilder();
                    for (DataStorage.DataType data : DataStorage.DataType.values()) {
                        if (data.name().equals("UNDEFINED")) continue;
                        value.append(data.name().toLowerCase()).append(", ");
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString("Try " + value));
                    return;
                }
                if (cmdstring.length >= 3) {
                    try {
                        dataAmount = Integer.parseInt(cmdstring[2]);
                    }
                    catch (NumberFormatException e) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Did you mean: /advRocketry" + cmdstring[0] + " [datatype] [amountFill]"));
                        sender.func_145747_a((ITextComponent)new TextComponentString("Not a valid number"));
                        return;
                    }
                }
                item.setData(stack, dataAmount, dataType);
                sender.func_145747_a((ITextComponent)new TextComponentString("Data filled!"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Not Holding data item"));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("Ghosts don't have items!"));
        }
    }

    private void commandReloadRecipes(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length >= 2 && cmdstring[1].equalsIgnoreCase("help")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.aliases.get(0) + " " + cmdstring[0] + " - Reloads recipes from the XML files in the config folder"));
            return;
        }
        try {
            AdvancedRocketry.machineRecipes.clearAllMachineRecipes();
            AdvancedRocketry.machineRecipes.registerAllMachineRecipes();
            AdvancedRocketry.machineRecipes.createAutoGennedRecipes(AdvancedRocketry.modProducts);
            AdvancedRocketry.machineRecipes.registerXMLRecipes();
            sender.func_145747_a((ITextComponent)new TextComponentString("Recipes Reloaded"));
            CompatibilityMgr.reloadRecipes();
        }
        catch (Exception e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Serious error has occured!  Possible recipe corruption"));
            sender.func_145747_a((ITextComponent)new TextComponentString("Please check logs!"));
            sender.func_145747_a((ITextComponent)new TextComponentString("You may be able to recify this error by repairing the XML and/or"));
            sender.func_145747_a((ITextComponent)new TextComponentString("restarting the game"));
        }
    }

    private void commandSetGravity(ICommandSender sender, String[] cmdstring) {
        block10: {
            if (cmdstring.length >= 2) {
                if (cmdstring[1].equalsIgnoreCase("help")) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[0] + " <amount> - sets your gravity to amount where 1 is earthlike"));
                    return;
                }
                if (sender instanceof Entity) {
                    Object player = cmdstring.length > 2 ? sender.func_184102_h().func_184103_al().func_152612_a(cmdstring[2]) : (Entity)sender;
                    if (player != null) {
                        try {
                            double d = Double.parseDouble(cmdstring[1]);
                            if (d == 0.0) {
                                AdvancedRocketryAPI.gravityManager.clearGravityEffect((Entity)player);
                                break block10;
                            }
                            AdvancedRocketryAPI.gravityManager.setGravityMultiplier((Entity)sender, d);
                        }
                        catch (NumberFormatException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[1] + " is not a valid number"));
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Not a valid player"));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Not a valid player"));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(this.aliases.get(0) + " " + cmdstring[0] + " gravity_multiplier [playerName]"));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("use 0 as the gravity_multiplier to allow regular planet gravity to take over"));
            }
        }
    }

    private void commandGoto(ICommandSender sender, String[] cmdstring) {
        block11: {
            EntityPlayer player;
            if (sender instanceof Entity && (player = sender.func_130014_f_().func_72924_a(sender.func_70005_c_())) != null) {
                if (cmdstring.length < 2 || cmdstring[1].equalsIgnoreCase("help")) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[0] + " <dimId> - teleports the player to the supplied dimension"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[0] + " station <station ID> - teleports the player to the supplied station"));
                    return;
                }
                try {
                    if (cmdstring.length == 2) {
                        int dim = Integer.parseInt(cmdstring[1]);
                        if (net.minecraftforge.common.DimensionManager.isDimensionRegistered((int)dim)) {
                            if (net.minecraftforge.common.DimensionManager.getWorld((int)dim) == null) {
                                net.minecraftforge.common.DimensionManager.initDimension((int)dim);
                            }
                            player.func_184102_h().func_184103_al().transferPlayerToDimension((EntityPlayerMP)player, dim, (Teleporter)new TeleporterNoPortalSeekBlock(net.minecraftforge.common.DimensionManager.getWorld((int)dim)));
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("Dimension does not exist"));
                        }
                        break block11;
                    }
                    if (!cmdstring[1].equalsIgnoreCase("station")) break block11;
                    int dim = ARConfiguration.getCurrentConfig().spaceDimId;
                    int stationId = Integer.parseInt(cmdstring[2]);
                    ISpaceObject spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStation(stationId);
                    if (spaceObject != null) {
                        if (player.field_70170_p.field_73011_w.getDimension() != ARConfiguration.getCurrentConfig().spaceDimId) {
                            player.func_184102_h().func_184103_al().transferPlayerToDimension((EntityPlayerMP)player, dim, (Teleporter)new TeleporterNoPortal((WorldServer)player.field_70170_p));
                        }
                        HashedBlockPosition vec = spaceObject.getSpawnLocation();
                        player.func_70634_a((double)vec.x, (double)vec.y, (double)vec.z);
                        break block11;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString("Station " + stationId + " does not exist!"));
                }
                catch (NumberFormatException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[0] + " <dimId>"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[0] + "station <station ID>"));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Must be a player to use this command"));
            }
        }
    }

    private void commandFetch(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length < 2) {
            return;
        }
        EntityPlayer me = (EntityPlayer)sender.func_174793_f();
        EntityPlayer player = this.getPlayerByName(cmdstring[1]);
        System.out.println(cmdstring[1] + "   " + sender.func_174793_f());
        if (player == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid player name: " + cmdstring[1]));
        } else {
            player.func_184102_h().func_184103_al().transferPlayerToDimension((EntityPlayerMP)player, me.field_70170_p.field_73011_w.getDimension(), (Teleporter)new TeleporterNoPortal(me.func_184102_h().func_71218_a(me.field_70170_p.field_73011_w.getDimension())));
            player.func_70107_b(me.field_70165_t, me.field_70163_u, me.field_70161_v);
        }
    }

    private void commandPlanetList(ICommandSender sender, String[] cmdstring) {
        sender.func_145747_a((ITextComponent)new TextComponentString("Dimensions:"));
        Integer[] integerArray = DimensionManager.getInstance().getRegisteredDimensions();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            sender.func_145747_a((ITextComponent)new TextComponentString("DIM" + i2 + ":  " + DimensionManager.getInstance().getDimensionProperties(i2).getName()));
        }
    }

    private void commandPlanetHelp(ICommandSender sender, String[] cmdstring) {
        sender.func_145747_a((ITextComponent)new TextComponentString("Planet:"));
        sender.func_145747_a((ITextComponent)new TextComponentString("planet delete [dimid]"));
        sender.func_145747_a((ITextComponent)new TextComponentString("planet generate [starId] (moon/gas) [name] [atmosphere randomness] [distance Randomness] [gravity randomness] (atmosphere base) (distance base) (gravity base)"));
        sender.func_145747_a((ITextComponent)new TextComponentString("planet list"));
        sender.func_145747_a((ITextComponent)new TextComponentString("planet reset [dimid]"));
        sender.func_145747_a((ITextComponent)new TextComponentString("planet set [property]"));
        sender.func_145747_a((ITextComponent)new TextComponentString("planet get [property]"));
    }

    private void commandPlanetReset(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length == 3) {
            try {
                int dimId = Integer.parseInt(cmdstring[2]);
                DimensionManager.getInstance().getDimensionProperties(dimId).resetProperties();
                PacketHandler.sendToAll((BasePacket)new PacketDimInfo(dimId, DimensionManager.getInstance().getDimensionProperties(dimId)));
            }
            catch (NumberFormatException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid dimId"));
            }
        } else if (cmdstring.length == 2) {
            if (sender.func_174793_f() != null) {
                int dimId = sender.func_130014_f_().field_73011_w.getDimension();
                if (DimensionManager.getInstance().isDimensionCreated(dimId)) {
                    DimensionManager.getInstance().getDimensionProperties(dimId).resetProperties();
                    PacketHandler.sendToAll((BasePacket)new PacketDimInfo(dimId, DimensionManager.getInstance().getDimensionProperties(dimId)));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Please specify dimension ID"));
            }
        }
    }

    private void commandPlanetDelete(ICommandSender sender, String[] cmdstring) {
        block8: {
            if (cmdstring.length == 3) {
                try {
                    int deletedDimId = Integer.parseInt(cmdstring[2]);
                    if (DimensionManager.getInstance().isDimensionCreated(deletedDimId)) {
                        if (net.minecraftforge.common.DimensionManager.getWorld((int)deletedDimId) == null || net.minecraftforge.common.DimensionManager.getWorld((int)deletedDimId).field_73010_i.isEmpty()) {
                            DimensionManager.getInstance().deleteDimension(deletedDimId);
                            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(deletedDimId, null));
                            sender.func_145747_a((ITextComponent)new TextComponentString("Dim " + deletedDimId + " deleted!"));
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString("World still has players:"));
                            for (EntityPlayer player : net.minecraftforge.common.DimensionManager.getWorld((int)deletedDimId).field_73010_i) {
                                sender.func_145747_a(player.func_145748_c_());
                            }
                        }
                        break block8;
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString("Dimension does not exist"));
                }
                catch (NumberFormatException exception) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Invalid Argument"));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[0] + " " + cmdstring[1] + " " + cmdstring[2] + " <dimid>"));
            }
        }
    }

    private void commandPlanetGenerate(ICommandSender sender, String[] cmdstring) {
        int gasOffset = 0;
        boolean gassy = false;
        boolean moon = false;
        int starId = 0;
        if (cmdstring.length > 2) {
            try {
                starId = Integer.parseInt(cmdstring[2]);
                ++gasOffset;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (cmdstring.length > 2 + gasOffset) {
            if (cmdstring[2 + gasOffset].equalsIgnoreCase("moon")) {
                ++gasOffset;
                moon = true;
                if (!DimensionManager.getInstance().isDimensionCreated(starId)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Invalid planet ID"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[0] + " " + cmdstring[1] + "[planetId] [moon] [gas] <name> <atmosphereRandomness> <distanceRandomness> <gravityRandomness>"));
                    return;
                }
            } else if (DimensionManager.getInstance().getStar(starId) == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid star ID"));
                sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[0] + " " + cmdstring[1] + "[starId] [gas] <name> <atmosphereRandomness> <distanceRandomness> <gravityRandomness>"));
                return;
            }
        }
        if (cmdstring.length > 2 + gasOffset && cmdstring[2 + gasOffset].equalsIgnoreCase("gas")) {
            ++gasOffset;
            gassy = true;
        }
        try {
            if (cmdstring.length == 6 + gasOffset) {
                DimensionProperties properties;
                int planetId = starId;
                if (moon) {
                    starId = DimensionManager.getInstance().getDimensionProperties(planetId).getStarId();
                }
                if ((properties = !gassy ? DimensionManager.getInstance().generateRandom(starId, cmdstring[2 + gasOffset], Integer.parseInt(cmdstring[3 + gasOffset]), Integer.parseInt(cmdstring[4 + gasOffset]), Integer.parseInt(cmdstring[5 + gasOffset])) : DimensionManager.getInstance().generateRandomGasGiant(starId, cmdstring[2 + gasOffset], Integer.parseInt(cmdstring[3 + gasOffset]), Integer.parseInt(cmdstring[4 + gasOffset]), Integer.parseInt(cmdstring[5 + gasOffset]), 1, 1, 1)) == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Dimension: " + cmdstring[2 + gasOffset] + " failed to generate!"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Dimension: " + cmdstring[2 + gasOffset] + " Generated!"));
                }
                if (moon) {
                    properties.setParentPlanet(DimensionManager.getInstance().getDimensionProperties(planetId));
                    DimensionManager.getInstance().getStar(starId).removePlanet(properties);
                }
                sender.func_145747_a((ITextComponent)new TextComponentString("Dimension Generated!"));
            } else if (cmdstring.length == 9 + gasOffset) {
                DimensionProperties properties;
                int planetId = starId;
                if (moon) {
                    starId = DimensionManager.getInstance().getDimensionProperties(planetId).getStarId();
                }
                if ((properties = !gassy ? DimensionManager.getInstance().generateRandom(starId, cmdstring[2 + gasOffset], Integer.parseInt(cmdstring[3 + gasOffset]), Integer.parseInt(cmdstring[4 + gasOffset]), Integer.parseInt(cmdstring[5 + gasOffset]), Integer.parseInt(cmdstring[6 + gasOffset]), Integer.parseInt(cmdstring[7 + gasOffset]), Integer.parseInt(cmdstring[8 + gasOffset])) : DimensionManager.getInstance().generateRandomGasGiant(starId, cmdstring[2 + gasOffset], Integer.parseInt(cmdstring[3 + gasOffset]), Integer.parseInt(cmdstring[4 + gasOffset]), Integer.parseInt(cmdstring[5 + gasOffset]), Integer.parseInt(cmdstring[6 + gasOffset]), Integer.parseInt(cmdstring[7 + gasOffset]), Integer.parseInt(cmdstring[8 + gasOffset]))) == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Dimension: " + cmdstring[2 + gasOffset] + " failed to generate!"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Dimension: " + cmdstring[2 + gasOffset] + " Generated!"));
                }
                if (moon) {
                    properties.setParentPlanet(DimensionManager.getInstance().getDimensionProperties(planetId));
                    DimensionManager.getInstance().getStar(starId).removePlanet(properties);
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[0] + " " + cmdstring[1] + " [starId] [moon] [gas] <name> <atmosphereRandomness> <distanceRandomness> <gravityRandomness>"));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[0] + " " + cmdstring[1] + " [starId] [moon] [gas] <name> <atmosphere base value> <distance base value> <gravity base value> <atmosphereRandomness> <distanceRandomness> <gravityRandomness>"));
            }
        }
        catch (NumberFormatException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[0] + " " + cmdstring[1] + " [starId] [moon] [gas] <name> <atmosphereRandomness> <distanceRandomness> <gravityRandomness>"));
            sender.func_145747_a((ITextComponent)new TextComponentString(""));
            sender.func_145747_a((ITextComponent)new TextComponentString(cmdstring[0] + " " + cmdstring[1] + " [starId] [moon] [gas] <name> <atmosphere base value> <distance base value> <gravity base value> <atmosphereRandomness> <distanceRandomness> <gravityRandomness>"));
        }
    }

    private void commandPlanetSet(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length < 3) {
            return;
        }
        int dimId = sender.func_130014_f_().field_73011_w.getDimension();
        if (!DimensionManager.getInstance().isDimensionCreated(dimId)) {
            return;
        }
        int commandOffset = 0;
        if (cmdstring.length > 3) {
            try {
                dimId = Integer.parseInt(cmdstring[2]);
                commandOffset = 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!DimensionManager.getInstance().isDimensionCreated(dimId)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid Dimensions"));
            return;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(dimId);
        try {
            if (cmdstring[2 + commandOffset].equalsIgnoreCase("atmosphereDensity")) {
                properties.setAtmosphereDensityDirect(Integer.parseUnsignedInt(cmdstring[3 + commandOffset]));
                sender.func_145747_a((ITextComponent)new TextComponentString("Setting " + cmdstring[2 + commandOffset] + " for dimension " + dimId + " to " + cmdstring[3 + commandOffset]));
            } else {
                Field field = properties.getClass().getDeclaredField(cmdstring[2 + commandOffset]);
                if (field.getType().isArray()) {
                    int i;
                    StringBuilder outString;
                    Object[] var;
                    if (Float.TYPE == field.getType().getComponentType() && cmdstring.length - 3 - commandOffset == (var = (float[])field.get(properties)).length) {
                        outString = new StringBuilder();
                        for (i = 0; i < var.length; ++i) {
                            var[i] = Float.parseFloat(cmdstring[3 + i + commandOffset]);
                            outString.append(cmdstring[3 + i + commandOffset]).append(" ");
                        }
                        field.set(properties, var);
                        sender.func_145747_a((ITextComponent)new TextComponentString("Setting " + cmdstring[2 + commandOffset] + " for dimension " + dimId + " to " + outString));
                    }
                    if (Integer.TYPE == field.getType().getComponentType() && cmdstring.length - 3 - commandOffset == (var = (Object[])((int[])field.get(properties))).length) {
                        outString = new StringBuilder();
                        for (i = 0; i < var.length; ++i) {
                            var[i] = Integer.parseInt(cmdstring[3 + i + commandOffset]);
                            outString.append(cmdstring[3 + i + commandOffset]).append(" ");
                        }
                        field.set(properties, var);
                        sender.func_145747_a((ITextComponent)new TextComponentString("Setting " + cmdstring[2 + commandOffset] + " for dimension " + dimId + " to " + outString));
                    }
                } else {
                    if (Integer.TYPE == field.getType()) {
                        field.set(properties, Integer.parseInt(cmdstring[3 + commandOffset]));
                    } else if (Float.TYPE == field.getType()) {
                        field.set(properties, Float.valueOf(Float.parseFloat(cmdstring[3 + commandOffset])));
                    } else if (Double.TYPE == field.getType()) {
                        field.set(properties, Double.parseDouble(cmdstring[3 + commandOffset]));
                    } else if (Boolean.TYPE == field.getType()) {
                        field.set(properties, Boolean.parseBoolean(cmdstring[3 + commandOffset]));
                    } else {
                        field.set(properties, cmdstring[3 + commandOffset]);
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentString("Setting " + cmdstring[2 + commandOffset] + " for dimension " + dimId + " to " + cmdstring[3 + commandOffset]));
                }
            }
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(dimId, properties));
        }
        catch (NumberFormatException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid Argument for parameter " + cmdstring[2 + commandOffset]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void commandPlanetGet(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length < 3) {
            return;
        }
        int dimId = sender.func_130014_f_().field_73011_w.getDimension();
        if (!DimensionManager.getInstance().isDimensionCreated(dimId)) {
            return;
        }
        int commandOffset = 0;
        if (cmdstring.length > 3) {
            try {
                dimId = Integer.parseInt(cmdstring[2]);
                commandOffset = 1;
            }
            catch (NumberFormatException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Invalid Dimensions"));
            }
        }
        if (!DimensionManager.getInstance().isDimensionCreated(dimId)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Invalid Dimensions"));
            return;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(dimId);
        if (cmdstring[2 + commandOffset].equalsIgnoreCase("atmosphereDensity")) {
            sender.func_145747_a((ITextComponent)new TextComponentString(Integer.toString(properties.getAtmosphereDensity())));
        } else {
            try {
                Field field = properties.getClass().getDeclaredField(cmdstring[2 + commandOffset]);
                sender.func_145747_a((ITextComponent)new TextComponentString(field.get(properties).toString()));
            }
            catch (Exception e) {
                e.printStackTrace();
                sender.func_145747_a((ITextComponent)new TextComponentString("An error has occured, please check logs"));
            }
        }
    }

    private void commandStarGet(ICommandSender sender, String[] cmdstring) {
        try {
            int id = Integer.parseInt(cmdstring[3]);
            StellarBody star = DimensionManager.getInstance().getStar(id);
            if (star == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Error: " + cmdstring[3] + " is not a valid star ID"));
            } else if (cmdstring[2].equalsIgnoreCase("temp")) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Temp: " + star.getTemperature()));
            } else if (cmdstring[2].equalsIgnoreCase("planets")) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Planets orbiting the star:"));
                for (IDimensionProperties planets : star.getPlanets()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("ID: " + planets.getId() + " : " + planets.getName()));
                }
            } else if (cmdstring[2].equalsIgnoreCase("pos")) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Pos: " + star.getPosX() + "," + star.getPosZ()));
            }
        }
        catch (NumberFormatException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Error: " + cmdstring[3] + " is not a valid star ID"));
        }
    }

    private void commandStarSet(ICommandSender sender, String[] cmdstring) {
        try {
            int id = Integer.parseInt(cmdstring[3]);
            StellarBody star = DimensionManager.getInstance().getStar(id);
            if (star == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Error: " + cmdstring[3] + " is not a valid star ID"));
            } else if (cmdstring[2].equalsIgnoreCase("temp")) {
                try {
                    star.setTemperature(Integer.parseInt(cmdstring[4]));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Temp set to " + star.getTemperature()));
                }
                catch (NumberFormatException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("star set temp <starId> <temp>"));
                }
            } else if (cmdstring.length > 5 && cmdstring[2].equalsIgnoreCase("pos")) {
                try {
                    int x = Integer.parseInt(cmdstring[4]);
                    int z = Integer.parseInt(cmdstring[5]);
                    star.setPosX(x);
                    star.setPosZ(z);
                    sender.func_145747_a((ITextComponent)new TextComponentString("Position set to " + x + "," + z));
                }
                catch (NumberFormatException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("star set pos <starId> <x> <y>"));
                }
            }
        }
        catch (NumberFormatException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Error: " + cmdstring[3] + " is not a valid star ID"));
        }
    }

    private void commandBiomeDump(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length >= 2 && cmdstring[1].compareToIgnoreCase("help") == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Developer command: Dumps biome info to BiomeDump.txt!"));
            return;
        }
        try {
            File file = new File("./BiomeDump.txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.append("ID\tResource name\n");
            for (ResourceLocation resource : Biome.field_185377_q.func_148742_b()) {
                writer.append(String.valueOf(Biome.func_185362_a((Biome)((Biome)Biome.field_185377_q.func_82594_a((Object)resource))))).append("\t").append(resource.toString()).append("\n");
            }
            writer.close();
            sender.func_145747_a((ITextComponent)new TextComponentString("The File \"BiomeDump.txt\" has been written to the current directory"));
        }
        catch (Exception e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("An error has occured writing to the file"));
        }
    }

    private void commandStarGenerate(ICommandSender sender, String[] cmdstring) {
        try {
            String name = cmdstring[2];
            int temp = Integer.parseInt(cmdstring[3]);
            int x = Integer.parseInt(cmdstring[4]);
            int z = Integer.parseInt(cmdstring[5]);
            StellarBody star = new StellarBody();
            star.setTemperature(temp);
            star.setPosX(x);
            star.setPosZ(z);
            star.setName(name);
            star.setId(DimensionManager.getInstance().getNextFreeStarId());
            if (star.getId() != -1) {
                DimensionManager.getInstance().addStar(star);
                PacketHandler.sendToAll((BasePacket)new PacketStellarInfo(star.getId(), star));
                sender.func_145747_a((ITextComponent)new TextComponentString("star Added!"));
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString("Why can't I hold all these stars! (either you have an insane number of stars or something really broke!)"));
            }
        }
        catch (NumberFormatException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString("star generate <name> <temp> <x> <y>"));
        }
    }

    private void commandBeginTest(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length >= 2 && cmdstring[1].compareToIgnoreCase("help") == 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Developer command: Runs system tests, debug only!"));
            return;
        }
        if (sender.func_174793_f() != null) {
            if (!IngameTestOrchestrator.registered) {
                MinecraftForge.EVENT_BUS.register((Object)IngameTestOrchestrator.instance);
            }
            EntityPlayer player = (EntityPlayer)sender;
            IngameTestOrchestrator.runTests(player.func_130014_f_(), player);
        }
    }

    private void commandPlanet(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length < 2) {
            this.commandPlanetHelp(sender, cmdstring);
            return;
        }
        switch (cmdstring[1]) {
            case "reset": {
                this.commandPlanetReset(sender, cmdstring);
                break;
            }
            case "list": {
                this.commandPlanetList(sender, cmdstring);
                break;
            }
            case "delete": {
                this.commandPlanetDelete(sender, cmdstring);
                break;
            }
            case "generate": {
                this.commandPlanetGenerate(sender, cmdstring);
                break;
            }
            case "set": {
                this.commandPlanetSet(sender, cmdstring);
                break;
            }
            case "get": {
                this.commandPlanetGet(sender, cmdstring);
                break;
            }
            default: {
                this.commandPlanetHelp(sender, cmdstring);
            }
        }
    }

    private void commandStar(ICommandSender sender, String[] cmdstring) {
        if (cmdstring.length > 1) {
            if (cmdstring[1].equalsIgnoreCase("list")) {
                for (StellarBody star : DimensionManager.getInstance().getStars()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(String.format("Star ID: %d   Name: %s  Num Planets: %d", star.getId(), star.getName(), star.getNumPlanets())));
                }
            } else if (cmdstring[1].equalsIgnoreCase("help")) {
                this.printStarHelp(sender);
            }
        }
        if (cmdstring.length > 3 && cmdstring[1].equalsIgnoreCase("get")) {
            this.commandStarGet(sender, cmdstring);
        }
        if (cmdstring.length > 4 && cmdstring[1].equalsIgnoreCase("set")) {
            this.commandStarSet(sender, cmdstring);
        }
        if (cmdstring.length > 5 && cmdstring[1].equalsIgnoreCase("generate")) {
            this.commandStarGenerate(sender, cmdstring);
        }
    }

    @ParametersAreNonnullByDefault
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] string) {
        int opLevel = 2;
        if (string.length == 0 || string[0].equalsIgnoreCase("help")) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Subcommands:"));
            sender.func_145747_a((ITextComponent)new TextComponentString("planet"));
            sender.func_145747_a((ITextComponent)new TextComponentString("filldata"));
            sender.func_145747_a((ITextComponent)new TextComponentString("goto"));
            sender.func_145747_a((ITextComponent)new TextComponentString("star"));
            sender.func_145747_a((ITextComponent)new TextComponentString("fetch"));
            sender.func_145747_a((ITextComponent)new TextComponentString("giveStation"));
            sender.func_145747_a((ITextComponent)new TextComponentString("reloadRecipes"));
            sender.func_145747_a((ITextComponent)new TextComponentString("setGravity"));
            sender.func_145747_a((ITextComponent)new TextComponentString("addTorch"));
            sender.func_145747_a((ITextComponent)new TextComponentString("[Enter /advRocketry <subcommand> help for more info]"));
        }
        switch (string[0]) {
            case "dumpBiomes": {
                this.commandBiomeDump(sender, string);
                break;
            }
            case "beginTest": {
                this.commandBeginTest(sender, string);
                break;
            }
            case "addTorch": {
                this.commandAddTorch(sender, string);
                break;
            }
            case "addSolidBlockOverride": {
                this.commandAddSolidBlockOverride(sender, string);
                break;
            }
            case "givestation": {
                this.commandGiveStation(sender, string);
                break;
            }
            case "filldata": {
                this.commandFillData(sender, string);
                break;
            }
            case "reloadRecipes": {
                this.commandReloadRecipes(sender, string);
                break;
            }
            case "setGravity": {
                this.commandSetGravity(sender, string);
                break;
            }
            case "goto": {
                this.commandGoto(sender, string);
                break;
            }
            case "fetch": {
                this.commandFetch(sender, string);
                break;
            }
            case "planet": {
                this.commandPlanet(sender, string);
                break;
            }
            case "star": {
                this.commandStar(sender, string);
            }
        }
    }

    private void printStarHelp(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString("star list"));
        sender.func_145747_a((ITextComponent)new TextComponentString("star get temp <star id>"));
        sender.func_145747_a((ITextComponent)new TextComponentString("star get planets <star id>"));
        sender.func_145747_a((ITextComponent)new TextComponentString("star get pos <star id>"));
        sender.func_145747_a((ITextComponent)new TextComponentString("star set temp <star id> <temperature>"));
        sender.func_145747_a((ITextComponent)new TextComponentString("star set pos <star id> <x> <y>"));
        sender.func_145747_a((ITextComponent)new TextComponentString("star generate <name> <temp> <x> <y>"));
    }

    public boolean func_184882_a(@Nonnull MinecraftServer server, ICommandSender sender) {
        return sender.func_70003_b(2, this.func_71517_b());
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] string, @Nullable BlockPos targetPos) {
        ArrayList<String> list = new ArrayList<String>();
        if (string.length == 1) {
            list.add("beginTest");
            list.add("planet");
            list.add("goto");
            list.add("fetch");
            list.add("star");
            list.add("filldata");
            list.add("setGravity");
            list.add("reloadRecipes");
            list.add("givestation");
            list.add("dumpBiomes");
            list.add("addTorch");
            list.add("addSolidBlockOverride");
        } else if (string.length == 2) {
            ArrayList<String> list2 = new ArrayList<String>();
            list2.add("get");
            list2.add("set");
            list2.add("list");
            list2.add("generate");
            if (string[0].equalsIgnoreCase("planet")) {
                list2.add("reset");
                list2.add("new");
                list2.add("delete");
                for (String str : list2) {
                    if (!str.startsWith(string[1])) continue;
                    list.add(str);
                }
            }
        } else if ((string[1].equalsIgnoreCase("get") || string[1].equalsIgnoreCase("set")) && string[0].equalsIgnoreCase("planet") && string.length == 3) {
            for (Field field : DimensionProperties.class.getFields()) {
                if (!field.getName().startsWith(string[2])) continue;
                list.add(field.getName());
            }
            list.add("atmosphereDensity");
        }
        return list;
    }

    public boolean func_82358_a(@Nonnull String[] string, int number) {
        return number == 1 && string[0].equalsIgnoreCase("fetch");
    }

    public int compareTo(ICommand arg0) {
        return this.func_71517_b().compareTo(arg0.func_71517_b());
    }

    private EntityPlayer getPlayerByName(String name) {
        WorldServer world;
        EntityPlayer player = null;
        WorldServer[] worldServerArray = net.minecraftforge.common.DimensionManager.getWorlds();
        int n = worldServerArray.length;
        for (int i = 0; i < n && (player = (world = worldServerArray[i]).func_72924_a(name)) == null; ++i) {
        }
        return player;
    }
}

