/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.tile.multiblock.orbitallaserdrill.AbstractDrill;

class VoidDrill
extends AbstractDrill {
    private final Random random = new Random();
    private List<ItemStack> ores;
    private boolean planetOresInitialized = false;

    VoidDrill() {
        this.loadGlobalOres();
    }

    private void loadGlobalOres() {
        if (this.ores == null && !ARConfiguration.getCurrentConfig().standardLaserDrillOres.isEmpty()) {
            this.ores = new ArrayList<ItemStack>();
            for (int i = 0; i < ARConfiguration.getCurrentConfig().standardLaserDrillOres.size(); ++i) {
                String name;
                String oreDictName = ARConfiguration.getCurrentConfig().standardLaserDrillOres.get(i);
                String[] args = oreDictName.split(":");
                NonNullList globalOres = OreDictionary.getOres((String)args[0]);
                if (globalOres != null && !globalOres.isEmpty()) {
                    int amt = 5;
                    if (args.length > 1) {
                        try {
                            amt = Integer.parseInt(args[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    this.ores.add(new ItemStack(((ItemStack)globalOres.get(0)).func_77973_b(), amt, ((ItemStack)globalOres.get(0)).func_77952_i()));
                    continue;
                }
                String[] splitStr = oreDictName.split(":");
                try {
                    name = splitStr[0] + ":" + splitStr[1];
                }
                catch (IndexOutOfBoundsException e) {
                    AdvancedRocketry.logger.warn("Unexpected ore name: \"" + oreDictName + "\" during laser drill harvesting");
                    continue;
                }
                int meta = 0;
                int size = 1;
                if (splitStr.length > 2) {
                    try {
                        meta = Integer.parseInt(splitStr[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (splitStr.length > 3) {
                    try {
                        size = Integer.parseInt(splitStr[3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ItemStack stack = ItemStack.field_190927_a;
                Block block = Block.func_149684_b((String)name);
                if (block == null) {
                    Item item = Item.func_111206_d((String)name);
                    if (item != null) {
                        stack = new ItemStack(item, size, meta);
                    }
                } else {
                    stack = new ItemStack(block, size, meta);
                }
                if (stack.func_190926_b()) continue;
                this.ores.add(stack);
            }
        }
    }

    @Override
    ItemStack[] performOperation() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (this.random.nextInt(10) == 0) {
            ItemStack item = this.ores.get(this.random.nextInt(this.ores.size()));
            ItemStack newStack = item.func_77946_l();
            items.add(newStack);
        } else {
            items.add(new ItemStack(Blocks.field_150347_e, 5));
        }
        ItemStack[] stacks = new ItemStack[items.size()];
        stacks = items.toArray(stacks);
        return stacks;
    }

    @Override
    boolean activate(World world, int x, int z) {
        if (!this.planetOresInitialized) {
            DimensionProperties dimProperties = DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.getDimension());
            this.ores.addAll(dimProperties.laserDrillOres.stream().filter(s -> !this.ores.contains(s)).collect(Collectors.toSet()));
            this.planetOresInitialized = true;
        }
        return true;
    }

    @Override
    void deactivate() {
    }

    @Override
    boolean isFinished() {
        return false;
    }

    @Override
    boolean needsRestart() {
        return false;
    }
}

