/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.gui.container;

import cofh.core.gui.slot.ISlotValidator;
import cofh.core.gui.slot.SlotLocked;
import cofh.core.gui.slot.SlotRemoveOnly;
import cofh.core.gui.slot.SlotValidated;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.thermalfoundation.gui.container.InventoryLexiconTransmute;
import cofh.thermalfoundation.network.PacketTFBase;
import cofh.thermalfoundation.util.LexiconManager;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerLexiconTransmute
extends Container
implements ISlotValidator {
    public static final byte ORE_PREV = 0;
    public static final byte ORE_NEXT = 1;
    public static final byte NAME_PREV = 2;
    public static final byte NAME_NEXT = 3;
    public static final byte TRANSMUTE = 4;
    ArrayList<ItemStack> oreList;
    ArrayList<String> nameList;
    int oreSelection = -1;
    int nameSelection = -1;
    String oreName = "Unknown";
    ItemStack oreStack = ItemStack.field_190927_a;
    boolean syncClient = false;
    public InventoryLexiconTransmute lexiconInv = new InventoryLexiconTransmute(this);

    public ContainerLexiconTransmute(InventoryPlayer inventory) {
        this.bindPlayerInventory(inventory);
        this.func_75146_a((Slot)new SlotValidated((ISlotValidator)this, (IInventory)this.lexiconInv, 0, 59, 61));
        this.func_75146_a((Slot)new SlotRemoveOnly((IInventory)this.lexiconInv, 1, 131, 61));
        this.func_75146_a((Slot)new SlotLocked((IInventory)this.lexiconInv, 2, 95, 33));
        this.func_75130_a(this.lexiconInv);
    }

    protected void bindPlayerInventory(InventoryPlayer inventory) {
        int i;
        int xOffset = 23;
        int yOffset = 114;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (i == inventory.field_70461_c) {
                this.func_75146_a((Slot)new SlotLocked((IInventory)inventory, i, xOffset + i * 18, yOffset + 58));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)inventory, i, xOffset + i * 18, yOffset + 58));
        }
    }

    private String getCommonOreName(ItemStack ore1, ItemStack ore2) {
        ArrayList nameList1 = OreDictionaryArbiter.getAllOreNames((ItemStack)ore1);
        ArrayList nameList2 = OreDictionaryArbiter.getAllOreNames((ItemStack)ore2);
        for (String name1 : nameList1) {
            for (String name2 : nameList2) {
                if (!name1.equals(name2)) continue;
                return name1;
            }
        }
        return "Unknown";
    }

    private boolean equivalentOres(ItemStack ore1, ItemStack ore2) {
        if (ore1.func_190926_b() || ore2.func_190926_b()) {
            return false;
        }
        ArrayList nameList1 = OreDictionaryArbiter.getAllOreNames((ItemStack)ore1);
        ArrayList nameList2 = OreDictionaryArbiter.getAllOreNames((ItemStack)ore2);
        if (nameList1.isEmpty() || nameList2.isEmpty()) {
            return false;
        }
        for (String name1 : nameList1) {
            for (String name2 : nameList2) {
                if (!name1.equals(name2)) continue;
                return true;
            }
        }
        return false;
    }

    public String getOreName() {
        return this.oreName;
    }

    public boolean canTransmute() {
        ItemStack input = this.lexiconInv.func_70301_a(0);
        if (input.func_190926_b() || !LexiconManager.validOre(input)) {
            return false;
        }
        ItemStack entry = this.lexiconInv.func_70301_a(2);
        if (entry.func_190926_b() || !LexiconManager.validOre(entry)) {
            return false;
        }
        if (input.func_77969_a(entry)) {
            return false;
        }
        if (!this.equivalentOres(input, entry)) {
            return false;
        }
        ItemStack output = this.lexiconInv.func_70301_a(1);
        return output.func_190926_b() || output.equals(entry) && output.func_190916_E() < output.func_77976_d();
    }

    public boolean doTransmute() {
        if (!this.canTransmute()) {
            return false;
        }
        ItemStack input = this.lexiconInv.func_70301_a(0);
        ItemStack output = this.lexiconInv.func_70301_a(1);
        ItemStack entry = this.lexiconInv.func_70301_a(2);
        this.oreStack = ItemHelper.cloneStack((ItemStack)entry, (int)1);
        if (output.func_190926_b()) {
            output = ItemHelper.cloneStack((ItemStack)entry, (int)input.func_190916_E());
            input = ItemStack.field_190927_a;
        } else if (output.func_190916_E() + input.func_190916_E() > output.func_77976_d()) {
            int diff = output.func_77976_d() - output.func_190916_E();
            output.func_190920_e(output.func_77976_d());
            input.func_190918_g(diff);
        } else {
            output.func_190917_f(input.func_190916_E());
            input = ItemStack.field_190927_a;
        }
        this.lexiconInv.func_70299_a(1, output);
        this.lexiconInv.func_70299_a(0, input);
        return true;
    }

    public boolean hasMultipleOres() {
        return this.oreList != null && this.oreList.size() > 1;
    }

    public boolean hasMultipleNames() {
        return this.nameList != null && this.nameList.size() > 1;
    }

    public void prevOre() {
        this.oreSelection += this.oreList.size() - 1;
        this.oreSelection %= this.oreList.size();
        this.lexiconInv.func_70299_a(2, this.oreList.get(this.oreSelection));
    }

    public void nextOre() {
        ++this.oreSelection;
        this.oreSelection %= this.oreList.size();
        this.lexiconInv.func_70299_a(2, this.oreList.get(this.oreSelection));
    }

    public void prevName() {
        this.nameSelection += this.nameList.size() - 1;
        this.nameSelection %= this.nameList.size();
        this.oreName = this.nameList.get(this.nameSelection);
        this.oreList = OreDictionaryArbiter.getOres((String)this.oreName);
        this.oreSelection %= this.oreList.size();
        this.lexiconInv.func_70299_a(2, this.oreList.get(this.oreSelection));
        this.syncClient = true;
    }

    public void nextName() {
        ++this.nameSelection;
        this.nameSelection %= this.nameList.size();
        this.oreName = this.nameList.get(this.nameSelection);
        this.oreList = OreDictionaryArbiter.getOres((String)this.oreName);
        this.oreSelection %= this.oreList.size();
        this.lexiconInv.func_70299_a(2, this.oreList.get(this.oreSelection));
        this.syncClient = true;
    }

    public void handlePacket(PacketTFBase payload) {
        switch (payload.getByte()) {
            case 0: {
                this.prevOre();
                return;
            }
            case 1: {
                this.nextOre();
                return;
            }
            case 2: {
                this.prevName();
                return;
            }
            case 3: {
                this.nextName();
                return;
            }
            case 4: {
                this.doTransmute();
                return;
            }
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            if (!this.syncClient) continue;
            listener.func_71112_a((Container)this, 0, this.nameSelection);
            listener.func_71112_a((Container)this, 1, this.oreSelection);
            this.syncClient = false;
        }
    }

    public void func_75137_b(int i, int j) {
        if (i == 0) {
            this.nameSelection = j;
            this.oreName = this.nameList.get(this.nameSelection);
            this.oreList = OreDictionaryArbiter.getOres((String)this.oreName);
        } else if (i == 1) {
            this.oreSelection = j;
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.lexiconInv.func_70300_a(player);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        ItemStack stack = this.lexiconInv.func_70304_b(0);
        if (!stack.func_190926_b() && !this.func_75135_a(stack, 0, 36, false)) {
            player.func_71019_a(stack, false);
        }
        if (!(stack = this.lexiconInv.func_70304_b(1)).func_190926_b() && !this.func_75135_a(stack, 0, 36, false)) {
            player.func_71019_a(stack, false);
        }
    }

    public void func_75130_a(IInventory inventory) {
        super.func_75130_a(inventory);
        ItemStack input = inventory.func_70301_a(0);
        if (!input.func_190926_b() && ItemHelper.hasOreName((ItemStack)input)) {
            if (!this.equivalentOres(input, this.oreStack)) {
                this.nameList = OreDictionaryArbiter.getAllOreNames((ItemStack)input);
                if (this.nameList.isEmpty()) {
                    return;
                }
                this.oreName = this.nameList.get(0);
                this.oreList = OreDictionaryArbiter.getOres((String)this.oreName);
                this.nameSelection = 0;
                this.oreSelection = 0;
                this.oreStack = ItemHelper.cloneStack((ItemStack)this.oreList.get(this.oreSelection), (int)1);
                inventory.func_70299_a(2, this.oreList.get(this.oreSelection));
            } else {
                this.nameList = OreDictionaryArbiter.getAllOreNames((ItemStack)input);
                if (this.nameList.isEmpty()) {
                    return;
                }
                this.oreName = this.getCommonOreName(input, this.oreStack);
                this.oreList = OreDictionaryArbiter.getOres((String)this.oreName);
                this.nameSelection = 0;
                this.oreSelection %= this.oreList.size();
                for (int i = 0; i < this.nameList.size(); ++i) {
                    if (!this.oreName.equals(this.nameList.get(i))) continue;
                    this.nameSelection = i;
                    break;
                }
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int invPlayer = 27;
        int invFull = invPlayer + 9;
        int invTile = invFull + 1;
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (slotIndex < invFull ? !this.func_75135_a(stackInSlot, invFull, invTile, false) : !this.func_75135_a(stackInSlot, 0, invFull, true)) {
                return ItemStack.field_190927_a;
            }
            if (stackInSlot.func_190916_E() <= 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
        }
        return stack;
    }

    protected boolean func_75135_a(ItemStack stack, int slotMin, int slotMax, boolean ascending) {
        ItemStack stackInSlot;
        Slot slot;
        int k;
        boolean slotFound = false;
        int n = k = ascending ? slotMax - 1 : slotMin;
        if (stack.func_77985_e()) {
            while (stack.func_190916_E() > 0 && (!ascending && k < slotMax || ascending && k >= slotMin)) {
                slot = (Slot)this.field_75151_b.get(k);
                stackInSlot = slot.func_75211_c();
                if (slot.func_75214_a(stack) && ItemHelper.itemsEqualWithMetadata((ItemStack)stack, (ItemStack)stackInSlot, (boolean)true)) {
                    int slotLimit;
                    int l = stackInSlot.func_190916_E() + stack.func_190916_E();
                    if (l <= (slotLimit = Math.min(stack.func_77976_d(), slot.func_75219_a()))) {
                        stack.func_190920_e(0);
                        stackInSlot.func_190920_e(l);
                        slot.func_75218_e();
                        slotFound = true;
                    } else if (stackInSlot.func_190916_E() < slotLimit) {
                        stack.func_190918_g(slotLimit - stackInSlot.func_190916_E());
                        stackInSlot.func_190920_e(slotLimit);
                        slot.func_75218_e();
                        slotFound = true;
                    }
                }
                k += ascending ? -1 : 1;
            }
        }
        if (stack.func_190916_E() > 0) {
            int n2 = k = ascending ? slotMax - 1 : slotMin;
            while (!ascending && k < slotMax || ascending && k >= slotMin) {
                slot = (Slot)this.field_75151_b.get(k);
                stackInSlot = slot.func_75211_c();
                if (slot.func_75214_a(stack) && stackInSlot.func_190926_b()) {
                    slot.func_75215_d(ItemHelper.cloneStack((ItemStack)stack, (int)Math.min(stack.func_190916_E(), slot.func_75219_a())));
                    slot.func_75218_e();
                    if (slot.func_75211_c().func_190926_b()) break;
                    stack.func_190918_g(slot.func_75211_c().func_190916_E());
                    slotFound = true;
                    break;
                }
                k += ascending ? -1 : 1;
            }
        }
        return slotFound;
    }

    public boolean isItemValid(ItemStack stack) {
        return ItemHelper.hasOreName((ItemStack)stack);
    }
}

