/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders;

import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntity;
import com.supermartijn642.chunkloaders.ChunkLoaderBlockEntityRenderer;
import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.ChunkLoadersConfig;
import com.supermartijn642.chunkloaders.screen.ChunkLoaderScreen;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ChunkLoadersClient {
    private static KeyBinding CHUNK_LOADING_SCREEN_KEY;

    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"chunkloaders");
        for (ChunkLoaderType type : ChunkLoaderType.values()) {
            handler.registerCustomBlockEntityRenderer(type::getBlockEntityType, () -> new ChunkLoaderBlockEntityRenderer((Block)type.getBlock(), type.getFullRotation()));
        }
    }

    public static void setup() {
        CHUNK_LOADING_SCREEN_KEY = new KeyBinding("chunkloaders.keys.open_screen", 46, "chunkloaders.keys.category");
        ClientRegistry.registerKeyBinding((KeyBinding)CHUNK_LOADING_SCREEN_KEY);
    }

    @SubscribeEvent
    public static void onKey(InputEvent.KeyInputEvent e) {
        if (CHUNK_LOADING_SCREEN_KEY != null && CHUNK_LOADING_SCREEN_KEY.func_151468_f() && ClientUtils.getWorld() != null && ClientUtils.getMinecraft().field_71462_r == null) {
            EntityPlayer player = ClientUtils.getPlayer();
            if (ChunkLoadersConfig.canPlayersUseMap.get().booleanValue()) {
                ClientUtils.displayScreen((GuiScreen)WidgetScreen.of((Widget)new ChunkLoaderScreen(new ChunkPos(player.func_180425_c()), player.func_110124_au(), player.func_180425_c().func_177956_o(), 15, 11)));
            } else {
                player.func_146105_b(TextComponents.translation((String)"chunkloaders.gui.disabled").color(TextFormatting.RED).get(), true);
            }
        }
    }

    public static void openChunkLoaderScreen(ChunkLoaderBlockEntity entity) {
        int size = entity.getChunkLoaderType().getGridSize() + 2;
        ClientUtils.displayScreen((GuiScreen)WidgetScreen.of((Widget)new ChunkLoaderScreen(new ChunkPos(entity.func_174877_v()), entity.getOwner(), entity.func_174877_v().func_177956_o(), size, size)));
    }
}

