/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.ByteBufAdapterRegistry;
import info.loenwind.autoconfig.factory.FactoryManager;
import info.loenwind.autoconfig.factory.IValueFactory;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketConfigSync
implements IMessage {
    @Nullable
    protected IValueFactory factory;
    @Nullable
    protected String modid;
    @Nullable
    protected String section;
    @Nullable
    protected ByteBuf bufferCopy;

    public PacketConfigSync() {
        this.factory = null;
    }

    PacketConfigSync(IValueFactory factory) {
        this.factory = factory;
    }

    public void toBytes(@Nullable ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.factory.getModid());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.factory.getSection());
        ByteBufAdapterRegistry.saveMapping(buf);
        this.factory.save(buf);
    }

    public void fromBytes(@Nullable ByteBuf buf) {
        this.modid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.section = ByteBufUtils.readUTF8String((ByteBuf)buf);
        ByteBufAdapterRegistry.loadMapping(buf);
        this.bufferCopy = buf.copy();
    }

    public static class Handler
    implements IMessageHandler<PacketConfigSync, IMessage> {
        public IMessage onMessage(@Nullable PacketConfigSync message, @Nullable MessageContext ctx) {
            if (!Minecraft.func_71410_x().func_71387_A()) {
                FactoryManager.read(message.modid, message.section, message.bufferCopy);
            }
            if (message.bufferCopy != null) {
                message.bufferCopy.release();
            }
            return null;
        }
    }
}

