/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.scanners;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.lib.chunk.ClientChunkCache;
import org.orecruncher.lib.math.MathStuff;

@SideOnly(value=Side.CLIENT)
public final class CeilingCoverage
implements ITickable {
    private static final int SURVEY_INTERVAL = 4;
    private static final int INSIDE_SURVEY_RANGE = 3;
    private static final float INSIDE_THRESHOLD = 0.6306818f;
    private static final Cell[] cells;
    private static final float TOTAL_POINTS;
    private boolean reallyInside = false;

    public void func_73660_a() {
        if (EnvironStateHandler.EnvironState.getTickCounter() % 4 == 0) {
            if (EnvironStateHandler.EnvironState.getDimensionId() == -1 || EnvironStateHandler.EnvironState.getDimensionInfo().alwaysOutside()) {
                this.reallyInside = false;
            } else {
                BlockPos pos = EnvironStateHandler.EnvironState.getPlayerPosition();
                float score = 0.0f;
                for (Cell cell : cells) {
                    score += cell.score(pos);
                }
                float ceilingCoverageRatio = 1.0f - score / TOTAL_POINTS;
                this.reallyInside = ceilingCoverageRatio > 0.6306818f;
            }
        }
    }

    public boolean isReallyInside() {
        return this.reallyInside;
    }

    static {
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                cellList.add(new Cell(new Vec3i(x, 0, z), 3));
            }
        }
        Collections.sort(cellList);
        cells = cellList.toArray(new Cell[0]);
        float totalPoints = 0.0f;
        for (Cell c : cellList) {
            totalPoints += c.potentialPoints();
        }
        TOTAL_POINTS = totalPoints;
    }

    private static final class Cell
    implements Comparable<Cell> {
        private final Vec3i offset;
        private final float points;
        private final BlockPos.MutableBlockPos working;

        public Cell(@Nonnull Vec3i offset, int range) {
            this.offset = offset;
            float xV = range - MathStuff.abs((int)offset.func_177958_n()) + 1;
            float zV = range - MathStuff.abs((int)offset.func_177952_p()) + 1;
            float candidate = Math.min(xV, zV);
            this.points = candidate * candidate;
            this.working = new BlockPos.MutableBlockPos();
        }

        public float potentialPoints() {
            return this.points;
        }

        public float score(@Nonnull BlockPos playerPos) {
            this.working.func_181079_c(playerPos.func_177958_n() + this.offset.func_177958_n(), playerPos.func_177956_o() + this.offset.func_177956_o(), playerPos.func_177952_p() + this.offset.func_177952_p());
            World world = EnvironStateHandler.EnvironState.getWorld();
            int playerHeight = Math.max(playerPos.func_177956_o() + 1, 0);
            this.working.func_189533_g((Vec3i)ClientChunkCache.instance().getPrecipitationHeight((BlockPos)this.working));
            while (this.working.func_177956_o() > playerHeight) {
                IBlockState state = ClientChunkCache.instance().func_180495_p((BlockPos)this.working);
                if (state.func_185904_a().func_76230_c() && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)this.working) && !state.func_177230_c().isFoliage((IBlockAccess)world, (BlockPos)this.working)) {
                    return 0.0f;
                }
                this.working.func_185336_p(this.working.func_177956_o() - 1);
            }
            return this.points;
        }

        @Override
        public int compareTo(@Nonnull Cell cell) {
            return -Float.compare(this.potentialPoints(), cell.potentialPoints());
        }

        @Nonnull
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.offset.toString());
            builder.append(" points: ").append(this.points);
            return builder.toString();
        }
    }
}

