/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.common.property.Properties;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.WDBlockContainer;
import net.montoyo.wd.core.DefaultUpgrade;
import net.montoyo.wd.core.IUpgrade;
import net.montoyo.wd.data.SetURLData;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.item.WDItem;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Multiblock;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3f;
import net.montoyo.wd.utilities.Vector3i;

public class BlockScreen
extends WDBlockContainer {
    public static final PropertyBool hasTE = PropertyBool.func_177716_a((String)"haste");
    public static final PropertyBool emitting = PropertyBool.func_177716_a((String)"emitting");
    private static final IProperty[] properties = new IProperty[]{hasTE, emitting};
    public static final IUnlistedProperty<Integer>[] sideFlags = new IUnlistedProperty[6];
    private static final int BAR_BOT = 1;
    private static final int BAR_RIGHT = 2;
    private static final int BAR_TOP = 4;
    private static final int BAR_LEFT = 8;

    public BlockScreen() {
        super(Material.field_151576_e);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149647_a(WebDisplays.CREATIVE_TAB);
        this.setName("screen");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)hasTE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)emitting, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, properties, sideFlags);
    }

    public static boolean isntScreenBlock(IBlockAccess world, Vector3i pos) {
        return world.func_180495_p(pos.toBlock()).func_177230_c() != WebDisplays.INSTANCE.blockScreen;
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, IBlockAccess world, BlockPos bpos) {
        IExtendedBlockState ret = (IExtendedBlockState)this.field_176227_L.func_177621_b();
        Vector3i pos = new Vector3i(bpos);
        for (BlockSide side : BlockSide.values()) {
            int icon = 0;
            if (BlockScreen.isntScreenBlock(world, side.up.clone().add(pos))) {
                icon |= 4;
            }
            if (BlockScreen.isntScreenBlock(world, side.down.clone().add(pos))) {
                icon |= 1;
            }
            if (BlockScreen.isntScreenBlock(world, side.left.clone().add(pos))) {
                icon |= 8;
            }
            if (BlockScreen.isntScreenBlock(world, side.right.clone().add(pos))) {
                icon |= 2;
            }
            ret = ret.withProperty(sideFlags[side.ordinal()], (Object)icon);
        }
        return ret;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)hasTE, (Comparable)Boolean.valueOf((meta & 1) != 0)).func_177226_a((IProperty)emitting, (Comparable)Boolean.valueOf((meta & 2) != 0));
    }

    public int func_176201_c(IBlockState state) {
        int ret = 0;
        if (((Boolean)state.func_177229_b((IProperty)hasTE)).booleanValue()) {
            ret |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)emitting)).booleanValue()) {
            ret |= 2;
        }
        return ret;
    }

    public boolean func_180639_a(World world, BlockPos bpos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            heldItem = null;
        } else if (!(heldItem.func_77973_b() instanceof IUpgrade)) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        boolean sneaking = player.func_70093_af();
        Vector3i pos = new Vector3i(bpos);
        BlockSide side = BlockSide.values()[facing.ordinal()];
        Multiblock.findOrigin((IBlockAccess)world, pos, side, null);
        TileEntityScreen te = (TileEntityScreen)world.func_175625_s(pos.toBlock());
        if (te != null && te.getScreen(side) != null) {
            TileEntityScreen.Screen scr = te.getScreen(side);
            if (sneaking) {
                if ((scr.rightsFor(player) & 1) == 0) {
                    Util.toast(player, "restrictions", new Object[0]);
                } else {
                    new SetURLData(pos, scr.side, scr.url).sendTo((EntityPlayerMP)player);
                }
                return true;
            }
            if (heldItem != null && !te.hasUpgrade(side, heldItem)) {
                if ((scr.rightsFor(player) & 0x10) == 0) {
                    Util.toast(player, "restrictions", new Object[0]);
                    return true;
                }
                if (te.addUpgrade(side, heldItem, player, false)) {
                    if (!player.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                    Util.toast(player, TextFormatting.AQUA, "upgradeOk", new Object[0]);
                    if (player instanceof EntityPlayerMP) {
                        WebDisplays.INSTANCE.criterionUpgradeScreen.trigger(((EntityPlayerMP)player).func_192039_O());
                    }
                } else {
                    Util.toast(player, "upgradeError", new Object[0]);
                }
                return true;
            }
            if ((scr.rightsFor(player) & 2) == 0) {
                Util.toast(player, "restrictions", new Object[0]);
                return true;
            }
            Vector2i tmp = new Vector2i();
            if (BlockScreen.hit2pixels(side, bpos, pos, scr, hitX, hitY, hitZ, tmp)) {
                te.click(side, tmp);
            }
            return true;
        }
        if (sneaking) {
            Util.toast(player, "turnOn", new Object[0]);
            return true;
        }
        Vector2i size = Multiblock.measure((IBlockAccess)world, pos, side);
        if (size.x < 2 || size.y < 2) {
            Util.toast(player, "tooSmall", new Object[0]);
            return true;
        }
        if (size.x > WebDisplays.INSTANCE.maxScreenX || size.y > WebDisplays.INSTANCE.maxScreenY) {
            Util.toast(player, "tooBig", WebDisplays.INSTANCE.maxScreenX, WebDisplays.INSTANCE.maxScreenY);
            return true;
        }
        Vector3i err = Multiblock.check((IBlockAccess)world, pos, size, side);
        if (err != null) {
            Util.toast(player, "invalid", err.toString());
            return true;
        }
        boolean created = false;
        Log.info("Player %s (UUID %s) created a screen at %s of size %dx%d", player.func_70005_c_(), player.func_146103_bH().getId().toString(), pos.toString(), size.x, size.y);
        if (te == null) {
            BlockPos bp = pos.toBlock();
            world.func_175656_a(bp, world.func_180495_p(bp).func_177226_a((IProperty)hasTE, (Comparable)Boolean.valueOf(true)));
            te = (TileEntityScreen)world.func_175625_s(bp);
            created = true;
        }
        te.addScreen(side, size, null, player, !created);
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos source) {
        if (block != this && !world.field_72995_K && !((Boolean)state.func_177229_b((IProperty)emitting)).booleanValue()) {
            for (BlockSide side : BlockSide.values()) {
                Vector3i vec = new Vector3i(pos);
                Multiblock.findOrigin((IBlockAccess)world, vec, side, null);
                TileEntityScreen tes = (TileEntityScreen)world.func_175625_s(vec.toBlock());
                if (tes == null || !tes.hasUpgrade(side, DefaultUpgrade.REDSTONE_INPUT)) continue;
                EnumFacing facing = EnumFacing.field_82609_l[side.reverse().ordinal()];
                vec.sub(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).neg();
                tes.updateJSRedstone(side, new Vector2i(vec.dot(side.right), vec.dot(side.up)), world.func_175651_c(pos, facing));
            }
        }
    }

    public static boolean hit2pixels(BlockSide side, BlockPos bpos, Vector3i pos, TileEntityScreen.Screen scr, float hitX, float hitY, float hitZ, Vector2i dst) {
        if (side.right.x < 0) {
            hitX -= 1.0f;
        }
        if (side.right.z < 0 || side == BlockSide.TOP || side == BlockSide.BOTTOM) {
            hitZ -= 1.0f;
        }
        Vector3f rel = new Vector3f(bpos.func_177958_n(), bpos.func_177956_o(), bpos.func_177952_p());
        rel.sub(pos.x, pos.y, pos.z);
        rel.add(hitX, hitY, hitZ);
        float cx = rel.dot(side.right.toFloat()) - 0.125f;
        float cy = rel.dot(side.up.toFloat()) - 0.125f;
        float sw = (float)scr.size.x - 0.25f;
        float sh = (float)scr.size.y - 0.25f;
        cx /= sw;
        cy /= sh;
        if (cx >= 0.0f && (double)cx <= 1.0 && cy >= 0.0f && cy <= 1.0f) {
            if (side != BlockSide.BOTTOM) {
                cy = 1.0f - cy;
            }
            switch (scr.rotation) {
                case ROT_90: {
                    cy = 1.0f - cy;
                    break;
                }
                case ROT_180: {
                    cx = 1.0f - cx;
                    cy = 1.0f - cy;
                    break;
                }
                case ROT_270: {
                    cx = 1.0f - cx;
                    break;
                }
            }
            cx *= (float)scr.resolution.x;
            cy *= (float)scr.resolution.y;
            if (scr.rotation.isVertical) {
                dst.x = (int)cy;
                dst.y = (int)cx;
            } else {
                dst.x = (int)cx;
                dst.y = (int)cy;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        if ((meta & 1) == 0) {
            return null;
        }
        return (meta & 1) == 0 ? null : new TileEntityScreen();
    }

    private void onDestroy(World world, BlockPos pos, EntityPlayer ply) {
        if (!world.field_72995_K) {
            Vector3i bp = new Vector3i(pos);
            Multiblock.BlockOverride override = new Multiblock.BlockOverride(bp, Multiblock.OverrideAction.SIMULATE);
            for (BlockSide bs : BlockSide.values()) {
                this.destroySide(world, bp.clone(), bs, override, ply);
            }
        }
    }

    private void destroySide(World world, Vector3i pos, BlockSide side, Multiblock.BlockOverride override, EntityPlayer source) {
        Multiblock.findOrigin((IBlockAccess)world, pos, side, override);
        BlockPos bp = pos.toBlock();
        TileEntity te = world.func_175625_s(bp);
        if (te != null && te instanceof TileEntityScreen) {
            ((TileEntityScreen)te).onDestroy(source);
            world.func_175656_a(bp, world.func_180495_p(bp).func_177226_a((IProperty)hasTE, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer ply, boolean willHarvest) {
        this.onDestroy(world, pos, ply);
        return super.removedByPlayer(state, world, pos, ply, willHarvest);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        this.onDestroy(world, pos, null);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase whoDidThisShit, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        Multiblock.BlockOverride override = new Multiblock.BlockOverride(new Vector3i(pos), Multiblock.OverrideAction.IGNORE);
        Vector3i[] neighbors = new Vector3i[]{new Vector3i(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()), new Vector3i(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()), new Vector3i(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()), new Vector3i(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()), new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1), new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1)};
        for (Vector3i neighbor : neighbors) {
            if (!(world.func_180495_p(neighbor.toBlock()).func_177230_c() instanceof BlockScreen)) continue;
            for (BlockSide bs : BlockSide.values()) {
                this.destroySide(world, neighbor.clone(), bs, override, whoDidThisShit instanceof EntityPlayer ? (EntityPlayer)whoDidThisShit : null);
            }
        }
    }

    @Nonnull
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.IGNORE;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return (Boolean)state.func_177229_b((IProperty)emitting) != false ? 15 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)emitting);
    }

    @Override
    protected ItemBlock createItemBlock() {
        return new ItemBlockScreen(this);
    }

    static {
        for (int i = 0; i < sideFlags.length; ++i) {
            BlockScreen.sideFlags[i] = Properties.toUnlisted((IProperty)PropertyInteger.func_177719_a((String)("neighbor" + i), (int)0, (int)15));
        }
    }

    private static class ItemBlockScreen
    extends ItemBlock
    implements WDItem {
        public ItemBlockScreen(BlockScreen screen) {
            super((Block)screen);
        }

        @Override
        @Nullable
        public String getWikiName(@Nonnull ItemStack is) {
            return "Screen";
        }

        public void func_77624_a(@Nullable ItemStack is, @Nullable World world, @Nullable List<String> tt, @Nullable ITooltipFlag ttFlags) {
            super.func_77624_a(is, world, tt, ttFlags);
            WDItem.addInformation(tt);
        }
    }
}

