/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.StringJoiner;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.IJSQueryCallback;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.block.BlockScreen;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.core.DefaultUpgrade;
import net.montoyo.wd.core.IScreenQueryHandler;
import net.montoyo.wd.core.IUpgrade;
import net.montoyo.wd.core.JSServerRequest;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.net.server.SMessageScreenCtrl;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector2i;
import net.montoyo.wd.utilities.Vector3i;

@SideOnly(value=Side.CLIENT)
public final class JSQueryDispatcher {
    private final ClientProxy proxy;
    private final ArrayDeque<QueryData> queue = new ArrayDeque();
    private final ClientProxy.ScreenSidePair lookupResult = new ClientProxy.ScreenSidePair();
    private final HashMap<String, IScreenQueryHandler> handlers = new HashMap();
    private final ArrayList<ServerQuery> serverQueries = new ArrayList();
    private final Minecraft mc = Minecraft.func_71410_x();

    public JSQueryDispatcher(ClientProxy proxy) {
        this.proxy = proxy;
        this.registerDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueQuery(IBrowser b, String q, String a, IJSQueryCallback cb) {
        ArrayDeque<QueryData> arrayDeque = this.queue;
        synchronized (arrayDeque) {
            this.queue.offer(new QueryData(b, q, a, cb));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleQueries() {
        while (true) {
            QueryData next;
            ArrayDeque<QueryData> arrayDeque = this.queue;
            synchronized (arrayDeque) {
                next = this.queue.poll();
            }
            if (next == null) break;
            if (this.proxy.findScreenFromBrowser(next.browser, this.lookupResult)) {
                Object[] args;
                Object[] objectArray = args = next.args == null ? new Object[]{} : JSQueryDispatcher.parseArgs(next.args);
                if (args == null) {
                    next.callback.failure(400, "Malformed request parameters");
                    continue;
                }
                try {
                    this.handlers.get(next.query).handleQuery(next.callback, this.lookupResult.tes, this.lookupResult.side, args);
                }
                catch (Throwable t) {
                    Log.warningEx("Could not execute JS query %s(%s)", t, next.query, next.args == null ? "" : next.args);
                    next.callback.failure(500, "Internal error");
                }
                continue;
            }
            next.callback.failure(403, "A screen is required");
        }
    }

    public boolean canHandleQuery(String q) {
        return this.handlers.containsKey(q);
    }

    private static Object[] parseArgs(String args) {
        ArrayList<String> array = new ArrayList<String>();
        int lastIdx = 0;
        boolean inString = false;
        boolean escape = false;
        boolean hadString = false;
        for (int i = 0; i < args.length(); ++i) {
            char chr = args.charAt(i);
            if (inString) {
                if (escape) {
                    escape = false;
                    continue;
                }
                if (chr == '\"') {
                    inString = false;
                    continue;
                }
                if (chr != '\\') continue;
                escape = true;
                continue;
            }
            if (chr == '\"') {
                if (hadString) {
                    return null;
                }
                inString = true;
                hadString = true;
                continue;
            }
            if (chr != ',') continue;
            array.add(args.substring(lastIdx, i).trim());
            lastIdx = i + 1;
            hadString = false;
        }
        if (inString) {
            return null;
        }
        array.add(args.substring(lastIdx).trim());
        Object[] ret = new Object[array.size()];
        for (int i = 0; i < ret.length; ++i) {
            String str = (String)array.get(i);
            if (str.isEmpty()) {
                return null;
            }
            if (str.charAt(0) == '\"') {
                ret[i] = str.substring(1, str.length() - 1);
                continue;
            }
            try {
                ret[i] = Double.parseDouble(str);
                continue;
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return ret;
    }

    public void register(String query, IScreenQueryHandler handler) {
        this.handlers.put(query.toLowerCase(), handler);
    }

    public ServerQuery fulfillQuery(int id) {
        int toRemove = -1;
        for (int i = 0; i < this.serverQueries.size(); ++i) {
            ServerQuery sq = this.serverQueries.get(i);
            if (sq.id != id) continue;
            toRemove = i;
            break;
        }
        if (toRemove < 0) {
            return null;
        }
        return this.serverQueries.remove(toRemove);
    }

    private void makeServerQuery(TileEntityScreen tes, BlockSide side, IJSQueryCallback cb, JSServerRequest type, Object ... data) {
        ServerQuery ret = new ServerQuery(tes, side, cb);
        this.serverQueries.add(ret);
        WebDisplays.NET_HANDLER.sendToServer((IMessage)SMessageScreenCtrl.jsRequest(tes, side, ret.id, type, data));
    }

    private void registerDefaults() {
        this.register("GetSize", (cb, tes, side, args) -> {
            Vector2i size = tes.getScreen((BlockSide)side).size;
            cb.success("{\"x\":" + size.x + ",\"y\":" + size.y + "}");
        });
        this.register("GetRedstoneAt", (cb, tes, side, args) -> {
            if (!tes.hasUpgrade(side, DefaultUpgrade.REDSTONE_INPUT)) {
                cb.failure(403, "Missing upgrade");
                return;
            }
            if (args.length == 2 && args[0] instanceof Double && args[1] instanceof Double) {
                TileEntityScreen.Screen scr = tes.getScreen(side);
                int x = ((Double)args[0]).intValue();
                int y = ((Double)args[1]).intValue();
                if (x < 0 || x >= scr.size.x || y < 0 || y >= scr.size.y) {
                    cb.failure(403, "Out of range");
                } else {
                    BlockPos bpos = new Vector3i(tes.func_174877_v()).addMul(side.right, x).addMul(side.up, y).toBlock();
                    int level = (Boolean)tes.func_145831_w().func_180495_p(bpos).func_177229_b((IProperty)BlockScreen.emitting) != false ? 0 : tes.func_145831_w().func_175651_c(bpos, EnumFacing.field_82609_l[side.reverse().ordinal()]);
                    cb.success("{\"level\":" + level + "}");
                }
            } else {
                cb.failure(400, "Wrong arguments");
            }
        });
        this.register("GetRedstoneArray", (cb, tes, side, args) -> {
            if (tes.hasUpgrade(side, DefaultUpgrade.REDSTONE_INPUT)) {
                EnumFacing facing = EnumFacing.field_82609_l[side.reverse().ordinal()];
                StringJoiner resp = new StringJoiner(",", "{\"levels\":[", "]}");
                tes.forEachScreenBlocks(side, bp -> {
                    if (((Boolean)tes.func_145831_w().func_180495_p(bp).func_177229_b((IProperty)BlockScreen.emitting)).booleanValue()) {
                        resp.add("0");
                    } else {
                        resp.add("" + tes.func_145831_w().func_175651_c(bp, facing));
                    }
                });
                cb.success(resp.toString());
            } else {
                cb.failure(403, "Missing upgrade");
            }
        });
        this.register("ClearRedstone", (cb, tes, side, args) -> {
            if (tes.hasUpgrade(side, DefaultUpgrade.REDSTONE_OUTPUT)) {
                if (tes.getScreen((BlockSide)side).owner.uuid.equals(this.mc.field_71439_g.func_146103_bH().getId())) {
                    this.makeServerQuery(tes, side, cb, JSServerRequest.CLEAR_REDSTONE, new Object[0]);
                } else {
                    cb.success("{\"status\":\"notOwner\"}");
                }
            } else {
                cb.failure(403, "Missing upgrade");
            }
        });
        this.register("SetRedstoneAt", (cb, tes, side, args) -> {
            if (args.length != 3 || !Arrays.stream(args).allMatch(obj -> obj instanceof Double)) {
                cb.failure(400, "Wrong arguments");
                return;
            }
            if (!tes.hasUpgrade(side, DefaultUpgrade.REDSTONE_OUTPUT)) {
                cb.failure(403, "Missing upgrade");
                return;
            }
            if (!tes.getScreen((BlockSide)side).owner.uuid.equals(this.mc.field_71439_g.func_146103_bH().getId())) {
                cb.success("{\"status\":\"notOwner\"}");
                return;
            }
            int x = ((Double)args[0]).intValue();
            int y = ((Double)args[1]).intValue();
            boolean state = (Double)args[2] > 0.0;
            Vector2i size = tes.getScreen((BlockSide)side).size;
            if (x < 0 || x >= size.x || y < 0 || y >= size.y) {
                cb.failure(403, "Out of range");
                return;
            }
            this.makeServerQuery(tes, side, cb, JSServerRequest.SET_REDSTONE_AT, x, y, state);
        });
        this.register("IsEmitting", (cb, tes, side, args) -> {
            if (!tes.hasUpgrade(side, DefaultUpgrade.REDSTONE_OUTPUT)) {
                cb.failure(403, "Missing upgrade");
                return;
            }
            if (args.length == 2 && args[0] instanceof Double && args[1] instanceof Double) {
                TileEntityScreen.Screen scr = tes.getScreen(side);
                int x = ((Double)args[0]).intValue();
                int y = ((Double)args[1]).intValue();
                if (x < 0 || x >= scr.size.x || y < 0 || y >= scr.size.y) {
                    cb.failure(403, "Out of range");
                } else {
                    BlockPos bpos = new Vector3i(tes.func_174877_v()).addMul(side.right, x).addMul(side.up, y).toBlock();
                    boolean e = (Boolean)tes.func_145831_w().func_180495_p(bpos).func_177229_b((IProperty)BlockScreen.emitting);
                    cb.success("{\"emitting\":" + (e ? "true" : "false") + "}");
                }
            } else {
                cb.failure(400, "Wrong arguments");
            }
        });
        this.register("GetEmissionArray", (cb, tes, side, args) -> {
            if (tes.hasUpgrade(side, DefaultUpgrade.REDSTONE_OUTPUT)) {
                StringJoiner resp = new StringJoiner(",", "{\"emission\":[", "]}");
                tes.forEachScreenBlocks(side, bp -> resp.add((Boolean)tes.func_145831_w().func_180495_p(bp).func_177229_b((IProperty)BlockScreen.emitting) != false ? "1" : "0"));
                cb.success(resp.toString());
            } else {
                cb.failure(403, "Missing upgrade");
            }
        });
        this.register("GetLocation", (cb, tes, side, args) -> {
            if (!tes.hasUpgrade(side, DefaultUpgrade.GPS)) {
                cb.failure(403, "Missing upgrade");
                return;
            }
            BlockPos bp = tes.func_174877_v();
            cb.success("{\"x\":" + bp.func_177958_n() + ",\"y\":" + bp.func_177956_o() + ",\"z\":" + bp.func_177952_p() + ",\"side\":\"" + (Object)((Object)side) + "\"}");
        });
        this.register("GetUpgrades", (cb, tes, side, args) -> {
            StringBuilder sb = new StringBuilder("{\"upgrades\":[");
            ArrayList<ItemStack> upgrades = tes.getScreen((BlockSide)side).upgrades;
            for (int i = 0; i < upgrades.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append('\"');
                sb.append(Util.addSlashes(((IUpgrade)upgrades.get(i).func_77973_b()).getJSName(upgrades.get(i))));
                sb.append('\"');
            }
            cb.success(sb.append("]}").toString());
        });
        this.register("IsOwner", (cb, tes, side, args) -> {
            boolean res = tes.getScreen((BlockSide)side).owner != null && tes.getScreen((BlockSide)side).owner.uuid.equals(this.mc.field_71439_g.func_146103_bH().getId());
            cb.success("{\"isOwner\":" + (res ? "true}" : "false}"));
        });
        this.register("GetRotation", (cb, tes, side, args) -> cb.success("{\"rotation\":" + tes.getScreen((BlockSide)side).rotation.ordinal() + "}"));
        this.register("GetSide", (cb, tes, side, args) -> cb.success("{\"side\":" + tes.getScreen((BlockSide)side).side.ordinal() + "}"));
    }

    public static final class ServerQuery {
        private static int lastId = 0;
        private final TileEntityScreen tes;
        private final BlockSide side;
        private final IJSQueryCallback callback;
        private final int id;

        private ServerQuery(TileEntityScreen t, BlockSide s, IJSQueryCallback cb) {
            this.tes = t;
            this.side = s;
            this.callback = cb;
            this.id = lastId++;
        }

        public TileEntityScreen getTileEntity() {
            return this.tes;
        }

        public BlockSide getSide() {
            return this.side;
        }

        public TileEntityScreen.Screen getScreen() {
            return this.tes.getScreen(this.side);
        }

        public void success(String resp) {
            this.callback.success(resp);
        }

        public void error(int errId, String errStr) {
            this.callback.failure(errId, errStr);
        }
    }

    private static final class QueryData {
        private final IBrowser browser;
        private final String query;
        private final String args;
        private final IJSQueryCallback callback;

        private QueryData(IBrowser b, String q, String a, IJSQueryCallback cb) {
            this.browser = b;
            this.query = q;
            this.args = a;
            this.callback = cb;
        }
    }
}

