/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.client.renderers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.montoyo.wd.WebDisplays;
import net.montoyo.wd.client.ClientProxy;
import net.montoyo.wd.client.renderers.IItemRenderer;
import net.montoyo.wd.client.renderers.ModelMinePad;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public final class MinePadRenderer
implements IItemRenderer {
    private static final float PI = (float)Math.PI;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final ResourceLocation tex = new ResourceLocation("webdisplays", "textures/models/minepad.png");
    private final ModelMinePad model = new ModelMinePad();
    private final ClientProxy clientProxy = (ClientProxy)WebDisplays.PROXY;
    private float sinSqrtSwingProg1;
    private float sinSqrtSwingProg2;
    private float sinSwingProg1;
    private float sinSwingProg2;

    public static void drawAxis() {
        GL11.glDisable((int)3553);
        GL11.glBegin((int)1);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3d((double)5.0, (double)0.0, (double)0.0);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3d((double)0.0, (double)5.0, (double)0.0);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)5.0);
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    @Override
    public final void render(ItemStack is, float handSideSign, float swingProgress, float equipProgress) {
        ClientProxy.PadData pd;
        float sqrtSwingProg = (float)Math.sqrt(swingProgress);
        this.sinSqrtSwingProg1 = MathHelper.func_76126_a((float)(sqrtSwingProg * (float)Math.PI));
        this.sinSqrtSwingProg2 = MathHelper.func_76126_a((float)(sqrtSwingProg * (float)Math.PI * 2.0f));
        this.sinSwingProg1 = MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        this.sinSwingProg2 = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        GL11.glDisable((int)2884);
        GL11.glEnable((int)32826);
        GL11.glPushMatrix();
        this.renderArmFirstPerson(equipProgress, handSideSign);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(handSideSign * -0.4f * this.sinSqrtSwingProg1), (float)(0.2f * this.sinSqrtSwingProg2), (float)(-0.2f * this.sinSwingProg1));
        GL11.glTranslatef((float)(handSideSign * 0.56f), (float)(-0.52f - equipProgress * 0.6f), (float)-0.72f);
        GL11.glRotatef((float)(handSideSign * (45.0f - this.sinSwingProg2 * 20.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(handSideSign * this.sinSqrtSwingProg1 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(this.sinSqrtSwingProg1 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(handSideSign * -45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        if (handSideSign >= 0.0f) {
            GL11.glTranslatef((float)-1.065f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.2f);
            GL11.glRotatef((float)20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.475f, (float)-0.1f, (float)0.0f);
            GL11.glRotatef((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71446_o.func_110577_a(this.tex);
        this.model.render(0.0625f);
        GL11.glPopMatrix();
        if (is.func_77978_p() != null && is.func_77978_p().func_74764_b("PadID") && (pd = this.clientProxy.getPadByID(is.func_77978_p().func_74762_e("PadID"))) != null) {
            GL11.glTranslatef((float)0.063f, (float)0.28f, (float)0.001f);
            RenderHelper.func_74518_a();
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
            GL11.glDisable((int)3553);
            OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
            pd.view.draw(0.0, 0.0, 0.8740625, 0.4395);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2884);
    }

    private void renderArmFirstPerson(float equipProgress, float handSideSign) {
        float tx = -0.3f * this.sinSqrtSwingProg1;
        float ty = 0.4f * this.sinSqrtSwingProg2;
        float tz = -0.4f * this.sinSwingProg1;
        GL11.glTranslatef((float)(handSideSign * (tx + 0.64000005f)), (float)(ty - 0.6f - equipProgress * 0.6f), (float)(tz - 0.71999997f));
        GL11.glRotatef((float)(handSideSign * 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(handSideSign * this.sinSqrtSwingProg1 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(handSideSign * this.sinSwingProg2 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-handSideSign), (float)3.6f, (float)3.5f);
        GL11.glRotatef((float)(handSideSign * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(handSideSign * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(handSideSign * 5.6f), (float)0.0f, (float)0.0f);
        RenderPlayer playerRenderer = (RenderPlayer)this.mc.func_175598_ae().func_78713_a((Entity)this.mc.field_71439_g);
        this.mc.func_110434_K().func_110577_a(this.mc.field_71439_g.func_110306_p());
        if (handSideSign >= 0.0f) {
            playerRenderer.func_177138_b((AbstractClientPlayer)this.mc.field_71439_g);
        } else {
            playerRenderer.func_177139_c((AbstractClientPlayer)this.mc.field_71439_g);
        }
    }
}

