/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.montoyo.wd.core.IPeripheral;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Log;
import net.montoyo.wd.utilities.Vector3i;

public abstract class TileEntityPeripheralBase
extends TileEntity
implements IPeripheral {
    protected Vector3i screenPos;
    protected BlockSide screenSide;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_150297_b("WDScreen", 10)) {
            NBTTagCompound scr = tag.func_74775_l("WDScreen");
            this.screenPos = new Vector3i(scr.func_74762_e("X"), scr.func_74762_e("Y"), scr.func_74762_e("Z"));
            this.screenSide = BlockSide.values()[scr.func_74771_c("Side")];
        } else {
            this.screenPos = null;
            this.screenSide = null;
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.screenPos != null && this.screenSide != null) {
            NBTTagCompound scr = new NBTTagCompound();
            scr.func_74768_a("X", this.screenPos.x);
            scr.func_74768_a("Y", this.screenPos.y);
            scr.func_74768_a("Z", this.screenPos.z);
            scr.func_74774_a("Side", (byte)this.screenSide.ordinal());
            tag.func_74782_a("WDScreen", (NBTBase)scr);
        }
        return tag;
    }

    @Override
    public boolean connect(World world_, BlockPos blockPos, IBlockState blockState, Vector3i pos, BlockSide side) {
        TileEntity te = this.field_145850_b.func_175625_s(pos.toBlock());
        if (te == null || !(te instanceof TileEntityScreen)) {
            Log.error("TileEntityPeripheralBase.connect(): Tile entity at %s is not a screen!", pos.toString());
            return false;
        }
        if (((TileEntityScreen)te).getScreen(side) == null) {
            Log.error("TileEntityPeripheralBase.connect(): There is no screen at %s on side %s!", pos.toString(), side.toString());
            return false;
        }
        this.screenPos = pos;
        this.screenSide = side;
        this.func_70296_d();
        return true;
    }

    public boolean isLinked() {
        return this.screenPos != null && this.screenSide != null;
    }

    public boolean isScreenChunkLoaded() {
        if (this.screenPos == null || this.screenSide == null) {
            return true;
        }
        Chunk chunk = this.field_145850_b.func_72863_F().func_186026_b(this.screenPos.x >> 4, this.screenPos.z >> 4);
        return chunk != null && !chunk.func_76621_g();
    }

    @Nullable
    public TileEntityScreen getConnectedScreen() {
        if (this.screenPos == null || this.screenSide == null) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.screenPos.toBlock());
        if (te == null || !(te instanceof TileEntityScreen) || ((TileEntityScreen)te).getScreen(this.screenSide) == null) {
            this.screenPos = null;
            this.screenSide = null;
            this.func_70296_d();
            return null;
        }
        return (TileEntityScreen)te;
    }

    @Nullable
    public TileEntityScreen getConnectedScreenEx() {
        if (this.screenPos == null || this.screenSide == null) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.screenPos.toBlock());
        if (te == null || !(te instanceof TileEntityScreen) || ((TileEntityScreen)te).getScreen(this.screenSide) == null) {
            return null;
        }
        return (TileEntityScreen)te;
    }

    @Nullable
    public Vector3i getScreenPos() {
        return this.screenPos;
    }

    @Nullable
    public BlockSide getScreenSide() {
        return this.screenSide;
    }

    public boolean onRightClick(EntityPlayer player, EnumHand hand, BlockSide side) {
        return false;
    }

    public void onNeighborChange(Block neighborType, BlockPos neighborPos) {
    }
}

