/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.net.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.montoyo.wd.entity.TileEntityRedCtrl;
import net.montoyo.wd.entity.TileEntityScreen;
import net.montoyo.wd.net.Message;
import net.montoyo.wd.utilities.Util;
import net.montoyo.wd.utilities.Vector3i;

@Message(messageId=8, side=Side.SERVER)
public class SMessageRedstoneCtrl
implements IMessage,
Runnable {
    private EntityPlayer player;
    private int dimension;
    private Vector3i pos;
    private String risingEdgeURL;
    private String fallingEdgeURL;

    public SMessageRedstoneCtrl() {
    }

    public SMessageRedstoneCtrl(int d, Vector3i p, String r, String f) {
        this.dimension = d;
        this.pos = p;
        this.risingEdgeURL = r;
        this.fallingEdgeURL = f;
    }

    @Override
    public void run() {
        World world = this.player.field_70170_p;
        BlockPos blockPos = this.pos.toBlock();
        double maxRange = this.player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        if (world.field_73011_w.getDimension() != this.dimension || this.player.func_174818_b(blockPos) > maxRange * maxRange) {
            return;
        }
        TileEntity te = this.player.field_70170_p.func_175625_s(blockPos);
        if (te == null || !(te instanceof TileEntityRedCtrl)) {
            return;
        }
        TileEntityRedCtrl redCtrl = (TileEntityRedCtrl)te;
        if (!redCtrl.isScreenChunkLoaded()) {
            Util.toast(this.player, "chunkUnloaded", new Object[0]);
            return;
        }
        TileEntityScreen tes = redCtrl.getConnectedScreen();
        if (tes == null) {
            return;
        }
        if ((tes.getScreen(redCtrl.getScreenSide()).rightsFor(this.player) & 1) == 0) {
            return;
        }
        redCtrl.setURLs(this.risingEdgeURL, this.fallingEdgeURL);
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.pos = new Vector3i(buf);
        this.risingEdgeURL = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.fallingEdgeURL = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        this.pos.writeTo(buf);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.risingEdgeURL);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.fallingEdgeURL);
    }

    public static class Handler
    implements IMessageHandler<SMessageRedstoneCtrl, IMessage> {
        public IMessage onMessage(SMessageRedstoneCtrl msg, MessageContext ctx) {
            msg.player = (EntityPlayer)ctx.getServerHandler().field_147369_b;
            ((WorldServer)((SMessageRedstoneCtrl)msg).player.field_70170_p).func_152344_a((Runnable)msg);
            return null;
        }
    }
}

