/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockCatwalkHatch;
import cassiokf.industrialrenewal.blocks.BlockCatwalkStair;
import cassiokf.industrialrenewal.blocks.abstracts.BlockHorizontalFacing;
import cassiokf.industrialrenewal.init.ModBlocks;
import cassiokf.industrialrenewal.init.ModItems;
import cassiokf.industrialrenewal.item.ItemPowerScrewDrive;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCatwalkLadder
extends BlockHorizontalFacing {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.03125, 1.0);
    protected static final AxisAlignedBB LADDER_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    protected static final AxisAlignedBB LADDER_WEST_AABB = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB LADDER_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    protected static final AxisAlignedBB LADDER_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.03125);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.96875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.03125, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.96875, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockCatwalkLadder(String name, CreativeTabs tab) {
        super(name, tab, Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Item playerItem = entity.field_71071_by.func_70448_g().func_77973_b();
        if (playerItem.equals((Object)ModItems.screwDrive)) {
            ItemPowerScrewDrive.playDrillSound(world, pos);
            world.func_180501_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)ACTIVE) == false)), 3);
            return true;
        }
        if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.iladder)) || playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.sladder))) {
            BlockPos posOffset = pos.func_177984_a();
            IBlockState stateOffset = world.func_180495_p(posOffset);
            if (stateOffset.func_177230_c().isAir(stateOffset, (IBlockAccess)world, posOffset) || stateOffset.func_177230_c().func_176200_f((IBlockAccess)world, posOffset)) {
                EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)FACING);
                world.func_180501_a(posOffset, BlockCatwalkLadder.func_149634_a((Item)playerItem).func_176223_P().func_177226_a((IProperty)FACING, (Comparable)direction).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(!this.OpenIf((IBlockAccess)world, posOffset))), 3);
                if (!entity.func_184812_l_()) {
                    entity.field_71071_by.func_174925_a(playerItem, 0, 1, null);
                }
            }
            return true;
        }
        return false;
    }

    private boolean downConnection(BlockPos pos, IBlockAccess world) {
        Block downB = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return !(downB instanceof BlockLadder) && !(downB instanceof BlockCatwalkLadder) && !(downB instanceof BlockCatwalkHatch) && !(downB instanceof BlockCatwalkStair) && !(downB instanceof BlockStairs) && !(downB instanceof BlockTrapDoor);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.downConnection(pos, world)));
        return state;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE, DOWN});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    protected boolean OpenIf(IBlockAccess WorldIn, BlockPos ownPos) {
        BlockPos downpos = ownPos.func_177977_b();
        BlockPos twoDownPos = downpos.func_177977_b();
        IBlockState downState = WorldIn.func_180495_p(downpos);
        IBlockState twoDownState = WorldIn.func_180495_p(twoDownPos);
        return downState.func_185913_b() || downState.func_177230_c() instanceof BlockCatwalkLadder && (Boolean)downState.func_177229_b((IProperty)ACTIVE) == false && twoDownState.func_185913_b();
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(!this.OpenIf((IBlockAccess)worldIn, pos)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return LADDER_SOUTH_AABB;
            }
            case SOUTH: {
                return LADDER_NORTH_AABB;
            }
            case WEST: {
                return LADDER_EAST_AABB;
            }
        }
        return LADDER_WEST_AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState actualState = state.func_185899_b((IBlockAccess)worldIn, pos);
        EnumFacing face = (EnumFacing)actualState.func_177229_b((IProperty)FACING);
        boolean active = (Boolean)actualState.func_177229_b((IProperty)ACTIVE);
        boolean down = (Boolean)actualState.func_177229_b((IProperty)DOWN);
        if (face == EnumFacing.NORTH) {
            BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)LADDER_SOUTH_AABB);
            if (active) {
                BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
                BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
                BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
            }
        }
        if (face == EnumFacing.SOUTH) {
            BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)LADDER_NORTH_AABB);
            if (active) {
                BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
                BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
                BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
            }
        }
        if (face == EnumFacing.WEST) {
            BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)LADDER_EAST_AABB);
            if (active) {
                BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
                BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
                BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
            }
        }
        if (face == EnumFacing.EAST) {
            BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)LADDER_WEST_AABB);
            if (active) {
                BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
                BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
                BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
            }
        }
        if (down) {
            BlockCatwalkLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)DOWN_AABB);
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

