/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.api.conveyor;

import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.IConveyorContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.proxy.block.Cuboid;
import com.buuz135.industrial.registry.IFRegistries;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ConveyorUpgrade
implements INBTSerializable<NBTTagCompound> {
    public static Cuboid EMPTY_BB = new Cuboid(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private IConveyorContainer container;
    private ConveyorUpgradeFactory factory;
    private EnumFacing side;

    public ConveyorUpgrade(IConveyorContainer container, ConveyorUpgradeFactory factory, EnumFacing side) {
        this.container = container;
        this.factory = factory;
        this.side = side;
    }

    public NBTTagCompound serializeNBT() {
        return null;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
    }

    public boolean onUpgradeActivated(EntityPlayer player, EnumHand hand) {
        return false;
    }

    public Collection<ItemStack> getDrops() {
        return Collections.singleton(new ItemStack((Item)ItemRegistry.conveyorUpgradeItem, 1, IFRegistries.CONVEYOR_UPGRADE_REGISTRY.getID((IForgeRegistryEntry)this.getFactory()) - 1));
    }

    public IConveyorContainer getContainer() {
        return this.container;
    }

    public World getWorld() {
        return this.getContainer().getConveyorWorld();
    }

    public BlockPos getPos() {
        return this.getContainer().getConveyorPosition();
    }

    public ConveyorUpgradeFactory getFactory() {
        return this.factory;
    }

    public EnumFacing getSide() {
        return this.side;
    }

    public void update() {
    }

    public void handleEntity(Entity entity) {
    }

    public void onUpgradeRemoved() {
    }

    public int getRedstoneOutput() {
        return 0;
    }

    public Cuboid getBoundingBox() {
        return EMPTY_BB;
    }

    public boolean hasGui() {
        return false;
    }

    public void handleButtonInteraction(int buttonId, NBTTagCompound compound) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addComponentsToGui(List<IGuiComponent> componentList) {
    }
}

