/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.item;

import com.enderio.core.common.network.NetworkUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.util.NbtValue;
import crazypants.enderio.util.Prep;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public class ExistingItemFilter
implements IItemFilter {
    private boolean matchMeta = true;
    private boolean useOreDict = false;
    private boolean matchNBT = false;
    private boolean sticky = false;
    private boolean blacklist = false;
    private NNList<ItemStack> snapshot = null;

    @Override
    public boolean doesItemPassFilter(@Nullable IItemHandler inventory, @Nonnull ItemStack item) {
        if (Prep.isInvalid(item)) {
            return false;
        }
        if (this.snapshot != null) {
            return this.isStackInSnapshot(item) != this.blacklist;
        }
        if (inventory != null) {
            return this.isStackInInventory(inventory, item) != this.blacklist;
        }
        return false;
    }

    private boolean isStackInInventory(@Nonnull IItemHandler inventory, @Nonnull ItemStack item) {
        int numSlots = inventory.getSlots();
        for (int i = 0; i < numSlots; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!this.stackEqual(item, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean isStackInSnapshot(@Nonnull ItemStack item) {
        NNList.NNIterator iterator = this.snapshot.fastIterator();
        while (iterator.hasNext()) {
            if (!this.stackEqual(item, (ItemStack)iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean stackEqual(@Nonnull ItemStack toInsert, @Nonnull ItemStack existing) {
        if (Prep.isInvalid(toInsert) || Prep.isInvalid(existing)) {
            return false;
        }
        boolean matched = false;
        if (this.useOreDict) {
            matched = this.isSameOreRegistered(existing, toInsert);
        }
        if (!matched) {
            boolean bl = matched = toInsert.func_77973_b() == existing.func_77973_b();
            if (matched && this.matchMeta) {
                boolean bl2 = matched = toInsert.func_77952_i() == existing.func_77952_i();
            }
            if (matched && this.matchNBT) {
                matched = ItemStack.func_77970_a((ItemStack)toInsert, (ItemStack)existing);
            }
        }
        return matched;
    }

    private boolean isSameOreRegistered(@Nonnull ItemStack existing, @Nonnull ItemStack toInsert) {
        int[] existingIds = OreDictionary.getOreIDs((ItemStack)existing);
        int[] toInsertIds = OreDictionary.getOreIDs((ItemStack)toInsert);
        boolean matched = false;
        for (int i = 0; i < existingIds.length && !matched; ++i) {
            int existingId = existingIds[i];
            matched = existingId != -1 && this.contains(toInsertIds, existingId);
        }
        return matched;
    }

    private boolean contains(int[] ar, int val) {
        for (int i : ar) {
            if (i != val) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int getSlotCount() {
        return 0;
    }

    public void setSnapshot(@Nonnull IItemHandler inventory) {
        this.snapshot = new NNList();
        this.mergeSnapshot(inventory);
    }

    public boolean mergeSnapshot(@Nonnull IItemHandler inventory) {
        if (this.snapshot == null) {
            this.snapshot = new NNList();
        }
        boolean added = false;
        int numSlots = inventory.getSlots();
        for (int i = 0; i < numSlots; ++i) {
            ItemStack stack = inventory.getStackInSlot(i).func_77946_l().func_77979_a(1);
            if (!Prep.isValid(stack) || this.isStackInSnapshot(stack)) continue;
            this.snapshot.add((Object)stack);
            added = true;
        }
        return added;
    }

    public NNList<ItemStack> getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(NNList<ItemStack> snapshot) {
        this.snapshot = snapshot;
    }

    public boolean isMatchMeta() {
        return this.matchMeta;
    }

    public void setMatchMeta(boolean matchMeta) {
        this.matchMeta = matchMeta;
    }

    public boolean isMatchNBT() {
        return this.matchNBT;
    }

    public void setMatchNBT(boolean matchNbt) {
        this.matchNBT = matchNbt;
    }

    public boolean isUseOreDict() {
        return this.useOreDict;
    }

    public void setUseOreDict(boolean useOreDict) {
        this.useOreDict = useOreDict;
    }

    @Override
    public boolean isSticky() {
        return this.sticky;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public void setBlacklist(boolean value) {
        this.blacklist = value;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        this.readSettingsFromNBT(nbtRoot);
        if (nbtRoot.func_74764_b("snapshot")) {
            this.snapshot = new NNList();
            NBTTagList itemList = (NBTTagList)nbtRoot.func_74781_a("snapshot");
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = itemList.func_150305_b(i);
                ItemStack itemStack = new ItemStack(itemTag);
                if (!Prep.isValid(itemStack)) continue;
                this.snapshot.add((Object)itemStack);
            }
        } else {
            this.snapshot = null;
        }
    }

    protected void readSettingsFromNBT(NBTTagCompound nbtRoot) {
        this.blacklist = NbtValue.FILTER_BLACKLIST.getBoolean(nbtRoot);
        this.matchMeta = NbtValue.FILTER_META.getBoolean(nbtRoot);
        this.matchNBT = NbtValue.FILTER_NBT.getBoolean(nbtRoot);
        this.useOreDict = NbtValue.FILTER_OREDICT.getBoolean(nbtRoot);
        this.sticky = NbtValue.FILTER_STICKY.getBoolean(nbtRoot);
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        this.writeSettingToNBT(nbtRoot);
        if (this.snapshot != null) {
            NBTTagList itemList = new NBTTagList();
            for (ItemStack item : this.snapshot) {
                if (item.func_190926_b()) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                item.func_77955_b(itemTag);
                itemList.func_74742_a((NBTBase)itemTag);
            }
            nbtRoot.func_74782_a("snapshot", (NBTBase)itemList);
        }
    }

    protected void writeSettingToNBT(NBTTagCompound nbtRoot) {
        NbtValue.FILTER_BLACKLIST.setBoolean(nbtRoot, this.blacklist);
        NbtValue.FILTER_META.setBoolean(nbtRoot, this.matchMeta);
        NbtValue.FILTER_NBT.setBoolean(nbtRoot, this.matchNBT);
        NbtValue.FILTER_OREDICT.setBoolean(nbtRoot, this.useOreDict);
        NbtValue.FILTER_STICKY.setBoolean(nbtRoot, this.sticky);
    }

    @Override
    public void writeToByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound settingsTag = new NBTTagCompound();
        this.writeSettingToNBT(settingsTag);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)settingsTag, (ByteBuf)buf);
        buf.writeInt(this.snapshot == null ? 0 : this.snapshot.size());
        if (this.snapshot == null) {
            return;
        }
        for (ItemStack item : this.snapshot) {
            if (item.func_190926_b()) continue;
            NBTTagCompound itemRoot = new NBTTagCompound();
            item.func_77955_b(itemRoot);
            NetworkUtil.writeNBTTagCompound((NBTTagCompound)itemRoot, (ByteBuf)buf);
        }
    }

    @Override
    public void readFromByteBuf(@Nonnull ByteBuf buf) {
        NBTTagCompound settingsTag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.readSettingsFromNBT(settingsTag);
        int numItems = buf.readInt();
        if (numItems == 0) {
            this.snapshot = null;
            return;
        }
        this.snapshot = new NNList();
        for (int i = 0; i < numItems; ++i) {
            NBTTagCompound itemTag = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
            ItemStack item = new ItemStack(itemTag);
            if (!Prep.isValid(item)) continue;
            this.snapshot.add((Object)item);
        }
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack s : this.snapshot) {
            if (s.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

