/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.item.coordselector;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.GhostSlotHandler;
import com.enderio.core.client.gui.GuiScreenBase;
import com.enderio.core.client.gui.button.TooltipButton;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.item.coordselector.PacketUpdateLocationPrintout;
import crazypants.enderio.base.item.coordselector.TelepadTarget;
import crazypants.enderio.base.network.PacketHandler;
import java.awt.Color;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiLocationPrintout
extends GuiScreenBase {
    @Nonnull
    private static final ResourceLocation GUI_BACKGROUND = EnderIO.proxy.getGuiTexture("location_printout");
    private final TextFieldEnder tf;
    private TooltipButton okB;
    @Nonnull
    private final ItemStack stack;
    @Nonnull
    private final TelepadTarget target;
    private final EntityEquipmentSlot slot;
    private final int paperSlot;
    private boolean isCancelled = false;

    public GuiLocationPrintout(@Nonnull TelepadTarget target, @Nonnull ItemStack stack, int paperSlot) {
        this(target, stack, null, paperSlot);
    }

    public GuiLocationPrintout(@Nonnull TelepadTarget target, @Nonnull EntityPlayer player, @Nonnull EntityEquipmentSlot slot) {
        this(target, player.func_184582_a(slot), slot, -1);
    }

    private GuiLocationPrintout(@Nonnull TelepadTarget target, @Nonnull ItemStack stack, EntityEquipmentSlot slot, int paperSlot) {
        this.slot = slot;
        this.stack = stack;
        this.paperSlot = paperSlot;
        this.target = target;
        this.xSize = 176;
        this.ySize = 116;
        int tfWidth = 90;
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        this.tf = new TextFieldEnder(fr, this.xSize / 2 - tfWidth / 2, 20, tfWidth, 16);
        this.tf.func_146203_f(32);
        this.okB = new TooltipButton((IGuiScreen)this, 0, this.xSize - 30, this.ySize - 30, 20, 20, "Ok");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tf.func_146195_b(true);
        String txt = this.target.getName();
        this.tf.func_146180_a(txt);
        this.tf.init((IGuiScreen)this);
        this.okB.onGuiInit();
    }

    public void func_73876_c() {
        this.tf.func_146178_a();
    }

    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        this.field_146297_k.field_71439_g.func_71053_j();
    }

    protected void func_73869_a(char c, int key) throws IOException {
        if (key == 1 || key == 28) {
            this.isCancelled = key == 1;
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        this.tf.func_146201_a(c, key);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.tf.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void drawBackgroundLayer(float par3, int par1, int par2) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture((ResourceLocation)GUI_BACKGROUND);
        this.func_73729_b(this.getGuiRootLeft(), this.getGuiRootTop(), 0, 0, this.xSize, this.ySize);
        this.checkLabelForChange();
        this.tf.func_146194_f();
        int col = ColorUtil.getRGB((Color)Color.white);
        int midX = this.getGuiRootLeft() + this.xSize / 2;
        int y = this.getGuiRootTop() + 48;
        BlockPos loc = this.target.getLocation();
        String txt = loc.func_177958_n() + " " + loc.func_177956_o() + " " + loc.func_177952_p();
        int x = midX - this.field_146289_q.func_78256_a(txt) / 2;
        this.field_146289_q.func_175063_a(txt, (float)x, (float)y, col);
        txt = TelepadTarget.getDimenionName(this.target.getDimension());
        x = midX - this.field_146289_q.func_78256_a(txt) / 2;
        this.field_146289_q.func_175063_a(txt, (float)x, (float)(y += this.field_146289_q.field_78288_b + 4), col);
    }

    private void checkLabelForChange() {
        String curText;
        String newTxt = this.tf.func_146179_b().trim();
        if (newTxt.equals(curText = this.target.getName().trim())) {
            return;
        }
        this.target.setName(newTxt);
        this.target.writeToNBT(this.stack);
        if (this.slot != null) {
            PacketUpdateLocationPrintout p = new PacketUpdateLocationPrintout(this.stack, this.slot, this.paperSlot);
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
        }
    }

    public void func_146281_b() {
        if (this.slot == null && !this.isCancelled) {
            PacketUpdateLocationPrintout p = new PacketUpdateLocationPrintout(this.stack, this.slot, this.paperSlot);
            PacketHandler.INSTANCE.sendToServer((IMessage)p);
        }
    }

    public void clearToolTips() {
    }

    public boolean func_73868_f() {
        return false;
    }

    @Nonnull
    public GhostSlotHandler getGhostSlotHandler() {
        return new GhostSlotHandler();
    }
}

