/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.network;

import com.enderio.core.common.network.CompressedDataOutput;
import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.base.invpanel.database.IInventoryDatabaseServer;
import crazypants.enderio.base.invpanel.database.IServerItemEntry;
import crazypants.enderio.invpanel.invpanel.InventoryPanelContainer;
import crazypants.enderio.invpanel.invpanel.TileInventoryPanel;
import crazypants.enderio.invpanel.network.PacketItemInfo;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRequestMissingItems
implements IMessage {
    private int windowId;
    private byte[] compressed;

    public PacketRequestMissingItems() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketRequestMissingItems(int windowId, int generation, List<Integer> missingIDs) {
        this.windowId = windowId;
        try (CompressedDataOutput cdo = new CompressedDataOutput();){
            cdo.writeVariable(generation);
            cdo.writeVariable(missingIDs.size());
            for (Integer id : missingIDs) {
                cdo.writeVariable(id - 65536);
            }
            this.compressed = cdo.getCompressed();
        }
        catch (IOException ex) {
            this.compressed = new byte[0];
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readInt();
        this.compressed = NetworkUtil.readByteArray((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowId);
        NetworkUtil.writeByteArray((ByteBuf)buf, (byte[])this.compressed);
    }

    public static class Handler
    implements IMessageHandler<PacketRequestMissingItems, IMessage> {
        public IMessage onMessage(PacketRequestMissingItems message, MessageContext ctx) {
            InventoryPanelContainer ipc;
            TileInventoryPanel teInvPanel;
            IInventoryDatabaseServer db;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (player.field_71070_bA.field_75152_c == message.windowId && player.field_71070_bA instanceof InventoryPanelContainer && (db = (teInvPanel = (TileInventoryPanel)(ipc = (InventoryPanelContainer)player.field_71070_bA).getTe()).getDatabaseServer()) != null) {
                try {
                    List<? extends IServerItemEntry> items = db.decompressMissingItems(message.compressed);
                    if (!items.isEmpty()) {
                        return new PacketItemInfo(message.windowId, db, items);
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(PacketItemInfo.class.getName()).log(Level.SEVERE, "Exception while reading missing item IDs", ex);
                }
            }
            return null;
        }
    }
}

