/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.client;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import net.montoyo.mcef.client.ClientProxy;
import net.montoyo.mcef.utilities.Log;
import net.montoyo.mcef.utilities.Util;

public class LinuxPatch {
    private static String[] getBinDirs() {
        return new String[]{"/bin", "/usr/bin", "/usr/sbin", "/usr/local/bin", "/usr/local/sbin"};
    }

    private static String[] getPatchFiles() {
        return new String[]{"icudtl.dat", "natives_blob.bin", "snapshot_blob.bin", "v8_context_snapshot.bin"};
    }

    private static String getExeLocation(String exe) {
        String[] bins;
        for (String b : bins = LinuxPatch.getBinDirs()) {
            File f = new File(b, exe);
            if (!f.exists()) continue;
            return f.getAbsolutePath();
        }
        return null;
    }

    private static String getGksudoLocation() {
        String ret = LinuxPatch.getExeLocation("gksudo");
        return ret == null ? LinuxPatch.getExeLocation("gksu") : ret;
    }

    public static File getScriptFile() {
        return new File(ClientProxy.ROOT, "mcefLinuxPatch.sh");
    }

    public static void generateScript() throws Throwable {
        String[] files = LinuxPatch.getPatchFiles();
        BufferedWriter bw = new BufferedWriter(new FileWriter(LinuxPatch.getScriptFile()));
        bw.write("#!/bin/sh\n");
        bw.write("MCEF_ROOT=\"" + ClientProxy.ROOT + "\"\n");
        bw.write("JAVA_ROOT=\"" + System.getProperty("java.home") + "/bin\"\n\n");
        for (String f : files) {
            bw.write("rm -f \"$JAVA_ROOT/" + f + "\"\n");
        }
        bw.write("\n\n");
        for (String f : files) {
            bw.write("ln -s \"$MCEF_ROOT/" + f + "\" \"$JAVA_ROOT/" + f + "\"\n");
        }
        bw.write("\n\n");
        Util.close(bw);
    }

    public static boolean chmodX(File p) {
        try {
            return Runtime.getRuntime().exec(new String[]{"chmod", "+x", p.getAbsolutePath()}).waitFor() == 0;
        }
        catch (IOException | InterruptedException ex) {
            return false;
        }
    }

    public static boolean runScript() {
        String cmd = LinuxPatch.getGksudoLocation();
        if (cmd == null) {
            return false;
        }
        try {
            if (!LinuxPatch.chmodX(LinuxPatch.getScriptFile())) {
                Log.error("chmod failed!", new Object[0]);
                return false;
            }
            if (Runtime.getRuntime().exec(new String[]{cmd, LinuxPatch.getScriptFile().getAbsolutePath()}).waitFor() != 0) {
                Log.error("gksudo failed!", new Object[0]);
                return false;
            }
            for (int i = 0; i < 6 && !LinuxPatch.isPatched(); ++i) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isPatched() {
        String[] files;
        File root = new File(System.getProperty("java.home"), "bin");
        for (String f : files = LinuxPatch.getPatchFiles()) {
            if (new File(root, f).exists()) continue;
            return false;
        }
        return true;
    }

    public static boolean doPatch(File[] resourceArray) {
        for (File f : resourceArray) {
            if (!f.exists() || LinuxPatch.chmodX(f)) continue;
            Log.warning("Couldn't give execution access to %s", f.getAbsolutePath());
        }
        if (LinuxPatch.isPatched()) {
            return true;
        }
        try {
            LinuxPatch.generateScript();
        }
        catch (Throwable t) {
            Log.error("Could not apply linux patch:", new Object[0]);
            t.printStackTrace();
            return false;
        }
        int ans = JOptionPane.showConfirmDialog(null, "An existing bug in JCEF requires some files to be copied\ninto the Java home directory in order to make MCEF working.\nThis operations requires root privileges.\nDo you want MCEF to try to do it automatically?", "MCEF Linux", 0);
        if (ans != 0) {
            JOptionPane.showMessageDialog(null, "MCEF will enter virtual mode.\nA script containing the patch was generated here:\n" + LinuxPatch.getScriptFile().getAbsolutePath(), "MCEF Linux", 1);
            return false;
        }
        return LinuxPatch.runScript();
    }
}

