/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.example;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.montoyo.mcef.api.API;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.IDisplayHandler;
import net.montoyo.mcef.api.IJSQueryCallback;
import net.montoyo.mcef.api.IJSQueryHandler;
import net.montoyo.mcef.api.MCEFApi;
import net.montoyo.mcef.example.BrowserScreen;
import net.montoyo.mcef.example.ModScheme;
import net.montoyo.mcef.example.ScreenCfg;
import net.montoyo.mcef.utilities.Log;

public class ExampleMod
implements IDisplayHandler,
IJSQueryHandler {
    public static ExampleMod INSTANCE;
    public ScreenCfg hudBrowser = null;
    private KeyBinding key = new KeyBinding("Open Browser", 68, "key.categories.misc");
    private Minecraft mc = Minecraft.func_71410_x();
    private BrowserScreen backup = null;
    private API api;

    public API getAPI() {
        return this.api;
    }

    public void onPreInit() {
        this.api = MCEFApi.getAPI();
        if (this.api == null) {
            return;
        }
        this.api.registerScheme("mod", ModScheme.class, true, false, false, true, true, false, false);
    }

    public void onInit() {
        INSTANCE = this;
        ClientRegistry.registerKeyBinding((KeyBinding)this.key);
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (this.api != null) {
            this.api.registerDisplayHandler(this);
            this.api.registerJSQueryHandler(this);
        }
    }

    public void setBackup(BrowserScreen bu) {
        this.backup = bu;
    }

    public boolean hasBackup() {
        return this.backup != null;
    }

    public void showScreen(String url) {
        if (this.mc.field_71462_r instanceof BrowserScreen) {
            ((BrowserScreen)this.mc.field_71462_r).loadURL(url);
        } else if (this.hasBackup()) {
            this.mc.func_147108_a((GuiScreen)this.backup);
            this.backup.loadURL(url);
            this.backup = null;
        } else {
            this.mc.func_147108_a((GuiScreen)new BrowserScreen(url));
        }
    }

    public IBrowser getBrowser() {
        if (this.mc.field_71462_r instanceof BrowserScreen) {
            return ((BrowserScreen)this.mc.field_71462_r).browser;
        }
        if (this.backup != null) {
            return this.backup.browser;
        }
        return null;
    }

    @SubscribeEvent
    public void onTick(TickEvent ev) {
        if (ev.phase == TickEvent.Phase.START && ev.side == Side.CLIENT && ev.type == TickEvent.Type.CLIENT && this.key.func_151468_f() && !(this.mc.field_71462_r instanceof BrowserScreen)) {
            this.mc.func_147108_a((GuiScreen)(this.hasBackup() ? this.backup : new BrowserScreen()));
            this.backup = null;
        }
    }

    @Override
    public void onAddressChange(IBrowser browser, String url) {
        if (this.mc.field_71462_r instanceof BrowserScreen) {
            ((BrowserScreen)this.mc.field_71462_r).onUrlChanged(browser, url);
        } else if (this.hasBackup()) {
            this.backup.onUrlChanged(browser, url);
        }
    }

    @Override
    public void onTitleChange(IBrowser browser, String title) {
    }

    @Override
    public void onTooltip(IBrowser browser, String text) {
    }

    @Override
    public void onStatusMessage(IBrowser browser, String value) {
    }

    @Override
    public boolean handleQuery(IBrowser b, long queryId, String query, boolean persistent, IJSQueryCallback cb) {
        if (b != null && query.equalsIgnoreCase("username")) {
            if (b.getURL().startsWith("mod://")) {
                this.mc.func_152344_a(() -> {
                    try {
                        String name = this.mc.func_110432_I().func_111285_a();
                        cb.success(name);
                    }
                    catch (Throwable t) {
                        cb.failure(500, "Internal error.");
                        Log.warning("Could not get username from JavaScript:", new Object[0]);
                        t.printStackTrace();
                    }
                });
            } else {
                cb.failure(403, "Can't access username from external page");
            }
            return true;
        }
        return false;
    }

    @Override
    public void cancelQuery(IBrowser b, long queryId) {
    }

    @SubscribeEvent
    public void onDrawHUD(RenderGameOverlayEvent.Post ev) {
        if (this.hudBrowser != null) {
            this.hudBrowser.func_73863_a(0, 0, 0.0f);
        }
    }
}

