/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.common;

import com.mrcrayfish.guns.GunConfig;
import com.mrcrayfish.guns.item.ItemGun;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.tuple.Pair;

public class SpreadTracker {
    private final Map<ItemGun, Pair<MutableLong, MutableInt>> SPREAD_TRACKER_MAP = new HashMap<ItemGun, Pair<MutableLong, MutableInt>>();

    public void update(ItemGun item) {
        Pair entry = this.SPREAD_TRACKER_MAP.computeIfAbsent(item, gun -> Pair.of((Object)new MutableLong(-1L), (Object)new MutableInt()));
        MutableLong lastFire = (MutableLong)entry.getLeft();
        if (lastFire.getValue() != -1L) {
            MutableInt spreadCount = (MutableInt)entry.getRight();
            long deltaTime = System.currentTimeMillis() - lastFire.getValue();
            if (deltaTime < (long)GunConfig.SERVER.projectileSpread.spreadThreshold) {
                if (spreadCount.getValue() < GunConfig.SERVER.projectileSpread.maxCount) {
                    spreadCount.increment();
                }
            } else {
                spreadCount.setValue(0);
            }
        }
        lastFire.setValue(System.currentTimeMillis());
    }

    public float getSpread(ItemGun item) {
        Pair<MutableLong, MutableInt> entry = this.SPREAD_TRACKER_MAP.get((Object)item);
        if (entry != null) {
            return (float)((MutableInt)entry.getRight()).getValue().intValue() / (float)GunConfig.SERVER.projectileSpread.maxCount;
        }
        return 0.0f;
    }
}

