/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.item;

import com.setycz.chickens.entity.EntityColoredEgg;
import com.setycz.chickens.handler.IColorSource;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEgg;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemColoredEgg
extends ItemEgg
implements IColorSource {
    public ItemColoredEgg() {
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(I18n.func_74838_a((String)"item.colored_egg.tooltip"));
    }

    public String func_77653_i(ItemStack stack) {
        EnumDyeColor color = EnumDyeColor.func_176766_a((int)stack.func_77960_j());
        String unlocalizedName = color.func_176762_d();
        if (unlocalizedName.equals("silver")) {
            unlocalizedName = unlocalizedName + "Dye";
        }
        return I18n.func_74838_a((String)(this.func_77658_a() + "." + unlocalizedName + ".name"));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
                if (!chicken.isDye()) continue;
                subItems.add((Object)new ItemStack((Item)this, 1, chicken.getDyeMetadata()));
            }
        }
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        return EnumDyeColor.func_176766_a((int)stack.func_77960_j()).func_193350_e();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        String chickenType;
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (!playerIn.field_71075_bZ.field_75098_d) {
            itemStackIn.func_190918_g(1);
        }
        worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187511_aA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.field_72995_K && (chickenType = this.getChickenType(itemStackIn)) != null) {
            EntityColoredEgg entityIn = new EntityColoredEgg(worldIn, (EntityLivingBase)playerIn);
            entityIn.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
            entityIn.setChickenType(chickenType);
            worldIn.func_72838_d((Entity)entityIn);
        }
        playerIn.func_71029_a(StatList.func_188057_b((Item)this));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public String getChickenType(ItemStack itemStack) {
        ChickensRegistryItem chicken = ChickensRegistry.findDyeChicken(itemStack.func_77960_j());
        if (chicken == null) {
            return null;
        }
        return chicken.getRegistryName().toString();
    }
}

