/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.wings.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.paulf.wings.util.NBTSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public final class CapabilityProviders {
    private CapabilityProviders() {
    }

    public static ICapabilityProvider empty() {
        return EmptyProvider.INSTANCE;
    }

    public static <T> NonSerializingSingleBuilder<T> emptyBuilder() {
        return EmptySingleBuilder.INSTANCE;
    }

    public static <T> NonSerializingSingleBuilder<T> builder(Capability<? super T> capability, T instance) {
        return new NonSerializingSingleBuilderImpl(capability, instance);
    }

    public static <T> SingleBuilder<T> builder(final Capability<T> capability) {
        return new NonSerializingSingleBuilderImpl(capability, capability.getDefaultInstance()).serializedBy(new NBTSerializer<T, NBTBase>(){

            @Override
            public NBTBase serialize(T instance) {
                return capability.writeNBT(instance, null);
            }

            @Override
            public T deserialize(NBTBase compound) {
                Object instance = capability.getDefaultInstance();
                capability.readNBT(instance, null, compound);
                return instance;
            }
        });
    }

    public static CompositeBuilder builder() {
        return new CompositeBuilderImpl();
    }

    private static final class SerializingSingleBuilderImpl<T, N extends NBTBase>
    extends AbstractSingleBuilder<T>
    implements SingleBuilder<T> {
        private final NBTSerializer<T, N> serializer;

        private SerializingSingleBuilderImpl(Capability<? super T> capability, T instance, NBTSerializer<T, N> serializer) {
            super(capability, instance);
            this.serializer = serializer;
        }

        public SerializingSingleBuilderImpl<T, N> peek(Consumer<T> consumer) {
            consumer.accept(this.instance);
            return this;
        }

        @Override
        public ICapabilityProvider build() {
            return new SerializingSingleProvider(this.capability, this.instance, this.serializer);
        }
    }

    private static final class NonSerializingSingleBuilderImpl<T>
    extends AbstractSingleBuilder<T>
    implements NonSerializingSingleBuilder<T> {
        private NonSerializingSingleBuilderImpl(Capability<? super T> capability, T instance) {
            super(capability, instance);
        }

        public <N extends NBTBase> SerializingSingleBuilderImpl<T, N> serializedBy(NBTSerializer<T, N> serializer) {
            return new SerializingSingleBuilderImpl(this.capability, this.instance, serializer);
        }

        @Override
        public NonSerializingSingleBuilder<T> peek(Consumer<T> consumer) {
            consumer.accept(this.instance);
            return this;
        }

        @Override
        public ICapabilityProvider build() {
            return new SimpleSingleProvider(this.capability, this.instance);
        }
    }

    public static interface NonSerializingSingleBuilder<T>
    extends SingleBuilder<T> {
        public <N extends NBTBase> SingleBuilder<T> serializedBy(NBTSerializer<T, N> var1);
    }

    public static interface SingleBuilder<T> {
        public SingleBuilder<T> peek(Consumer<T> var1);

        public ICapabilityProvider build();
    }

    private static abstract class AbstractSingleBuilder<T>
    implements SingleBuilder<T> {
        final Capability<? super T> capability;
        final T instance;

        AbstractSingleBuilder(Capability<? super T> capability, T instance) {
            this.capability = capability;
            this.instance = instance;
        }
    }

    private static final class SerializingSingleProvider<T, N extends NBTBase>
    extends SingleProvider<T>
    implements INBTSerializable<N> {
        final NBTSerializer<T, N> serializer;

        private SerializingSingleProvider(Capability<? super T> capability, T instance, NBTSerializer<T, N> serializer) {
            super(capability, instance);
            this.serializer = serializer;
        }

        public N serializeNBT() {
            return this.serializer.serialize(this.instance);
        }

        public void deserializeNBT(N compound) {
            this.instance = this.serializer.deserialize(compound);
        }
    }

    private static final class SimpleSingleProvider<T>
    extends SingleProvider<T> {
        private SimpleSingleProvider(Capability<? super T> capability, T instance) {
            super(capability, instance);
        }
    }

    private static abstract class SingleProvider<T>
    implements ICapabilityProvider {
        final Capability<? super T> capability;
        T instance;

        private SingleProvider(Capability<? super T> capability, T instance) {
            this.capability = capability;
            this.instance = instance;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return this.capability == capability;
        }

        @Nullable
        public <C> C getCapability(@Nonnull Capability<C> capability, @Nullable EnumFacing facing) {
            return (C)(this.capability == capability ? this.capability.cast(this.instance) : null);
        }
    }

    private static final class EmptyProvider
    implements ICapabilityProvider {
        private static final EmptyProvider INSTANCE = new EmptyProvider();

        private EmptyProvider() {
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return false;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return null;
        }
    }

    private static final class EmptySingleBuilder<T>
    implements NonSerializingSingleBuilder<T> {
        private static final EmptySingleBuilder<?> INSTANCE = new EmptySingleBuilder();

        private EmptySingleBuilder() {
        }

        @Override
        public <N extends NBTBase> SingleBuilder<T> serializedBy(NBTSerializer<T, N> serializer) {
            return this;
        }

        @Override
        public SingleBuilder<T> peek(Consumer<T> consumer) {
            return this;
        }

        @Override
        public ICapabilityProvider build() {
            return CapabilityProviders.empty();
        }
    }

    private static final class CompositeProvider
    implements ICapabilityProvider {
        private final ImmutableList<ICapabilityProvider> providers;

        private CompositeProvider(ImmutableList<ICapabilityProvider> providers) {
            this.providers = providers;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            for (ICapabilityProvider provider : this.providers) {
                if (!provider.hasCapability(capability, facing)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            for (ICapabilityProvider provider : this.providers) {
                Object instance = provider.getCapability(capability, facing);
                if (instance == null) continue;
                return (T)instance;
            }
            return null;
        }
    }

    private static final class CompositeBuilderImpl
    implements CompositeBuilder {
        private final ImmutableList.Builder<ICapabilityProvider> providers;

        private CompositeBuilderImpl() {
            this((ImmutableList.Builder<ICapabilityProvider>)ImmutableList.builder());
        }

        private CompositeBuilderImpl(ImmutableList.Builder<ICapabilityProvider> providers) {
            this.providers = providers;
        }

        @Override
        public CompositeBuilder add(ICapabilityProvider provider) {
            this.providers.add((Object)provider);
            return this;
        }

        @Override
        public ICapabilityProvider build() {
            ImmutableList providers = this.providers.build();
            switch (providers.size()) {
                case 0: {
                    return CapabilityProviders.empty();
                }
                case 1: {
                    return (ICapabilityProvider)Iterables.getOnlyElement((Iterable)providers);
                }
            }
            return new CompositeProvider(providers);
        }
    }

    public static interface CompositeBuilder {
        public CompositeBuilder add(ICapabilityProvider var1);

        public ICapabilityProvider build();
    }
}

