/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.debug.DebugOverlay;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.RequestSecretPacket;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.voice.client.ClientCategoryManager;
import de.maxhenkel.voicechat.voice.client.ClientGroupManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.client.InitializationData;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.client.PTTKeyHandler;
import de.maxhenkel.voicechat.voice.client.RenderEvents;
import de.maxhenkel.voicechat.voice.server.Server;
import io.netty.channel.local.LocalAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;

public class ClientManager {
    @Nullable
    private ClientVoicechat client;
    private final ClientPlayerStateManager playerStateManager = new ClientPlayerStateManager();
    private final ClientGroupManager groupManager = new ClientGroupManager();
    private final ClientCategoryManager categoryManager = new ClientCategoryManager();
    private final PTTKeyHandler pttKeyHandler = new PTTKeyHandler();
    private final RenderEvents renderEvents = new RenderEvents();
    private final DebugOverlay debugOverlay = new DebugOverlay();
    private final KeyEvents keyEvents = new KeyEvents();
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private static ClientManager instance;

    private ClientManager() {
        ClientCompatibilityManager.INSTANCE.onJoinWorld(this::onJoinWorld);
        ClientCompatibilityManager.INSTANCE.onDisconnect(this::onDisconnect);
        ClientCompatibilityManager.INSTANCE.onPublishServer(this::onPublishServer);
        ClientCompatibilityManager.INSTANCE.onVoiceChatConnected(connection -> {
            if (this.client != null) {
                this.client.onVoiceChatConnected((ClientVoicechatConnection)connection);
            }
        });
        ClientCompatibilityManager.INSTANCE.onVoiceChatDisconnected(() -> {
            if (this.client != null) {
                this.client.onVoiceChatDisconnected();
            }
        });
        CommonCompatibilityManager.INSTANCE.getNetManager().secretChannel.setClientListener((client, handler, packet) -> this.authenticate((SecretPacket)packet));
    }

    private void authenticate(SecretPacket secretPacket) {
        NetHandlerPlayClient connection;
        if (this.client == null) {
            Voicechat.LOGGER.error("Received secret without a client being present", new Object[0]);
            return;
        }
        Voicechat.LOGGER.info("Received secret", new Object[0]);
        if (this.client.getConnection() != null) {
            ClientCompatibilityManager.INSTANCE.emitVoiceChatDisconnectedEvent();
        }
        if ((connection = this.minecraft.func_147114_u()) != null) {
            try {
                SocketAddress socketAddress = ClientCompatibilityManager.INSTANCE.getSocketAddress(connection.func_147298_b());
                if (socketAddress instanceof InetSocketAddress) {
                    InetSocketAddress address = (InetSocketAddress)socketAddress;
                    this.client.connect(new InitializationData(address.getHostString(), secretPacket));
                } else if (socketAddress instanceof LocalAddress) {
                    this.client.connect(new InitializationData("127.0.0.1", secretPacket));
                }
            }
            catch (Exception e) {
                Voicechat.LOGGER.error("Failed to determine server address", e);
            }
        }
    }

    private void onJoinWorld() {
        if (VoicechatClient.CLIENT_CONFIG.muteOnJoin.get().booleanValue()) {
            VoicechatClient.CLIENT_CONFIG.muted.set(true);
        }
        if (this.client != null) {
            Voicechat.LOGGER.info("Disconnecting from previous connection due to server change", new Object[0]);
            this.onDisconnect();
        }
        Voicechat.LOGGER.info("Sending secret request to the server", new Object[0]);
        NetManager.sendToServer(new RequestSecretPacket(Voicechat.COMPATIBILITY_VERSION));
        this.client = new ClientVoicechat();
    }

    public static void sendPlayerError(String translationKey, @Nullable Exception e) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Style style = new Style().func_150238_a(TextFormatting.RED);
        if (e != null) {
            style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new TextComponentString(e.getMessage()).func_150255_a(new Style().func_150238_a(TextFormatting.RED))));
        }
        player.func_145747_a(ClientManager.wrapInSquareBrackets((ITextComponent)new TextComponentString(CommonCompatibilityManager.INSTANCE.getModName())).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)).func_150258_a(" ").func_150257_a(new TextComponentTranslation(translationKey, new Object[0]).func_150255_a(style)));
    }

    private static ITextComponent wrapInSquareBrackets(ITextComponent component) {
        return new TextComponentString("[").func_150257_a(component).func_150258_a("]");
    }

    private void onDisconnect() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        ClientCompatibilityManager.INSTANCE.emitVoiceChatDisconnectedEvent();
    }

    private void onPublishServer(int port) {
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return;
        }
        try {
            ClientVoicechatConnection connection;
            Voicechat.LOGGER.info("Changing voice chat port to {}", port);
            server.changePort(port);
            ClientVoicechat client = ClientManager.getClient();
            if (client != null && (connection = client.getConnection()) != null) {
                Voicechat.LOGGER.info("Force disconnecting due to port change", new Object[0]);
                connection.disconnect();
            }
            NetManager.sendToServer(new RequestSecretPacket(Voicechat.COMPATIBILITY_VERSION));
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to change voice chat port", e);
        }
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentTranslation("message.voicechat.server_port", new Object[]{server.getPort()}));
    }

    @Nullable
    public static ClientVoicechat getClient() {
        return ClientManager.instance().client;
    }

    public static ClientPlayerStateManager getPlayerStateManager() {
        return ClientManager.instance().playerStateManager;
    }

    public static ClientGroupManager getGroupManager() {
        return ClientManager.instance().groupManager;
    }

    public static ClientCategoryManager getCategoryManager() {
        return ClientManager.instance().categoryManager;
    }

    public static PTTKeyHandler getPttKeyHandler() {
        return ClientManager.instance().pttKeyHandler;
    }

    public static RenderEvents getRenderEvents() {
        return ClientManager.instance().renderEvents;
    }

    public static DebugOverlay getDebugOverlay() {
        return ClientManager.instance().debugOverlay;
    }

    public KeyEvents getKeyEvents() {
        return this.keyEvents;
    }

    public static synchronized ClientManager instance() {
        if (instance == null) {
            instance = new ClientManager();
        }
        return instance;
    }
}

