/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import de.maxhenkel.voicechat.api.Group;
import de.maxhenkel.voicechat.plugins.impl.GroupImpl;
import java.util.UUID;
import net.minecraft.network.PacketBuffer;

public class ClientGroup {
    private final UUID id;
    private final String name;
    private final boolean hasPassword;
    private final boolean persistent;
    private final Group.Type type;

    public ClientGroup(UUID id, String name, boolean hasPassword, boolean persistent, Group.Type type) {
        this.id = id;
        this.name = name;
        this.hasPassword = hasPassword;
        this.persistent = persistent;
        this.type = type;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public Group.Type getType() {
        return this.type;
    }

    public static ClientGroup fromBytes(PacketBuffer buf) {
        return new ClientGroup(buf.func_179253_g(), buf.func_150789_c(512), buf.readBoolean(), buf.readBoolean(), GroupImpl.TypeImpl.fromInt(buf.readShort()));
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179252_a(this.id);
        buf.func_180714_a(this.name);
        buf.writeBoolean(this.hasPassword);
        buf.writeBoolean(this.persistent);
        buf.writeShort((int)GroupImpl.TypeImpl.toInt(this.type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientGroup group = (ClientGroup)o;
        return this.id != null ? this.id.equals(group.id) : group.id == null;
    }
}

