/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingRecipe;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class ArcRecyclingThreadHandler
extends Thread {
    static boolean hasProfiled = false;
    private ArrayList<RecyclingCalculation> validated;
    private ArrayListMultimap<ItemStack, RecyclingCalculation> nonValidated;
    private List<IRecipe> recipeList = new ArrayList<IRecipe>(ForgeRegistries.RECIPES.getValuesCollection());

    @Override
    public void run() {
        Iterator<ArcFurnaceRecipe> prevRecipeIt = ArcFurnaceRecipe.recipeList.iterator();
        int r = 0;
        if (hasProfiled) {
            while (prevRecipeIt.hasNext()) {
                ArcFurnaceRecipe recipe = prevRecipeIt.next();
                if (!"Recycling".equals(recipe.specialRecipeType)) continue;
                prevRecipeIt.remove();
                ++r;
            }
        }
        IELogger.info("Arc Recycling: Removed " + r + " old recipes");
        int threadAmount = Math.max(Runtime.getRuntime().availableProcessors() - 1, 1);
        RegistryIterationThread[] threads = new RegistryIterationThread[threadAmount];
        long timestamp = System.currentTimeMillis();
        boolean divisable = this.recipeList.size() % threadAmount == 0;
        int limit = divisable ? this.recipeList.size() / threadAmount : this.recipeList.size() / (threadAmount - 1);
        int leftOver = divisable ? limit : this.recipeList.size() - (threadAmount - 1) * limit;
        for (int i = 0; i < threadAmount; ++i) {
            threads[i] = new RegistryIterationThread(this.recipeList, limit * i, i == threadAmount - 1 ? leftOver : limit);
        }
        this.validated = new ArrayList();
        this.nonValidated = ArrayListMultimap.create();
        int invalidCount = 0;
        for (int i = 0; i < threads.length; ++i) {
            RegistryIterationThread thread = threads[i];
            try {
                thread.join();
                for (RecyclingCalculation calc : thread.calculatedOutputs) {
                    if (calc.isValid()) {
                        this.validated.add(calc);
                        continue;
                    }
                    for (ItemStack s : calc.queriedSubcomponents.keySet()) {
                        this.nonValidated.put((Object)s, (Object)calc);
                    }
                    ++invalidCount;
                }
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        int timeout = 0;
        while (!this.nonValidated.isEmpty() && timeout++ < invalidCount * 10) {
            ArrayList<RecyclingCalculation> newlyValid = new ArrayList<RecyclingCalculation>();
            for (RecyclingCalculation valid : this.validated) {
                for (ItemStack key : this.nonValidated.keySet()) {
                    if (!OreDictionary.itemMatches((ItemStack)key, (ItemStack)valid.stack, (boolean)false)) continue;
                    for (RecyclingCalculation nonValid : this.nonValidated.get((Object)key)) {
                        if (!nonValid.validateSubcomponent(valid)) continue;
                        newlyValid.add(nonValid);
                    }
                }
            }
            if (newlyValid.isEmpty()) break;
            this.nonValidated.values().removeAll(newlyValid);
            this.validated.addAll(newlyValid);
        }
        IELogger.info("Finished recipe profiler for Arc Recycling, took " + (System.currentTimeMillis() - timestamp) + " milliseconds");
    }

    public void finishUp() {
        HashSet<String> finishedRecycles = new HashSet<String>();
        for (RecyclingCalculation valid : this.validated) {
            if (!finishedRecycles.add(valid.stack.toString()) || valid.outputs.isEmpty()) continue;
            ArcFurnaceRecipe.recipeList.add(new ArcRecyclingRecipe(valid.outputs, valid.stack, 100, 512));
        }
        for (RecyclingCalculation invalid : Sets.newHashSet((Iterable)this.nonValidated.values())) {
            if (!finishedRecycles.add(invalid.stack.toString()) || invalid.outputs.isEmpty()) continue;
            IELogger.info("Couldn't fully analyze " + invalid.stack + ", missing knowledge for " + invalid.queriedSubcomponents);
            ArcFurnaceRecipe.recipeList.add(new ArcRecyclingRecipe(invalid.outputs, invalid.stack, 100, 512));
        }
        hasProfiled = true;
    }

    public static boolean isValidForRecycling(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemTool || item instanceof ItemSword || item instanceof ItemHoe || item instanceof ItemArmor) {
            return true;
        }
        for (Object recycle : ArcFurnaceRecipe.recyclingAllowed) {
            if (!ApiUtils.stackMatchesObject(stack, recycle)) continue;
            return true;
        }
        return false;
    }

    public static RecyclingCalculation getRecycleCalculation(ItemStack stack, IRecipe recipe) {
        NonNullList inputs = recipe.func_192400_c();
        if (!inputs.isEmpty()) {
            int inputSize = stack.func_190916_E();
            HashMap<ItemStack, Integer> missingSub = new HashMap<ItemStack, Integer>();
            IdentityHashMap<ItemStack, Double> outputs = new IdentityHashMap<ItemStack, Double>();
            for (Object in : inputs) {
                if (in == null || in == Ingredient.field_193370_a) continue;
                ItemStack itemStack = IEApi.getPreferredStackbyMod(in.func_193365_a());
                if (itemStack.func_190926_b()) {
                    IELogger.warn("Recipe has invalid inputs and will be ignored: " + recipe + " (" + recipe.getRegistryName() + ")");
                    return null;
                }
                Object[] brokenDown = ApiUtils.breakStackIntoPreciseIngots(itemStack);
                if (brokenDown == null) {
                    if (!ArcRecyclingThreadHandler.isValidForRecycling(itemStack)) continue;
                    boolean b = false;
                    for (ItemStack storedMiss : missingSub.keySet()) {
                        if (!OreDictionary.itemMatches((ItemStack)itemStack, (ItemStack)storedMiss, (boolean)false)) continue;
                        missingSub.put(storedMiss, (Integer)missingSub.get(storedMiss) + itemStack.func_190916_E());
                        b = true;
                    }
                    if (b) continue;
                    missingSub.put(Utils.copyStackWithAmount(itemStack, 1), itemStack.func_190916_E());
                    continue;
                }
                if (!(brokenDown[0] instanceof ItemStack) || ((ItemStack)brokenDown[0]).func_190926_b() || brokenDown[1] == null || !((Double)brokenDown[1] > 0.0)) continue;
                boolean invalidOutput = false;
                for (Object invalid : ArcFurnaceRecipe.invalidRecyclingOutput) {
                    if (!ApiUtils.stackMatchesObject((ItemStack)brokenDown[0], invalid)) continue;
                    invalidOutput = true;
                }
                if (invalidOutput) continue;
                boolean b = false;
                for (ItemStack storedOut : outputs.keySet()) {
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)brokenDown[0]), (ItemStack)storedOut, (boolean)false)) continue;
                    outputs.put(storedOut, (Double)outputs.get(storedOut) + (Double)brokenDown[1]);
                    b = true;
                }
                if (b) continue;
                outputs.put(Utils.copyStackWithAmount((ItemStack)brokenDown[0], 1), (Double)brokenDown[1]);
            }
            IdentityHashMap<ItemStack, Double> outputScaled = new IdentityHashMap<ItemStack, Double>(outputs.size());
            for (Map.Entry entry : outputs.entrySet()) {
                outputScaled.put((ItemStack)entry.getKey(), (Double)entry.getValue() / (double)inputSize);
            }
            if (!outputs.isEmpty() || !missingSub.isEmpty()) {
                Object in;
                in = Utils.copyStackWithAmount(stack, 1);
                if (in.func_77973_b().func_77645_m()) {
                    in.func_77964_b(Short.MAX_VALUE);
                }
                RecyclingCalculation recyclingCalculation = new RecyclingCalculation(recipe, (ItemStack)in, outputScaled);
                if (!missingSub.isEmpty()) {
                    for (ItemStack s : missingSub.keySet()) {
                        recyclingCalculation.queriedSubcomponents.put(s, (double)((Integer)missingSub.get(s)).intValue() / (double)inputSize);
                    }
                }
                return recyclingCalculation;
            }
        }
        return null;
    }

    public static class RecyclingCalculation {
        IRecipe recipe;
        ItemStack stack;
        Map<ItemStack, Double> outputs;
        Map<ItemStack, Double> queriedSubcomponents = new HashMap<ItemStack, Double>();

        public RecyclingCalculation(IRecipe recipe, ItemStack stack, Map<ItemStack, Double> outputs) {
            this.recipe = recipe;
            this.stack = stack;
            this.outputs = outputs;
        }

        public boolean isValid() {
            return !this.outputs.isEmpty() && this.queriedSubcomponents.isEmpty();
        }

        public boolean validateSubcomponent(RecyclingCalculation calc) {
            if (this.isValid()) {
                return true;
            }
            if (!calc.isValid()) {
                return false;
            }
            Iterator<ItemStack> it = this.queriedSubcomponents.keySet().iterator();
            while (it.hasNext()) {
                ItemStack next = it.next();
                if (!OreDictionary.itemMatches((ItemStack)next, (ItemStack)calc.stack, (boolean)false)) continue;
                double queriedAmount = this.queriedSubcomponents.get(next);
                for (Map.Entry<ItemStack, Double> e : calc.outputs.entrySet()) {
                    double scaledVal = e.getValue() * queriedAmount;
                    boolean b = true;
                    for (ItemStack key : this.outputs.keySet()) {
                        if (!OreDictionary.itemMatches((ItemStack)key, (ItemStack)e.getKey(), (boolean)false)) continue;
                        this.outputs.put(key, this.outputs.get(key) + scaledVal);
                        b = false;
                        break;
                    }
                    if (!b) continue;
                    this.outputs.put(e.getKey(), scaledVal);
                }
                it.remove();
            }
            return this.isValid();
        }
    }

    public static class RegistryIterationThread
    extends Thread {
        final List<IRecipe> recipeList;
        final int baseOffset;
        final int passes;
        ArrayList<RecyclingCalculation> calculatedOutputs = new ArrayList();

        public RegistryIterationThread(List<IRecipe> recipeList, int baseOffset, int passes) {
            this.setName("Immersive Engineering Registry Iteration Thread");
            this.setDaemon(true);
            this.start();
            this.recipeList = recipeList;
            this.baseOffset = baseOffset;
            this.passes = passes;
        }

        @Override
        public void run() {
            for (int pass = 0; pass < this.passes; ++pass) {
                RecyclingCalculation calc;
                IRecipe recipe = this.recipeList.get(this.baseOffset + pass);
                if (recipe.func_77571_b().func_190926_b() || !ArcRecyclingThreadHandler.isValidForRecycling(recipe.func_77571_b()) || (calc = ArcRecyclingThreadHandler.getRecycleCalculation(recipe.func_77571_b(), recipe)) == null) continue;
                this.calculatedOutputs.add(calc);
            }
        }
    }
}

