/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.api.satellite;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.ISatelliteIdItem;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.libVulpes.util.UniversalBattery;

public abstract class SatelliteBase {
    protected SatelliteProperties satelliteProperties = new SatelliteProperties();
    private int dimId = -2147483647;
    protected ItemStack satellite;
    private boolean isDead;
    protected UniversalBattery battery;

    public SatelliteBase() {
        this.satelliteProperties.setSatelliteType(SatelliteRegistry.getKey(this.getClass()));
        this.isDead = false;
        this.satellite = ItemStack.field_190927_a;
        this.battery = new UniversalBattery(this.satelliteProperties.getPowerStorage());
    }

    public boolean acceptsItemInConstruction(@Nonnull ItemStack item) {
        int flag = SatelliteRegistry.getSatelliteProperty(item).getPropertyFlag();
        return SatelliteProperties.Property.MAIN.isOfType(flag) || SatelliteProperties.Property.POWER_GEN.isOfType(flag) || SatelliteProperties.Property.BATTERY.isOfType(flag);
    }

    public abstract String getInfo(World var1);

    public abstract String getName();

    public abstract boolean performAction(EntityPlayer var1, World var2, BlockPos var3);

    public abstract double failureChance();

    public int getPowerPerTick() {
        return this.satelliteProperties.getPowerGeneration();
    }

    @Nonnull
    public ItemStack getControllerItemStack(@Nonnull ItemStack satIdChip, SatelliteProperties properties) {
        ISatelliteIdItem idChipItem = (ISatelliteIdItem)satIdChip.func_77973_b();
        idChipItem.setSatellite(satIdChip, properties);
        return satIdChip;
    }

    public boolean isAcceptableControllerItemStack(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == AdvancedRocketryItems.itemSatelliteIdChip;
    }

    public boolean canTick() {
        return true;
    }

    public void tickEntity() {
        this.battery.acceptEnergy(this.getPowerPerTick() - 1, false);
    }

    public long getId() {
        return this.satelliteProperties.getId();
    }

    public void setDead() {
        this.isDead = true;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public void setDimensionId(World world) {
        int newId = world.field_73011_w.getDimension();
        if (this.dimId != -2147483647) {
            // empty if block
        }
        this.dimId = newId;
    }

    public void setDimensionId(int world) {
        if (this.dimId != -2147483647) {
            // empty if block
        }
        this.dimId = world;
    }

    public SatelliteProperties getProperties() {
        return this.satelliteProperties;
    }

    public void setProperties(@Nonnull ItemStack stack) {
        this.satelliteProperties = SatelliteRegistry.getSatelliteProperties(stack);
        this.battery.setMaxEnergyStored(this.satelliteProperties.getPowerStorage());
        this.satellite = stack;
    }

    @Nonnull
    public ItemStack getItemStackFromSatellite() {
        return this.satellite;
    }

    public int getDimensionId() {
        return this.dimId;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("dataType", SatelliteRegistry.getKey(this.getClass()));
        NBTTagCompound properties = new NBTTagCompound();
        this.satelliteProperties.writeToNBT(properties);
        nbt.func_74782_a("properties", (NBTBase)properties);
        nbt.func_74768_a("dimId", this.dimId);
        this.battery.writeToNBT(nbt);
        NBTTagCompound itemNBT = new NBTTagCompound();
        if (!this.satellite.func_190926_b()) {
            this.satellite.func_77955_b(itemNBT);
        }
        nbt.func_74782_a("item", (NBTBase)itemNBT);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.satelliteProperties.readFromNBT(nbt.func_74775_l("properties"));
        this.dimId = nbt.func_74762_e("dimId");
        this.satellite = new ItemStack(nbt.func_74775_l("item"));
        this.battery.readFromNBT(nbt);
        if (this.satelliteProperties.getPowerStorage() == 0) {
            this.satelliteProperties.setPowerStorage(720);
            this.battery = new UniversalBattery(720);
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte packetId) {
    }

    public void readDataToNetwork(byte packetId, ByteBuf in) {
    }

    public void useNetworkData(EntityPlayer player, Side client, byte packetId, NBTTagCompound nbt) {
    }

    public int numberChangesToSend() {
        return 0;
    }

    public void onChangeReceived(int slot, int value) {
    }

    public boolean isUpdateRequired(int localId) {
        return false;
    }

    public void sendChanges(Container container, IContainerListener crafter, int variableId, int localId) {
    }
}

