/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.stations.SpaceStationObject;

public class PlanetaryTravelHelper {
    public static boolean isTravelBetweenBodiesWithinPlanetarySystem(int currentDimensionID, int destinationDimensionID) {
        boolean isPlanetMoonSystem = false;
        DimensionProperties launchworldProperties = DimensionManager.getInstance().getDimensionProperties(currentDimensionID);
        if (launchworldProperties.isMoon()) {
            isPlanetMoonSystem = destinationDimensionID == launchworldProperties.getParentPlanet();
            for (int moonDimID : launchworldProperties.getParentProperties().getChildPlanets()) {
                if (destinationDimensionID != moonDimID) continue;
                isPlanetMoonSystem = true;
                break;
            }
        } else {
            for (int moonDimID : launchworldProperties.getChildPlanets()) {
                if (destinationDimensionID != moonDimID) continue;
                isPlanetMoonSystem = true;
                break;
            }
        }
        return isPlanetMoonSystem;
    }

    public static int getTransbodyInjectionBurn(int currentDimensionID, int destinationDimensionID, boolean toAsteroids) {
        int baseInjectionHeight = ARConfiguration.getCurrentConfig().transBodyInjection;
        return PlanetaryTravelHelper.isTravelBetweenBodiesWithinPlanetarySystem(currentDimensionID, destinationDimensionID) ? (int)((double)baseInjectionHeight * Math.pow(PlanetaryTravelHelper.getBodyDistanceMultiplier(currentDimensionID, destinationDimensionID, toAsteroids), 0.5)) : (int)ARConfiguration.getCurrentConfig().warpTBIBurnMult * baseInjectionHeight;
    }

    public static double getBodyDistanceMultiplier(int currentDimensionID, int destinationDimensionID, boolean toAsteroids) {
        double bodyDistanceMultiplier = 1.0;
        DimensionProperties destinationProperties = DimensionManager.getInstance().getDimensionProperties(destinationDimensionID);
        if (destinationProperties.isMoon()) {
            bodyDistanceMultiplier = (double)destinationProperties.getOrbitalDist() / 100.0;
        } else {
            for (int moonDimID : destinationProperties.getChildPlanets()) {
                if (currentDimensionID != moonDimID) continue;
                bodyDistanceMultiplier = (double)DimensionManager.getInstance().getDimensionProperties(moonDimID).getOrbitalDist() / 100.0;
            }
        }
        if (toAsteroids) {
            bodyDistanceMultiplier = ARConfiguration.getCurrentConfig().asteroidTBIBurnMult;
        }
        return bodyDistanceMultiplier;
    }

    public static boolean isTravelAnywhereInPlanetarySystem(int currentDimensionID, int destinationDimensionID) {
        return PlanetaryTravelHelper.isTravelWithinOrbit(currentDimensionID, destinationDimensionID) || PlanetaryTravelHelper.isTravelBetweenBodiesWithinPlanetarySystem(currentDimensionID, destinationDimensionID);
    }

    public static boolean isTravelWithinOrbit(int currentDimensionID, int destinationDimensionID) {
        return currentDimensionID == destinationDimensionID;
    }

    public static boolean isTravelWithinGeostationaryOrbit(SpaceStationObject spaceStation, int planetID) {
        return spaceStation.getOrbitingPlanetId() == planetID && spaceStation.getOrbitalDistance() >= 177.0f && 181.0f >= spaceStation.getOrbitalDistance();
    }
}

