/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.gui.gas;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import com.the9grounds.aeadditions.container.gas.ContainerBusGasStorage;
import com.the9grounds.aeadditions.gui.GuiBase;
import com.the9grounds.aeadditions.gui.IFluidSlotGuiTransfer;
import com.the9grounds.aeadditions.gui.ISlotRenderer;
import com.the9grounds.aeadditions.gui.SlotUpgradeRenderer;
import com.the9grounds.aeadditions.gui.buttons.ButtonStorageDirection;
import com.the9grounds.aeadditions.gui.widget.fluid.WidgetFluidSlot;
import com.the9grounds.aeadditions.network.packet.other.IFluidSlotGui;
import com.the9grounds.aeadditions.network.packet.part.PacketPartConfig;
import com.the9grounds.aeadditions.part.gas.PartGasStorage;
import com.the9grounds.aeadditions.registries.PartEnum;
import com.the9grounds.aeadditions.util.FluidHelper;
import com.the9grounds.aeadditions.util.NetworkUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GuiBusGasStorage
extends GuiBase<ContainerBusGasStorage>
implements WidgetFluidSlot.IConfigurable,
IFluidSlotGui,
IFluidSlotGuiTransfer {
    private EntityPlayer player;
    private byte filterSize;
    private List<WidgetFluidSlot> fluidSlotList = new ArrayList<WidgetFluidSlot>();
    private boolean hasNetworkTool;
    private final PartGasStorage part;

    public GuiBusGasStorage(PartGasStorage part, EntityPlayer _player) {
        super(new ResourceLocation("aeadditions", "textures/gui/storagebusfluid.png"), new ContainerBusGasStorage(part, _player));
        this.part = part;
        ((ContainerBusGasStorage)this.container).setGui(this);
        this.player = _player;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 6; ++j) {
                WidgetFluidSlot fluidSlot = new WidgetFluidSlot(this.widgetManager, this.part, i * 6 + j, 18 * i + 7, 18 * j + 17);
                this.fluidSlotList.add(fluidSlot);
                this.widgetManager.add(fluidSlot);
                fluidSlot.setAlwaysAvailable(true);
            }
        }
        NetworkUtil.sendToServer(new PacketPartConfig(this.part, "FluidStorage.Info"));
        this.hasNetworkTool = this.field_147002_h.func_75138_a().size() > 40;
        this.field_146999_f = this.hasNetworkTool ? 246 : 211;
        this.field_147000_g = 222;
    }

    public void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof ButtonStorageDirection) {
            AccessRestriction restriction;
            switch (((ButtonStorageDirection)button).getAccessRestriction()) {
                case NO_ACCESS: {
                    restriction = AccessRestriction.READ;
                    break;
                }
                case READ: {
                    restriction = AccessRestriction.READ_WRITE;
                    break;
                }
                case READ_WRITE: {
                    restriction = AccessRestriction.WRITE;
                    break;
                }
                case WRITE: {
                    restriction = AccessRestriction.NO_ACCESS;
                    break;
                }
                default: {
                    restriction = null;
                }
            }
            if (restriction != null) {
                NetworkUtil.sendToServer(new PacketPartConfig(this.part, "FluidStorage.Access", restriction.toString()));
            }
        }
    }

    public void changeConfig(byte _filterSize) {
        this.filterSize = _filterSize;
    }

    @Override
    protected void drawBackground() {
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 222);
        this.func_73729_b(this.field_147003_i + 179, this.field_147009_r, 179, 0, 32, 86);
        if (this.hasNetworkTool) {
            this.func_73729_b(this.field_147003_i + 179, this.field_147009_r + 93, 178, 93, 68, 68);
        }
    }

    @Override
    protected boolean hasSlotRenders() {
        return true;
    }

    @Override
    @Nullable
    protected ISlotRenderer getSlotRenderer(Slot slot) {
        if (!(slot.func_75211_c() != null && !slot.func_75211_c().func_190926_b() || slot.field_75222_d >= 1 && slot.field_75222_d <= 37)) {
            return SlotUpgradeRenderer.INSTANCE;
        }
        return null;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        PartEnum partEnum = PartEnum.GASSTORAGE;
        this.field_146289_q.func_78276_b(partEnum.getStatName().replace("ME ", ""), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.player.field_71071_by.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 3, 0x404040);
    }

    @Override
    public byte getConfigState() {
        return this.filterSize;
    }

    protected Slot func_146975_c(int mouseX, int mouseY) {
        for (Slot slot : ((ContainerBusGasStorage)this.container).field_75151_b) {
            if (!this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new ButtonStorageDirection(0, this.field_147003_i - 18, this.field_147009_r, 16, 16, AccessRestriction.READ_WRITE));
    }

    private boolean isMouseOverSlot(Slot p_146981_1_, int p_146981_2_, int p_146981_3_) {
        return this.func_146978_c(p_146981_1_.field_75223_e, p_146981_1_.field_75221_f, 16, 16, p_146981_2_, p_146981_3_);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseBtn) throws IOException {
        Slot slot = this.func_146975_c(mouseX, mouseY);
        if (slot != null && slot.func_75211_c() != null && AEApi.instance().definitions().items().networkTool().isSameAs(slot.func_75211_c())) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseBtn);
    }

    @Override
    public boolean shiftClick(ItemStack itemStack) {
        FluidStack containerFluid = FluidHelper.getFluidFromContainer(itemStack);
        Fluid fluid = containerFluid == null ? null : containerFluid.getFluid();
        for (WidgetFluidSlot fluidSlot : this.fluidSlotList) {
            if (fluid == null || fluidSlot.getFluid() != null && fluidSlot.getFluid() != fluid) continue;
            fluidSlot.handleContainer(itemStack);
            return true;
        }
        return false;
    }

    public void updateAccessRestriction(AccessRestriction mode) {
        if (this.field_146292_n.size() > 0) {
            ((ButtonStorageDirection)this.field_146292_n.get(0)).setAccessRestriction(mode);
        }
    }

    @Override
    public void updateFluids(List<Fluid> fluidList) {
        for (int i = 0; i < this.fluidSlotList.size() && i < fluidList.size(); ++i) {
            this.fluidSlotList.get(i).setFluid(fluidList.get(i));
        }
    }
}

