/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.network.packet.part;

import appeng.api.config.AccessRestriction;
import appeng.api.config.RedstoneMode;
import com.the9grounds.aeadditions.gui.gas.GuiBusGasIO;
import com.the9grounds.aeadditions.gui.gas.GuiBusGasStorage;
import com.the9grounds.aeadditions.gui.gas.GuiGasEmitter;
import com.the9grounds.aeadditions.network.packet.IPacketHandlerClient;
import com.the9grounds.aeadditions.network.packet.IPacketHandlerServer;
import com.the9grounds.aeadditions.network.packet.Packet;
import com.the9grounds.aeadditions.network.packet.PacketBufferEC;
import com.the9grounds.aeadditions.network.packet.PacketId;
import com.the9grounds.aeadditions.part.PartECBase;
import com.the9grounds.aeadditions.part.gas.PartGasIO;
import com.the9grounds.aeadditions.part.gas.PartGasLevelEmitter;
import com.the9grounds.aeadditions.part.gas.PartGasStorage;
import com.the9grounds.aeadditions.util.GuiUtil;
import com.the9grounds.aeadditions.util.NetworkUtil;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketPartConfig
extends Packet {
    public static final String FLUID_EMITTER_TOGGLE = "FluidEmitter.Toggle";
    public static final String FLUID_EMITTER_AMOUNT = "FluidEmitter.Amount";
    public static final String FLUID_EMITTER_AMOUNT_CHANGE = "FluidEmitter.Amount.Change";
    public static final String FLUID_EMITTER_MODE = "FluidEmitter.Mode";
    public static final String FLUID_IO_REDSTONE = "FluidIO.Redstone";
    public static final String FLUID_IO_REDSTONE_LOOP = "FluidIO.Redstone.Loop";
    public static final String FLUID_IO_REDSTONE_MODE = "FluidIO.Redstone.Mode";
    public static final String FLUID_IO_INFO = "FluidIO.Info";
    public static final String FLUID_IO_FILTER = "FluidIO.Filter";
    public static final String FLUID_STORAGE_INFO = "FluidStorage.Info";
    public static final String FLUID_STORAGE_ACCESS = "FluidStorage.Access";
    public static final String FLUID_PLANE_FORMATION_INFO = "FluidPlaneFormation.Info";
    private PartECBase part;
    private String name;
    private String value;

    public PacketPartConfig(PartECBase part, String name) {
        this.part = part;
        this.name = name;
        this.value = "";
    }

    public PacketPartConfig(PartECBase part, String name, String value) {
        this.part = part;
        this.name = name;
        this.value = value;
    }

    @Override
    protected void writeData(PacketBufferEC data) throws IOException {
        data.writePart(this.part);
        data.func_180714_a(this.name);
        data.func_180714_a(this.value);
    }

    @Override
    public PacketId getPacketId() {
        return PacketId.PART_CONFIG;
    }

    public static class HandlerServer
    implements IPacketHandlerServer {
        @Override
        public void onPacketData(PacketBufferEC data, EntityPlayerMP player) throws IOException {
            PartECBase part = (PartECBase)data.readPart(player.field_70170_p);
            String name = data.readString();
            String value = data.readString();
            if (name.equals(PacketPartConfig.FLUID_EMITTER_TOGGLE) && part instanceof PartGasLevelEmitter) {
                boolean toggle = Boolean.valueOf(value);
                if (toggle) {
                    ((PartGasLevelEmitter)part).toggleMode((EntityPlayer)player);
                } else {
                    ((PartGasLevelEmitter)part).syncClientGui((EntityPlayer)player);
                }
            } else if (name.equals(PacketPartConfig.FLUID_EMITTER_AMOUNT_CHANGE) && part instanceof PartGasLevelEmitter) {
                long amount = Long.valueOf(value);
                ((PartGasLevelEmitter)part).changeWantedAmount((int)amount, (EntityPlayer)player);
            } else if (name.equals(PacketPartConfig.FLUID_EMITTER_AMOUNT) && part instanceof PartGasLevelEmitter) {
                long amount = Long.valueOf(value);
                ((PartGasLevelEmitter)part).setWantedAmount(amount, (EntityPlayer)player);
            } else if (name.equals(PacketPartConfig.FLUID_IO_INFO) && part instanceof PartGasIO) {
                ((PartGasIO)part).sendInformation((EntityPlayer)player);
            } else if (name.equals(PacketPartConfig.FLUID_IO_REDSTONE_LOOP) && part instanceof PartGasIO) {
                ((PartGasIO)part).loopRedstoneMode((EntityPlayer)player);
            } else if (name.equals(PacketPartConfig.FLUID_STORAGE_ACCESS) && part instanceof PartGasStorage) {
                AccessRestriction access = AccessRestriction.valueOf((String)value);
                if (access == null) {
                    return;
                }
                ((PartGasStorage)part).updateAccess(access);
                NetworkUtil.sendToPlayer(new PacketPartConfig(part, PacketPartConfig.FLUID_STORAGE_ACCESS, value), (EntityPlayer)player);
            } else if (name.equals(PacketPartConfig.FLUID_STORAGE_INFO) && part instanceof PartGasStorage) {
                ((PartGasStorage)part).sendInformation((EntityPlayer)player);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class HandlerClient
    implements IPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferEC data, EntityPlayer player) throws IOException {
            PartECBase part = (PartECBase)data.readPart(player.field_70170_p);
            String name = data.readString();
            String value = data.readString();
            if (name.equals(PacketPartConfig.FLUID_EMITTER_AMOUNT) && part instanceof PartGasLevelEmitter) {
                long amount = Long.valueOf(value);
                GuiGasEmitter gui = GuiUtil.getGui(GuiGasEmitter.class);
                if (gui == null) {
                    return;
                }
                gui.setAmountField(amount);
            } else if (name.equals(PacketPartConfig.FLUID_EMITTER_MODE) && part instanceof PartGasLevelEmitter) {
                RedstoneMode redstoneMode = RedstoneMode.valueOf((String)value);
                GuiGasEmitter gui = GuiUtil.getGui(GuiGasEmitter.class);
                if (gui == null) {
                    return;
                }
                gui.setRedstoneMode(redstoneMode);
            } else if (name.equals(PacketPartConfig.FLUID_IO_REDSTONE) && part instanceof PartGasIO) {
                boolean redstoneControlled = Boolean.valueOf(value);
                GuiBusGasIO gui = GuiUtil.getGui(GuiBusGasIO.class);
                if (gui == null) {
                    return;
                }
                gui.setRedstoneControlled(redstoneControlled);
            } else if (name.equals(PacketPartConfig.FLUID_IO_FILTER) && part instanceof PartGasIO) {
                byte filterSize = Byte.valueOf(value);
                GuiBusGasIO gui = GuiUtil.getGui(GuiBusGasIO.class);
                if (gui == null) {
                    return;
                }
                gui.changeConfig(filterSize);
            } else if (name.equals(PacketPartConfig.FLUID_IO_REDSTONE_MODE) && part instanceof PartGasIO) {
                RedstoneMode redstoneMode = RedstoneMode.valueOf((String)value);
                GuiBusGasIO gui = GuiUtil.getGui(GuiBusGasIO.class);
                if (gui == null) {
                    return;
                }
                gui.updateRedstoneMode(redstoneMode);
            } else if (name.equals(PacketPartConfig.FLUID_STORAGE_ACCESS)) {
                AccessRestriction access = AccessRestriction.valueOf((String)value);
                GuiBusGasStorage gui = GuiUtil.getGui(GuiBusGasStorage.class);
                if (gui == null || access == null) {
                    return;
                }
                gui.updateAccessRestriction(access);
            }
        }
    }
}

