/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import com.google.common.collect.BiMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.Quark;

public final class OverrideRegistryHandler {
    public static void crackFinalField(Field field) throws NoSuchFieldException, IllegalAccessException {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
    }

    private static Level revokeLog() {
        Level prior = FMLLog.log.getLevel();
        if (FMLLog.log instanceof Logger) {
            ((Logger)FMLLog.log).setLevel(Level.OFF);
        }
        return prior;
    }

    private static void restoreLog(Level level) {
        if (FMLLog.log instanceof Logger) {
            ((Logger)FMLLog.log).setLevel(level);
        }
    }

    public static void registerBlock(Block block, String baseName) {
        OverrideRegistryHandler.register(block, Blocks.class, baseName);
    }

    public static void registerItem(Item item, String baseName) {
        OverrideRegistryHandler.register(item, Items.class, baseName);
    }

    public static void registerBiome(Biome item, String baseName) {
        OverrideRegistryHandler.register(item, Biomes.class, baseName);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(T obj, Class<?> registryType, String baseName) {
        Level revoked = OverrideRegistryHandler.revokeLog();
        ResourceLocation regName = new ResourceLocation("minecraft", baseName);
        obj.setRegistryName(regName);
        OverrideRegistryHandler.restoreLog(revoked);
        ProxyRegistry.register(obj);
        for (Field declared : registryType.getDeclaredFields()) {
            if (!Modifier.isStatic(declared.getModifiers()) || !declared.getType().isAssignableFrom(obj.getClass())) continue;
            try {
                BiMap itemMap;
                IForgeRegistryEntry.Impl fieldVal = (IForgeRegistryEntry.Impl)declared.get(null);
                if (!regName.equals((Object)fieldVal.getRegistryName())) continue;
                if (obj instanceof Block && fieldVal instanceof Block) {
                    itemMap = GameData.getBlockItemMap();
                    itemMap.forcePut((Object)((Block)obj), itemMap.get((Object)fieldVal));
                } else if (obj instanceof ItemBlock) {
                    itemMap = GameData.getBlockItemMap();
                    itemMap.forcePut((Object)((ItemBlock)obj).func_179223_d(), (Object)((Item)obj));
                }
                OverrideRegistryHandler.crackFinalField(declared);
                declared.set(null, obj);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                Quark.LOG.warn("Was unable to replace registry entry for " + regName + ", may cause issues", (Throwable)e);
            }
        }
    }
}

