/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.building.feature;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import vazkii.arl.block.BlockMod;
import vazkii.arl.block.BlockModSlab;
import vazkii.arl.block.BlockModStairs;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.handler.ModIntegrationHandler;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.GlobalConfig;
import vazkii.quark.building.block.BlockWorldStoneBricks;
import vazkii.quark.building.block.BlockWorldStoneCarved;
import vazkii.quark.building.block.slab.BlockVanillaSlab;
import vazkii.quark.building.block.stairs.BlockVanillaStairs;
import vazkii.quark.building.feature.VanillaWalls;
import vazkii.quark.world.feature.Basalt;
import vazkii.quark.world.feature.RevampStoneGen;

public class WorldStoneBricks
extends Feature {
    public static BlockMod world_stone_bricks;
    public static BlockMod world_stone_chiseled;
    public static final BlockModSlab[] slabs;
    public static boolean enableStairsAndSlabs;
    public static boolean enableWalls;
    private Queue<Runnable> deferedInit = new ArrayDeque<Runnable>();

    @Override
    public void setupConfig() {
        enableStairsAndSlabs = this.loadPropBool("Enable stairs and slabs", "", true) && GlobalConfig.enableVariants;
        enableWalls = this.loadPropBool("Enable walls", "", true) && GlobalConfig.enableVariants;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        world_stone_bricks = new BlockWorldStoneBricks();
        world_stone_chiseled = new BlockWorldStoneCarved();
        if (enableStairsAndSlabs) {
            for (BlockWorldStoneBricks.Variants variant : BlockWorldStoneBricks.Variants.values()) {
                if (!variant.isEnabled()) continue;
                IBlockState state = world_stone_bricks.func_176223_P().func_177226_a(world_stone_bricks.getVariantProp(), (Comparable)((Object)variant));
                BlockModStairs.initStairs((Block)world_stone_bricks, (int)variant.ordinal(), (BlockStairs)new BlockVanillaStairs(variant.func_176610_l() + "_stairs", state));
                WorldStoneBricks.slabs[variant.ordinal()] = BlockVanillaSlab.initSlab((Block)world_stone_bricks, variant.ordinal(), state, variant.func_176610_l() + "_slab");
            }
        }
        if (enableWalls) {
            for (BlockWorldStoneBricks.Variants variant : BlockWorldStoneBricks.Variants.values()) {
                if (!variant.isEnabled()) continue;
                world_stone_bricks.func_176223_P().func_177226_a(world_stone_bricks.getVariantProp(), (Comparable)((Object)variant));
                String name = variant.func_176610_l();
                VanillaWalls.add(name, (Block)world_stone_bricks, variant.ordinal(), true);
            }
        }
    }

    @Override
    public void postPreInit() {
        for (int i = 0; i < 3; ++i) {
            this.addRecipes(BlockWorldStoneBricks.Variants.values()[i], ProxyRegistry.newStack((Block)Blocks.field_150348_b, (int)1, (int)(i * 2 + 2)));
        }
        this.addRecipes(BlockWorldStoneBricks.Variants.STONE_BASALT_BRICKS, ProxyRegistry.newStack((Block)Basalt.basalt, (int)1, (int)1));
        this.addRecipes(BlockWorldStoneBricks.Variants.STONE_MARBLE_BRICKS, ProxyRegistry.newStack((Block)RevampStoneGen.marble, (int)1, (int)1));
        this.addRecipes(BlockWorldStoneBricks.Variants.STONE_LIMESTONE_BRICKS, ProxyRegistry.newStack((Block)RevampStoneGen.limestone, (int)1, (int)1));
        this.addRecipes(BlockWorldStoneBricks.Variants.STONE_JASPER_BRICKS, ProxyRegistry.newStack((Block)RevampStoneGen.jasper, (int)1, (int)1));
        this.addRecipes(BlockWorldStoneBricks.Variants.STONE_SLATE_BRICKS, ProxyRegistry.newStack((Block)RevampStoneGen.slate, (int)1, (int)1));
    }

    private void addRecipes(BlockWorldStoneBricks.Variants variant, ItemStack baseStack) {
        if (!variant.isEnabled()) {
            return;
        }
        int meta = variant.ordinal();
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_bricks, (int)4, (int)meta), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), baseStack});
        if (enableStairsAndSlabs) {
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_chiseled, (int)1, (int)meta), (Object[])new Object[]{"S", "S", Character.valueOf('S'), ProxyRegistry.newStack((Block)slabs[meta])});
        } else {
            RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)world_stone_chiseled, (int)8, (int)meta), (Object[])new Object[]{"SSS", "S S", "SSS", Character.valueOf('S'), ProxyRegistry.newStack((Block)world_stone_bricks, (int)1, (int)3)});
        }
        this.deferedInit.add(() -> ModIntegrationHandler.registerChiselVariant(variant.blockName, new ItemStack((Block)world_stone_bricks, 1, meta)));
    }

    @Override
    public void init() {
        while (!this.deferedInit.isEmpty()) {
            this.deferedInit.poll().run();
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    static {
        slabs = new BlockVanillaSlab[BlockWorldStoneBricks.Variants.values().length];
    }
}

