/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.endergen;

import java.util.List;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.tileentity.LogicTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftools.TickOrderHandler;
import mcjty.rftools.blocks.endergen.EnderMonitorMode;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnderMonitorTileEntity
extends LogicTileEntity
implements ITickable,
TickOrderHandler.ICheckStateServer {
    public static final String CMD_MODE = "endermonitor.setMode";
    private EnderMonitorMode mode = EnderMonitorMode.MODE_LOSTPEARL;
    private boolean needpulse = false;

    public EnderMonitorMode getMode() {
        return this.mode;
    }

    public void setMode(EnderMonitorMode mode) {
        this.mode = mode;
        this.markDirtyClient();
    }

    public void fireFromEndergenic(EnderMonitorMode mode) {
        if (this.mode != mode) {
            return;
        }
        this.needpulse = true;
        this.markDirtyQuick();
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            TickOrderHandler.queueEnderMonitor(this);
        }
    }

    @Override
    public void checkStateServer() {
        int newout = 0;
        if (this.needpulse) {
            this.markDirtyQuick();
            newout = 15;
            this.needpulse = false;
        }
        this.setRedstoneState(newout);
    }

    @Override
    public int getDimension() {
        return this.field_145850_b.field_73011_w.getDimension();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.powerOutput = tagCompound.func_74767_n("rs") ? 15 : 0;
        this.needpulse = tagCompound.func_74767_n("needPulse");
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        int m = tagCompound.func_74762_e("mode");
        this.mode = EnderMonitorMode.values()[m];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("rs", this.powerOutput > 0);
        tagCompound.func_74757_a("needPulse", this.needpulse);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("mode", this.mode.ordinal());
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_MODE.equals(command)) {
            String m = (String)params.get(ChoiceLabel.PARAM_CHOICE);
            this.setMode(EnderMonitorMode.getMode(m));
            return true;
        }
        return false;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        EnderMonitorMode m = this.getMode();
        probeInfo.text(TextFormatting.GREEN + "Mode: " + m.getDescription());
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
        EnderMonitorMode m = this.getMode();
        currenttip.add(TextFormatting.GREEN + "Mode: " + m.getDescription());
    }
}

