/*
 * Decompiled with CFR 0.152.
 */
package omtteam.omlib.network.messages;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import omtteam.omlib.api.render.camo.ICamoSupport;
import omtteam.omlib.proxy.ClientProxy;
import omtteam.omlib.tileentity.TileEntityOwnedBlock;

public class MessageCamoSettings
implements IMessage {
    private int x;
    private int y;
    private int z;
    private int lightValue;
    private int lightOpacity;
    private int camoBlockMeta;
    private String camoBlockRegName;

    public MessageCamoSettings() {
    }

    public MessageCamoSettings(ICamoSupport block) {
        TileEntityOwnedBlock ownedBlock = block.getOwnedBlock();
        this.x = ownedBlock.func_174877_v().func_177958_n();
        this.y = ownedBlock.func_174877_v().func_177956_o();
        this.z = ownedBlock.func_174877_v().func_177952_p();
        this.lightValue = block.getCamoSettings().getLightValue();
        this.lightOpacity = block.getCamoSettings().getLightOpacity();
        this.camoBlockRegName = Objects.requireNonNull(block.getCamoState().func_177230_c().getRegistryName()).toString();
        this.camoBlockMeta = block.getCamoState().func_177230_c().func_176201_c(block.getCamoState());
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.lightValue = buf.readInt();
        this.lightOpacity = buf.readInt();
        this.camoBlockRegName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.camoBlockMeta = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.lightValue);
        buf.writeInt(this.lightOpacity);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.camoBlockRegName);
        buf.writeInt(this.camoBlockMeta);
    }

    public static class MessageHandlerCamoSettings
    implements IMessageHandler<MessageCamoSettings, IMessage> {
        public IMessage onMessage(MessageCamoSettings messageIn, MessageContext ctx) {
            MessageCamoSettings message = messageIn;
            Minecraft.func_71410_x().func_152344_a(() -> {
                TileEntity tileEntity = ClientProxy.getWorld(FMLClientHandler.instance().getClient()).func_175625_s(new BlockPos(message.x, message.y, message.z));
                if (tileEntity instanceof ICamoSupport) {
                    ICamoSupport base = (ICamoSupport)tileEntity;
                    base.getCamoSettings().setLightValue(message.lightValue);
                    base.getCamoSettings().setLightOpacity(message.lightOpacity);
                    base.setCamoState(((Block)Objects.requireNonNull(ForgeRegistries.BLOCKS.getValue(new ResourceLocation(message.camoBlockRegName)))).func_176203_a(message.camoBlockMeta));
                    ((ICamoSupport)tileEntity).getOwnedBlock().func_70296_d();
                    base.getOwnedBlock().func_145831_w().func_175664_x(base.getOwnedBlock().func_174877_v());
                }
            });
            return null;
        }
    }
}

