/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetEmitRedstone;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IRedstoneEmissionWidget;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetString;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.math.NumberUtils;

public class ProgWidgetEmitRedstone
extends ProgWidget
implements IRedstoneEmissionWidget,
ISidedWidget {
    private boolean[] accessingSides = new boolean[]{true, true, true, true, true, true};

    @Override
    public int getEmittingRedstone() {
        if (this.getConnectedParameters()[0] != null) {
            return NumberUtils.toInt((String)((ProgWidgetString)this.getConnectedParameters()[0]).string);
        }
        return 0;
    }

    @Override
    public void setSides(boolean[] sides) {
        this.accessingSides = sides;
    }

    @Override
    public boolean[] getSides() {
        return this.accessingSides;
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        boolean sideActive = false;
        for (boolean bool : this.accessingSides) {
            sideActive |= bool;
        }
        if (!sideActive) {
            curInfo.add("gui.progWidget.general.error.noSideActive");
        }
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        curTooltip.add("Affecting sides:");
        curTooltip.add(this.getExtraStringInfo());
    }

    @Override
    public String getExtraStringInfo() {
        boolean allSides = true;
        boolean noSides = true;
        for (boolean bool : this.accessingSides) {
            if (bool) {
                noSides = false;
                continue;
            }
            allSides = false;
        }
        if (allSides) {
            return "All sides";
        }
        if (noSides) {
            return "No Sides";
        }
        StringBuilder tipBuilder = new StringBuilder();
        block9: for (int i = 0; i < 6; ++i) {
            if (!this.accessingSides[i]) continue;
            switch (EnumFacing.func_82600_a((int)i)) {
                case UP: {
                    tipBuilder.append("top, ");
                    continue block9;
                }
                case DOWN: {
                    tipBuilder.append("bottom, ");
                    continue block9;
                }
                case NORTH: {
                    tipBuilder.append("north, ");
                    continue block9;
                }
                case SOUTH: {
                    tipBuilder.append("south, ");
                    continue block9;
                }
                case EAST: {
                    tipBuilder.append("east, ");
                    continue block9;
                }
                case WEST: {
                    tipBuilder.append("west, ");
                }
            }
        }
        String tip = tipBuilder.toString();
        return tip.substring(0, tip.length() - 2);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        for (int i = 0; i < 6; ++i) {
            tag.func_74757_a(EnumFacing.func_82600_a((int)i).name(), this.accessingSides[i]);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        for (int i = 0; i < 6; ++i) {
            this.accessingSides[i] = tag.func_74767_n(EnumFacing.func_82600_a((int)i).name());
        }
    }

    @Override
    public boolean hasStepInput() {
        return true;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return null;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetString.class};
    }

    @Override
    protected boolean hasBlacklist() {
        return false;
    }

    @Override
    public String getWidgetString() {
        return "emitRedstone";
    }

    @Override
    public int getCraftingColorIndex() {
        return 1;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_EMIT_REDSTONE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetEmitRedstone(this, guiProgrammer);
    }

    @Override
    public EntityAIBase getWidgetAI(IDroneBase drone, IProgWidget widget) {
        return new DroneAIEmitRedstone(drone, widget);
    }

    private static class DroneAIEmitRedstone
    extends EntityAIBase {
        private final IProgWidget widget;
        private final IDroneBase drone;

        public DroneAIEmitRedstone(IDroneBase drone, IProgWidget widget) {
            this.widget = widget;
            this.drone = drone;
        }

        public boolean func_75250_a() {
            boolean[] sides = ((ISidedWidget)((Object)this.widget)).getSides();
            for (int i = 0; i < 6; ++i) {
                if (!sides[i]) continue;
                this.drone.setEmittingRedstone(EnumFacing.func_82600_a((int)i), ((IRedstoneEmissionWidget)((Object)this.widget)).getEmittingRedstone());
            }
            return false;
        }
    }
}

