/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.itemconfig;

import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.IntegerConfigField;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AOEConfigField
extends IntegerConfigField {
    public AOEConfigField(String name, int value, int minValue, int maxValue, String description) {
        super(name, value, minValue, maxValue, description, IItemConfigField.EnumControlType.SELECTIONS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getReadableValue() {
        return 1 + this.value * 2 + "x" + (1 + this.value * 2);
    }

    @Override
    public Map<Integer, String> getValues() {
        LinkedHashMap<Integer, String> values = new LinkedHashMap<Integer, String>();
        for (int i = this.minValue; i <= this.maxValue; ++i) {
            String aoe = 1 + i * 2 + "x" + (1 + i * 2);
            values.put(i, aoe);
        }
        return values;
    }

    @Override
    public void handleButton(IItemConfigField.EnumButton button, int data) {
        if (button == IItemConfigField.EnumButton.SELECTION) {
            this.value = data;
            if (this.value > this.maxValue) {
                this.value = this.maxValue;
            } else if (this.value < this.minValue) {
                this.value = this.minValue;
            }
        }
    }
}

