/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.crossmod.GalacticraftHelper;
import com.zuxelus.energycontrol.hooks.GalacticraftHooks;
import com.zuxelus.energycontrol.items.cards.ItemCardGalacticraft;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.kits.ItemKitGalacticraft;
import com.zuxelus.energycontrol.items.kits.ItemKitMain;
import com.zuxelus.energycontrol.tileentities.TileEntityAFSU;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.power.IEnergyHandlerGC;
import micdoodle8.mods.galacticraft.core.blocks.BlockOxygenDetector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityCoalGenerator;
import micdoodle8.mods.galacticraft.core.tile.TileEntityEnergyStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenCollector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDetector;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenDistributor;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenStorageModule;
import micdoodle8.mods.galacticraft.core.tile.TileEntityRefinery;
import micdoodle8.mods.galacticraft.core.tile.TileEntitySolar;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemAtmosphericValve;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityElectrolyzer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import micdoodle8.mods.galacticraft.planets.venus.tile.TileEntitySolarArrayController;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class CrossGalacticraft
extends CrossModBase {
    @Override
    public NBTTagCompound getEnergyData(TileEntity te) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("euType", "gJ");
        if (te instanceof TileEntityAFSU) {
            return null;
        }
        if (te instanceof IEnergyHandlerGC) {
            IEnergyHandlerGC storage = (IEnergyHandlerGC)te;
            tag.func_74780_a("energy", (double)storage.getEnergyStoredGC(null));
            tag.func_74780_a("capacity", (double)storage.getMaxEnergyStoredGC(null));
            return tag;
        }
        return null;
    }

    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        if (te instanceof IFluidHandlerWrapper) {
            FluidTankInfo[] info = ((IFluidHandlerWrapper)te).getTankInfo(null);
            ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
            for (FluidTankInfo fluidTankInfo : info) {
                result.add(new FluidInfo(fluidTankInfo.fluid, fluidTankInfo.capacity));
            }
            if (result.size() > 0) {
                return result;
            }
            for (FluidTankInfo fluidTankInfo : EnumFacing.field_82609_l) {
                for (FluidTankInfo tank : info = ((IFluidHandlerWrapper)te).getTankInfo((EnumFacing)fluidTankInfo)) {
                    result.add(new FluidInfo(tank.fluid, tank.capacity));
                }
            }
            return result;
        }
        return null;
    }

    @Override
    public NBTTagCompound getCardData(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        NBTTagCompound tag = new NBTTagCompound();
        if (te instanceof TileEntityOxygenCollector) {
            tag.func_74778_a("status", GalacticraftHelper.getStatus((TileEntityOxygenCollector)te));
            tag.func_74780_a("oxygenPerTick", (double)(((TileEntityOxygenCollector)te).lastOxygenCollected * 20.0f));
            tag.func_74768_a("oxygenStored", ((TileEntityOxygenCollector)te).getOxygenStored());
            tag.func_74768_a("oxygenCapacity", ((TileEntityOxygenCollector)te).getMaxOxygenStored());
            tag.func_74780_a("energy", (double)((TileEntityOxygenCollector)te).storage.getEnergyStoredGC());
            tag.func_74780_a("capacity", (double)((TileEntityOxygenCollector)te).storage.getCapacityGC());
            return tag;
        }
        if (te instanceof TileEntityOxygenSealer) {
            tag.func_74778_a("status", GalacticraftHelper.getStatus((TileEntityOxygenSealer)te));
            tag.func_74780_a("oxygenUse", (double)(((TileEntityOxygenSealer)te).oxygenPerTick * 20));
            tag.func_74778_a("thermalStatus", GalacticraftHelper.getThermalStatus((TileEntityOxygenSealer)te));
            tag.func_74768_a("oxygenStored", ((TileEntityOxygenSealer)te).getOxygenStored());
            tag.func_74768_a("oxygenCapacity", ((TileEntityOxygenSealer)te).getMaxOxygenStored());
            tag.func_74780_a("energy", (double)((TileEntityOxygenSealer)te).storage.getEnergyStoredGC());
            tag.func_74780_a("capacity", (double)((TileEntityOxygenSealer)te).storage.getCapacityGC());
            return tag;
        }
        if (te instanceof TileEntityOxygenDetector) {
            IBlockState state = world.func_180495_p(pos);
            if (state != null && state.func_177230_c() instanceof BlockOxygenDetector) {
                tag.func_74757_a("active", ((Boolean)state.func_177229_b((IProperty)BlockOxygenDetector.ACTIVE)).booleanValue());
                tag.func_74778_a("oxygenDetected", (Boolean)state.func_177229_b((IProperty)BlockOxygenDetector.ACTIVE) != false ? TextFormatting.GREEN + I18n.func_74838_a((String)"msg.ec.InfoPanelTrue") : TextFormatting.RED + I18n.func_74838_a((String)"msg.ec.InfoPanelFalse"));
                return tag;
            }
            return null;
        }
        if (te instanceof TileEntityRefinery) {
            TileEntityRefinery ref = (TileEntityRefinery)te;
            tag.func_74778_a("status", GalacticraftHelper.getStatus(ref));
            tag.func_74780_a("energy", (double)ref.storage.getEnergyStoredGC());
            tag.func_74780_a("capacity", (double)ref.storage.getCapacityGC());
            tag.func_74778_a("oilTank", String.format("%s / %s mB", ref.oilTank.getFluidAmount(), ref.oilTank.getCapacity()));
            tag.func_74778_a("fuelTank", String.format("%s / %s mB", ref.fuelTank.getFluidAmount(), ref.fuelTank.getCapacity()));
            return tag;
        }
        if (te instanceof TileEntityElectrolyzer) {
            TileEntityElectrolyzer el = (TileEntityElectrolyzer)te;
            tag.func_74778_a("status", GalacticraftHelper.getStatus(el));
            tag.func_74780_a("energy", (double)el.storage.getEnergyStoredGC());
            tag.func_74780_a("capacity", (double)el.storage.getCapacityGC());
            tag.func_74778_a("waterTank", String.format("%s / %s mB", el.waterTank.getFluidAmount(), el.waterTank.getCapacity()));
            tag.func_74778_a("oxygenTank", String.format("%s / %s mB", el.liquidTank.getFluidAmount(), el.liquidTank.getCapacity()));
            tag.func_74778_a("hydrogenTank", String.format("%s / %s mB", el.liquidTank2.getFluidAmount(), el.liquidTank2.getCapacity()));
            return tag;
        }
        if (te instanceof TileEntityMethaneSynthesizer) {
            TileEntityMethaneSynthesizer meth = (TileEntityMethaneSynthesizer)te;
            tag.func_74778_a("status", GalacticraftHelper.getStatus(meth));
            tag.func_74780_a("energy", (double)meth.storage.getEnergyStoredGC());
            tag.func_74780_a("capacity", (double)meth.storage.getCapacityGC());
            tag.func_74778_a("methaneTank", String.format("%s / %s mB", meth.liquidTank.getFluidAmount(), meth.liquidTank.getCapacity()));
            tag.func_74778_a("hydrogenTank", String.format("%s / %s mB", meth.gasTank.getFluidAmount(), meth.gasTank.getCapacity()));
            tag.func_74778_a("dioxideTank", String.format("%s / %s mB", meth.gasTank2.getFluidAmount(), meth.gasTank2.getCapacity()));
            int counter = 0;
            ItemStack stack = (ItemStack)meth.inventory.get(2);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemAtmosphericValve) {
                counter = stack.func_190916_E();
            }
            tag.func_74768_a("valve", counter);
            counter = 0;
            stack = (ItemStack)meth.inventory.get(3);
            if (!stack.func_190926_b()) {
                counter = stack.func_190916_E();
            }
            tag.func_74768_a("carbon", counter);
            return tag;
        }
        if (te instanceof TileEntityGasLiquefier) {
            TileEntityGasLiquefier gas = (TileEntityGasLiquefier)te;
            tag.func_74778_a("status", GalacticraftHelper.getStatus(gas));
            tag.func_74780_a("energy", (double)gas.storage.getEnergyStoredGC());
            tag.func_74780_a("capacity", (double)gas.storage.getCapacityGC());
            tag.func_74778_a("gasTank", String.format("%s / %s mB", gas.gasTank.getFluidAmount(), gas.gasTank.getCapacity()));
            FluidStack liquid = gas.gasTank.getFluid();
            if (liquid != null && liquid.getFluid() != null) {
                tag.func_74778_a("gasTankName", liquid.getFluid().getUnlocalizedName());
            } else {
                tag.func_74778_a("gasTankName", "");
            }
            tag.func_74778_a("liquidTank", String.format("%s / %s mB", gas.liquidTank.getFluidAmount(), gas.liquidTank.getCapacity()));
            liquid = gas.liquidTank.getFluid();
            if (liquid != null && liquid.getFluid() != null) {
                tag.func_74778_a("liquidTankName", liquid.getFluid().getUnlocalizedName());
            } else {
                tag.func_74778_a("liquidTankName", "");
            }
            tag.func_74778_a("liquidTank2", String.format("%s / %s mB", gas.liquidTank2.getFluidAmount(), gas.liquidTank2.getCapacity()));
            liquid = gas.liquidTank2.getFluid();
            if (liquid != null && liquid.getFluid() != null) {
                tag.func_74778_a("liquidTank2Name", liquid.getFluid().getUnlocalizedName());
            } else {
                tag.func_74778_a("liquidTank2Name", "");
            }
            int counter = 0;
            ItemStack stack = (ItemStack)gas.inventory.get(1);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemAtmosphericValve) {
                counter = stack.func_190916_E();
            }
            tag.func_74768_a("valve", counter);
            return tag;
        }
        if (te instanceof TileEntityOxygenStorageModule) {
            tag.func_74768_a("oxygenStored", ((TileEntityOxygenStorageModule)te).getOxygenStored());
            tag.func_74768_a("oxygenCapacity", ((TileEntityOxygenStorageModule)te).getMaxOxygenStored());
            return tag;
        }
        if (te instanceof TileEntityEnergyStorageModule) {
            tag.func_74780_a("energy", (double)((TileEntityEnergyStorageModule)te).storage.getEnergyStoredGC());
            tag.func_74780_a("capacity", (double)((TileEntityEnergyStorageModule)te).storage.getCapacityGC());
            ArrayList values = this.getHookValues(te);
            if (values != null) {
                tag.func_74780_a("diff", ((Double)values.get(0) - (Double)values.get(20)) / 20.0);
            }
            return tag;
        }
        if (te instanceof TileEntitySolar) {
            tag.func_74778_a("status", GalacticraftHelper.getStatus((TileEntitySolar)te));
            tag.func_74780_a("energy", (double)((TileEntitySolar)te).storage.getEnergyStoredGC());
            tag.func_74780_a("capacity", (double)((TileEntitySolar)te).storage.getCapacityGC());
            tag.func_74768_a("output", ((TileEntitySolar)te).generateWatts);
            tag.func_74780_a("boost", (double)Math.round((((TileEntitySolar)te).getSolarBoost() - 1.0f) * 1000.0f) / 10.0);
            tag.func_74780_a("sunVisible", (double)Math.round((float)((TileEntitySolar)te).solarStrength / 9.0f * 1000.0f) / 10.0);
            return tag;
        }
        if (te instanceof TileEntityLaunchController) {
            tag.func_74778_a("status", GalacticraftHelper.getStatus((TileEntityLaunchController)te));
            tag.func_74780_a("energy", (double)((TileEntityLaunchController)te).storage.getEnergyStoredGC());
            tag.func_74780_a("capacity", (double)((TileEntityLaunchController)te).storage.getCapacityGC());
            tag.func_74768_a("frequency", ((TileEntityLaunchController)te).frequency);
            tag.func_74768_a("target", ((TileEntityLaunchController)te).destFrequency);
            return tag;
        }
        if (te instanceof TileEntitySolarArrayController) {
            tag.func_74778_a("status", GalacticraftHelper.getStatus((TileEntitySolarArrayController)te));
            tag.func_74780_a("energy", (double)((TileEntitySolarArrayController)te).storage.getEnergyStoredGC());
            tag.func_74780_a("capacity", (double)((TileEntitySolarArrayController)te).storage.getCapacityGC());
            tag.func_74768_a("output", ((TileEntitySolarArrayController)te).generateWatts);
            tag.func_74780_a("boost", (double)Math.round((((TileEntitySolarArrayController)te).getSolarBoost() - 1.0f) * 1000.0f) / 10.0);
            return tag;
        }
        if (te instanceof TileEntityOxygenDistributor) {
            tag.func_74778_a("status", GalacticraftHelper.getStatus((TileEntityOxygenDistributor)te));
            tag.func_74780_a("energy", (double)((TileEntityOxygenDistributor)te).storage.getEnergyStoredGC());
            tag.func_74780_a("capacity", (double)((TileEntityOxygenDistributor)te).storage.getCapacityGC());
            tag.func_74780_a("oxygenUse", (double)(((TileEntityOxygenDistributor)te).oxygenPerTick * 20));
            tag.func_74768_a("oxygenStored", ((TileEntityOxygenDistributor)te).getOxygenStored());
            tag.func_74768_a("oxygenCapacity", ((TileEntityOxygenDistributor)te).getMaxOxygenStored());
            return tag;
        }
        if (te instanceof TileEntityCoalGenerator) {
            tag.func_74780_a("output", ((TileEntityCoalGenerator)te).heatGJperTick > 30.0f ? (double)(((TileEntityCoalGenerator)te).heatGJperTick - 30.0f) : 0.0);
            return tag;
        }
        return null;
    }

    @Override
    public ArrayList getHookValues(TileEntity te) {
        ArrayList values = GalacticraftHooks.map.get(te);
        if (values == null) {
            GalacticraftHooks.map.put(te, null);
        }
        return values;
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        ItemKitMain.register(ItemKitGalacticraft::new);
        ItemCardMain.register(ItemCardGalacticraft::new);
    }
}

