/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class IngredientFactory
implements IIngredientFactory {
    public Ingredient parse(JsonContext context, JsonObject json) {
        return new IngredientNBT(IngredientFactory.getItemStack(json, context));
    }

    private static ItemStack getItemStack(JsonObject json, JsonContext context) {
        String itemName = context.appendModId(JsonUtils.func_151200_h((JsonObject)json, (String)"item"));
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        if (item.func_77614_k() && !json.has("data")) {
            throw new JsonParseException("Missing data for item '" + itemName + "'");
        }
        if (json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                NBTTagCompound nbt = element.isJsonObject() ? JsonToNBT.func_180713_a((String)CraftingHelper.GSON.toJson(element)) : JsonToNBT.func_180713_a((String)JsonUtils.func_151206_a((JsonElement)element, (String)"nbt"));
                NBTTagCompound nbt2 = nbt.func_74737_b();
                for (String name : nbt2.func_150296_c()) {
                    String text;
                    NBTBase tag = nbt2.func_74781_a(name);
                    if (tag.func_74732_a() != 8 || (text = nbt.func_74779_i(name)).length() <= 1 || !text.endsWith("b")) continue;
                    text = text.substring(0, text.length() - 1);
                    boolean isByte = true;
                    for (char ch : text.toCharArray()) {
                        isByte = isByte && Character.isDigit(ch);
                    }
                    if (!isByte) continue;
                    nbt.func_82580_o(name);
                    nbt.func_74774_a(name, Byte.parseByte(text));
                }
                NBTTagCompound tmp = new NBTTagCompound();
                if (nbt.func_74764_b("ForgeCaps")) {
                    tmp.func_74782_a("ForgeCaps", nbt.func_74781_a("ForgeCaps"));
                    nbt.func_82580_o("ForgeCaps");
                }
                tmp.func_74782_a("tag", (NBTBase)nbt);
                tmp.func_74778_a("id", itemName);
                tmp.func_74768_a("Count", JsonUtils.func_151208_a((JsonObject)json, (String)"count", (int)1));
                tmp.func_74768_a("Damage", JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0));
                return new ItemStack(tmp);
            }
            catch (NBTException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + (Object)((Object)e));
            }
        }
        return new ItemStack(item, JsonUtils.func_151208_a((JsonObject)json, (String)"count", (int)1), JsonUtils.func_151208_a((JsonObject)json, (String)"data", (int)0));
    }

    private static class IngredientNBT
    extends Ingredient {
        private final ItemStack stack;

        public IngredientNBT(ItemStack stack) {
            super(new ItemStack[]{stack});
            this.stack = stack;
        }

        public boolean apply(@Nullable ItemStack input) {
            if (input == null) {
                return false;
            }
            return this.stack.func_77973_b() == input.func_77973_b() && this.stack.func_77952_i() == input.func_77952_i() && ItemStack.areItemStackShareTagsEqual((ItemStack)this.stack, (ItemStack)input);
        }

        public boolean isSimple() {
            return false;
        }
    }
}

