/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.items.ItemUpgrade;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.tileentities.TileEntityInfoPanel;
import com.zuxelus.zlib.blocks.FacingBlockActive;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;

public class TileEntityAdvancedInfoPanel
extends TileEntityInfoPanel {
    public static final String NAME = "info_panel_advanced";
    private static final byte SLOT_CARD1 = 0;
    private static final byte SLOT_CARD2 = 1;
    private static final byte SLOT_CARD3 = 2;
    private static final byte SLOT_UPGRADE_RANGE = 3;
    public static final int POWER_REDSTONE = 0;
    public static final int POWER_INVERTED = 1;
    public static final int POWER_ON = 2;
    public static final int POWER_OFF = 3;
    public static final int OFFSET_THICKNESS = 100;
    public static final int OFFSET_ROTATE_HOR = 200;
    public static final int OFFSET_ROTATE_VERT = 300;
    public static final int DEFAULT_TEXT = -1;
    public static final int DEFAULT_BACKGROUND = -12171706;
    public byte powerMode;
    public byte thickness;
    public byte rotateHor;
    public byte rotateVert;

    public TileEntityAdvancedInfoPanel() {
        this.customName = "tile.info_panel_advanced.name";
        this.colorText = -1;
        this.colorBackground = -12171706;
        this.colored = true;
        this.thickness = (byte)16;
    }

    public byte getPowerMode() {
        return this.powerMode;
    }

    public void setPowerMode(byte mode) {
        this.powerMode = mode;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.updateBlockState(this.field_145850_b.func_180495_p(this.field_174879_c));
        }
    }

    public byte getNextPowerMode() {
        switch (this.powerMode) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    public void setValues(int i) {
        if (i >= 0 && i < 100) {
            switch (i) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.powerMode = (byte)i;
                }
            }
        } else if (i >= 100 && i < 200) {
            this.thickness = (byte)(i -= 100);
        } else if (i >= 200 && i < 300) {
            i -= 208;
            i = -(i * 7);
            this.rotateHor = (byte)i;
        } else if (i >= 300 && i < 400) {
            i -= 308;
            i = -(i * 7);
            this.rotateVert = (byte)i;
        }
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        int type = tag.func_74762_e("type");
        if (type < 10) {
            super.onServerMessageReceived(tag);
            return;
        }
        switch (type) {
            case 10: {
                this.setValues(tag.func_74762_e("value"));
                break;
            }
            case 11: {
                this.setPowerMode((byte)tag.func_74762_e("value"));
            }
        }
    }

    @Override
    protected void deserializeDisplaySettings(NBTTagCompound tag) {
        this.deserializeSlotSettings(tag, "dSettings1", 0);
        this.deserializeSlotSettings(tag, "dSettings2", 1);
        this.deserializeSlotSettings(tag, "dSettings3", 2);
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        if (tag.func_74764_b("powerMode")) {
            this.setPowerMode(tag.func_74771_c("powerMode"));
        }
        if (tag.func_74764_b("thickness")) {
            this.thickness = tag.func_74771_c("thickness");
        }
        if (tag.func_74764_b("rotateHor")) {
            this.rotateHor = tag.func_74771_c("rotateHor");
        }
        if (tag.func_74764_b("rotateVert")) {
            this.rotateVert = tag.func_74771_c("rotateVert");
        }
    }

    @Override
    protected void serializeDisplaySettings(NBTTagCompound tag) {
        tag.func_74782_a("dSettings1", (NBTBase)this.serializeSlotSettings(0));
        tag.func_74782_a("dSettings2", (NBTBase)this.serializeSlotSettings(1));
        tag.func_74782_a("dSettings3", (NBTBase)this.serializeSlotSettings(2));
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74774_a("powerMode", this.powerMode);
        tag.func_74774_a("thickness", this.thickness);
        tag.func_74774_a("rotateHor", this.rotateHor);
        tag.func_74774_a("rotateVert", this.rotateVert);
        return tag;
    }

    @Override
    public NonNullList<ItemStack> getCards() {
        NonNullList data = NonNullList.func_191196_a();
        data.add((Object)this.func_70301_a(0));
        data.add((Object)this.func_70301_a(1));
        data.add((Object)this.func_70301_a(2));
        return data;
    }

    @Override
    public boolean isColoredEval() {
        return true;
    }

    @Override
    public byte getSlotUpgradeRange() {
        return 3;
    }

    @Override
    public boolean isCardSlot(int slot) {
        return slot == 0 || slot == 1 || slot == 2;
    }

    @Override
    public int func_70302_i_() {
        return 4;
    }

    @Override
    public boolean isItemValid(int index, ItemStack stack) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                return ItemCardMain.isCard(stack);
            }
            case 3: {
                return stack.func_77973_b() instanceof ItemUpgrade && stack.func_77952_i() == 0;
            }
        }
        return false;
    }

    @Override
    public void updateBlockState(IBlockState state) {
        boolean flag = this.field_145850_b.func_175640_z(this.field_174879_c);
        switch (this.powerMode) {
            case 2: {
                flag = true;
                break;
            }
            case 3: {
                flag = false;
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                flag = !flag;
            }
        }
        this.powered = flag;
        if (flag == (Boolean)state.func_177229_b((IProperty)FacingBlockActive.ACTIVE)) {
            return;
        }
        if (flag) {
            this.field_145850_b.func_175684_a(this.field_174879_c, state.func_177230_c(), 4);
        } else {
            this.field_145850_b.func_180501_a(this.field_174879_c, state.func_177231_a((IProperty)FacingBlockActive.ACTIVE), 2);
            this.updateExtenders(true);
        }
    }

    @Override
    public boolean runTouchAction(ItemStack stack, BlockPos pos, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        ItemStack card = this.func_70301_a(0);
        this.runTouchAction(this, card, stack, 0, false);
        return true;
    }
}

