/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.EnergyControl;
import com.zuxelus.energycontrol.EnergyControlConfig;
import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.IHasBars;
import com.zuxelus.energycontrol.api.ITouchAction;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.blocks.HoloPanelExtender;
import com.zuxelus.energycontrol.blocks.InfoPanelExtender;
import com.zuxelus.energycontrol.items.ItemUpgrade;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.tileentities.IScreenPart;
import com.zuxelus.energycontrol.tileentities.Screen;
import com.zuxelus.energycontrol.utils.StringUtils;
import com.zuxelus.zlib.blocks.FacingBlockActive;
import com.zuxelus.zlib.containers.slots.ISlotItemFilter;
import com.zuxelus.zlib.tileentities.ITilePacketHandler;
import com.zuxelus.zlib.tileentities.TileEntityInventory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityInfoPanel
extends TileEntityInventory
implements ITickable,
ITilePacketHandler,
IScreenPart,
ISlotItemFilter {
    public static final String NAME = "info_panel";
    public static final int DISPLAY_DEFAULT = 0x7FFFFBFF;
    public static final int GREEN = -16724992;
    private static final byte SLOT_CARD = 0;
    private static final byte SLOT_UPGRADE_RANGE = 1;
    private static final byte SLOT_UPGRADE_COLOR = 2;
    private static final byte SLOT_UPGRADE_TOUCH = 3;
    private final Map<Integer, List<PanelString>> cardData = new HashMap<Integer, List<PanelString>>();
    protected final Map<Integer, Map<String, Integer>> displaySettings = new HashMap<Integer, Map<String, Integer>>(1);
    protected Screen screen;
    public NBTTagCompound screenData;
    public boolean init;
    protected int updateTicker;
    protected int dataTicker;
    protected int tickRate;
    public boolean showLabels;
    public int colorBackground;
    public int colorText;
    protected boolean colored;
    public boolean powered;

    public TileEntityInfoPanel() {
        super("tile.info_panel.name");
        this.displaySettings.put(0, new HashMap());
        this.tickRate = EnergyControlConfig.infoPanelRefreshPeriod;
        this.updateTicker = this.tickRate - 1;
        this.dataTicker = 4;
        this.showLabels = true;
        this.colorBackground = -16724992;
        this.colored = false;
    }

    private void initData() {
        this.init = true;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateBlockState(this.field_145850_b.func_180495_p(this.field_174879_c));
        if (this.screenData == null) {
            EnergyControl.instance.screenManager.registerInfoPanel(this);
        } else {
            this.screen = EnergyControl.instance.screenManager.loadScreen(this);
            if (this.screen != null) {
                this.screen.init(true, this.field_145850_b);
            }
        }
        this.notifyBlockUpdate();
    }

    @Override
    public void setFacing(int meta) {
        EnumFacing newFacing = EnumFacing.func_82600_a((int)meta);
        if (this.facing == newFacing) {
            return;
        }
        this.facing = newFacing;
        if (this.init) {
            EnergyControl.instance.screenManager.unregisterScreenPart(this);
            EnergyControl.instance.screenManager.registerInfoPanel(this);
        }
    }

    public boolean getShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean newShowLabels) {
        if (!this.field_145850_b.field_72995_K && this.showLabels != newShowLabels) {
            this.notifyBlockUpdate();
        }
        this.showLabels = newShowLabels;
    }

    public int getTickRate() {
        return this.tickRate;
    }

    public void setTickRate(int newValue) {
        if (!this.field_145850_b.field_72995_K && this.tickRate != newValue) {
            this.notifyBlockUpdate();
        }
        this.tickRate = newValue;
    }

    public boolean getColored() {
        return this.colored;
    }

    public void setColored(boolean newColored) {
        if (!this.field_145850_b.field_72995_K && this.colored != newColored) {
            this.notifyBlockUpdate();
        }
        this.colored = newColored;
    }

    public int getColorBackground() {
        return this.colorBackground;
    }

    public void setColorBackground(int c) {
        if (!this.field_145850_b.field_72995_K && this.colorBackground != c) {
            this.notifyBlockUpdate();
        }
        this.colorBackground = c;
    }

    public int getColorText() {
        return this.colorText;
    }

    public void setColorText(int c) {
        if (!this.field_145850_b.field_72995_K && this.colorText != c) {
            this.notifyBlockUpdate();
        }
        this.colorText = c;
    }

    public boolean getPowered() {
        return this.powered;
    }

    public void setPowered(boolean value) {
        this.powered = value;
    }

    public void setScreenData(NBTTagCompound nbtTagCompound) {
        this.screenData = nbtTagCompound;
        if (this.screen != null && this.field_145850_b.field_72995_K) {
            this.screen.destroy(true, this.field_145850_b);
        }
        if (this.screenData != null) {
            this.screen = EnergyControl.instance.screenManager.loadScreen(this);
            if (this.screen != null) {
                this.screen.init(true, this.field_145850_b);
            }
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("slot") || !tag.func_74764_b("value")) break;
                this.setDisplaySettings(tag.func_74762_e("slot"), tag.func_74762_e("value"));
                break;
            }
            case 3: {
                if (!tag.func_74764_b("value")) break;
                this.setShowLabels(tag.func_74762_e("value") == 1);
                break;
            }
            case 4: {
                ItemStack stack;
                if (tag.func_74764_b("slot") && tag.func_74764_b("title") && ItemCardMain.isCard(stack = this.func_70301_a(tag.func_74762_e("slot")))) {
                    new ItemCardReader(stack).setTitle(tag.func_74779_i("title"));
                    this.resetCardData();
                }
            }
            case 5: {
                if (!tag.func_74764_b("value")) break;
                this.setTickRate(tag.func_74762_e("value"));
                break;
            }
            case 6: {
                if (!tag.func_74764_b("value")) break;
                this.setColorBackground(tag.func_74762_e("value"));
                break;
            }
            case 7: {
                if (!tag.func_74764_b("value")) break;
                this.setColorText(tag.func_74762_e("value"));
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        tag.func_74757_a("powered", this.powered);
        this.colored = this.isColoredEval();
        tag.func_74757_a("colored", this.colored);
        return tag;
    }

    protected void deserializeDisplaySettings(NBTTagCompound tag) {
        this.deserializeSlotSettings(tag, "dSettings", 0);
    }

    protected void deserializeSlotSettings(NBTTagCompound tag, String tagName, int slot) {
        if (!tag.func_74764_b(tagName)) {
            return;
        }
        NBTTagList settingsList = tag.func_150295_c(tagName, 10);
        for (int i = 0; i < settingsList.func_74745_c(); ++i) {
            NBTTagCompound compound = settingsList.func_150305_b(i);
            try {
                this.getDisplaySettingsForSlot(slot).put(compound.func_74779_i("key"), compound.func_74762_e("value"));
                continue;
            }
            catch (IllegalArgumentException e) {
                EnergyControl.logger.warn("Invalid display settings for Information Panel");
            }
        }
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        boolean newPowered;
        super.readProperties(tag);
        if (tag.func_74764_b("tickRate")) {
            this.tickRate = tag.func_74762_e("tickRate");
        }
        if (tag.func_74764_b("showLabels")) {
            this.showLabels = tag.func_74767_n("showLabels");
        }
        if (tag.func_74764_b("colorText")) {
            this.colorText = tag.func_74762_e("colorText");
        }
        if (tag.func_74764_b("colorBackground")) {
            this.colorBackground = tag.func_74762_e("colorBackground");
        }
        if (tag.func_74764_b("colored")) {
            this.setColored(tag.func_74767_n("colored"));
        }
        if (tag.func_74764_b("screenData")) {
            if (this.field_145850_b != null) {
                this.setScreenData((NBTTagCompound)tag.func_74781_a("screenData"));
            } else {
                this.screenData = (NBTTagCompound)tag.func_74781_a("screenData");
            }
        } else {
            this.screenData = null;
        }
        this.deserializeDisplaySettings(tag);
        if (tag.func_74764_b("powered") && this.field_145850_b.field_72995_K && this.powered != (newPowered = tag.func_74767_n("powered"))) {
            this.powered = newPowered;
            this.field_145850_b.func_175664_x(this.field_174879_c);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    protected void serializeDisplaySettings(NBTTagCompound tag) {
        tag.func_74782_a("dSettings", (NBTBase)this.serializeSlotSettings(0));
    }

    protected NBTTagList serializeSlotSettings(int slot) {
        NBTTagList settingsList = new NBTTagList();
        for (Map.Entry<String, Integer> item : this.getDisplaySettingsForSlot(slot).entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("key", item.getKey());
            tag.func_74768_a("value", item.getValue().intValue());
            settingsList.func_74742_a((NBTBase)tag);
        }
        return settingsList;
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74768_a("tickRate", this.tickRate);
        tag.func_74757_a("showLabels", this.getShowLabels());
        tag.func_74768_a("colorBackground", this.colorBackground);
        tag.func_74768_a("colorText", this.colorText);
        this.serializeDisplaySettings(tag);
        if (this.screen != null) {
            this.screenData = this.screen.toTag();
            tag.func_74782_a("screenData", (NBTBase)this.screenData);
        }
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.writeProperties(super.func_189515_b(tag));
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            EnergyControl.instance.screenManager.unregisterScreenPart(this);
        }
        super.func_145843_s();
    }

    public void func_73660_a() {
        if (!this.init) {
            this.initData();
        }
        if (!this.powered) {
            return;
        }
        --this.dataTicker;
        if (this.dataTicker <= 0) {
            this.resetCardData();
            this.dataTicker = 4;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateTicker-- > 0) {
                return;
            }
            this.updateTicker = this.tickRate - 1;
            if (this.hasCards()) {
                this.func_70296_d();
            }
        }
    }

    private boolean hasCards() {
        for (ItemStack card : this.getCards()) {
            if (card.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateTileEntity() {
        this.notifyBlockUpdate();
    }

    public void resetCardData() {
        this.cardData.clear();
    }

    public List<PanelString> getCardData(int settings, ItemStack cardStack, ItemCardReader reader, boolean isServer, boolean showLabels) {
        int slot = this.getCardSlot(cardStack);
        List<PanelString> data = this.cardData.get(slot);
        if (data == null) {
            data = ItemCardMain.getStringData(settings, reader, isServer, showLabels);
            this.cardData.put(slot, data);
        }
        return data;
    }

    @Override
    protected boolean hasRotation() {
        return true;
    }

    public NonNullList<ItemStack> getCards() {
        NonNullList data = NonNullList.func_191196_a();
        data.add((Object)this.func_70301_a(0));
        return data;
    }

    public List<PanelString> getPanelStringList(boolean isServer, boolean showLabels) {
        NonNullList<ItemStack> cards = this.getCards();
        boolean anyCardFound = false;
        LinkedList<PanelString> joinedData = new LinkedList<PanelString>();
        for (ItemStack card : cards) {
            ItemCardReader reader;
            CardState state;
            List<PanelString> data;
            int settings;
            if (card.func_190926_b() || (settings = this.getDisplaySettingsByCard(card)) == 0 || (data = (state = (reader = new ItemCardReader(card)).getState()) != CardState.OK && state != CardState.CUSTOM_ERROR ? ItemCardReader.getStateMessage(state) : this.getCardData(settings, card, reader, isServer, showLabels)) == null) continue;
            joinedData.addAll(data);
            anyCardFound = true;
        }
        if (anyCardFound) {
            return joinedData;
        }
        return null;
    }

    public List<String> getPanelStringList(boolean isRaw) {
        List<PanelString> joinedData = this.getPanelStringList(true, false);
        NonNullList list = NonNullList.func_191196_a();
        if (joinedData == null || joinedData.size() == 0) {
            return list;
        }
        for (PanelString panelString : joinedData) {
            if (panelString.textLeft != null) {
                list.add(this.formatString(panelString.textLeft, isRaw));
            }
            if (panelString.textCenter != null) {
                list.add(this.formatString(panelString.textCenter, isRaw));
            }
            if (panelString.textRight == null) continue;
            list.add(this.formatString(panelString.textRight, isRaw));
        }
        return list;
    }

    private String formatString(String text, boolean isRaw) {
        return isRaw ? text : text.replaceAll("\\u00a7[1-9,a-f]", "");
    }

    public int getCardSlot(ItemStack card) {
        if (card.func_190926_b()) {
            return 0;
        }
        int slot = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b() || !stack.equals(card)) continue;
            slot = i;
            break;
        }
        return slot;
    }

    private void processCard(ItemStack card, int slot, ItemStack stack) {
        if (ItemCardMain.isCard(card)) {
            ItemCardReader reader = new ItemCardReader(card);
            ItemCardMain.updateCardNBT(card, this.field_145850_b, this.field_174879_c, reader, stack);
            ItemCardMain.sendCardToWS(this.getPanelStringList(true, this.getShowLabels()), reader);
            reader.updateClient(card, this, slot);
        }
    }

    public boolean isColoredEval() {
        ItemStack stack = this.func_70301_a(2);
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemUpgrade && stack.func_77952_i() == 1;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.setColored(this.isColoredEval());
            if (this.powered) {
                ItemStack itemStack = this.func_70301_a(this.getSlotUpgradeRange());
                for (ItemStack card : this.getCards()) {
                    this.processCard(card, this.getCardSlot(card), itemStack);
                }
            }
        }
    }

    public byte getSlotUpgradeRange() {
        return 1;
    }

    public boolean isCardSlot(int slot) {
        return slot == 0;
    }

    public Map<String, Integer> getDisplaySettingsForSlot(int slot) {
        if (!this.displaySettings.containsKey(slot)) {
            this.displaySettings.put(slot, new HashMap());
        }
        return this.displaySettings.get(slot);
    }

    public int getDisplaySettingsForCardInSlot(int slot) {
        ItemStack card = this.func_70301_a(slot);
        if (card.func_190926_b()) {
            return 0;
        }
        return this.getDisplaySettingsByCard(card);
    }

    public int getDisplaySettingsByCard(ItemStack card) {
        int slot = this.getCardSlot(card);
        if (card.func_190926_b()) {
            return 0;
        }
        if (this.displaySettings.containsKey(slot)) {
            for (Map.Entry<String, Integer> entry : this.displaySettings.get(slot).entrySet()) {
                if (!StringUtils.getItemId(card).equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return 0x7FFFFBFF;
    }

    public void setDisplaySettings(int slot, int settings) {
        if (!this.isCardSlot(slot)) {
            return;
        }
        ItemStack stack = this.func_70301_a(slot);
        if (!ItemCardMain.isCard(stack)) {
            return;
        }
        if (!this.displaySettings.containsKey(slot)) {
            this.displaySettings.put(slot, new HashMap());
        }
        this.displaySettings.get(slot).put(StringUtils.getItemId(stack), settings);
        if (!this.field_145850_b.field_72995_K) {
            this.notifyBlockUpdate();
        }
    }

    public int func_70302_i_() {
        return 4;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.isItemValid(index, stack);
    }

    @Override
    public boolean isItemValid(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                return ItemCardMain.isCard(stack);
            }
            case 1: {
                return stack.func_77973_b() instanceof ItemUpgrade && stack.func_77952_i() == 0;
            }
            case 2: {
                return stack.func_77973_b() instanceof ItemUpgrade && stack.func_77952_i() == 1;
            }
            case 3: {
                return stack.func_77973_b() instanceof ItemUpgrade && stack.func_77952_i() == 2;
            }
        }
        return false;
    }

    @Override
    public void setScreen(Screen screen) {
        this.screen = screen;
    }

    @Override
    public Screen getScreen() {
        return this.screen;
    }

    @Override
    public void updateData() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.screenData = this.screen == null ? null : this.screen.toTag();
        this.notifyBlockUpdate();
    }

    public void updateBlockState(IBlockState state) {
        boolean flag;
        this.powered = flag = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (flag == (Boolean)state.func_177229_b((IProperty)FacingBlockActive.ACTIVE)) {
            return;
        }
        if (flag) {
            this.field_145850_b.func_175684_a(this.field_174879_c, state.func_177230_c(), 4);
        } else {
            this.field_145850_b.func_180501_a(this.field_174879_c, state.func_177231_a((IProperty)FacingBlockActive.ACTIVE), 2);
            this.updateExtenders(true);
        }
    }

    public void updateExtenders(Boolean active) {
        if (this.screen == null) {
            return;
        }
        for (int x = this.screen.minX; x <= this.screen.maxX; ++x) {
            for (int y = this.screen.minY; y <= this.screen.maxY; ++y) {
                for (int z = this.screen.minZ; z <= this.screen.maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = this.field_145850_b.func_180495_p(pos);
                    if (!(state.func_177230_c() instanceof InfoPanelExtender) && !(state.func_177230_c() instanceof HoloPanelExtender)) continue;
                    this.field_145850_b.func_180501_a(pos, state.func_177226_a((IProperty)FacingBlockActive.ACTIVE, (Comparable)active), 2);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.screen == null) {
            return new AxisAlignedBB(this.field_174879_c.func_177982_a(0, 0, 0), this.field_174879_c.func_177982_a(1, 1, 1));
        }
        return new AxisAlignedBB(new BlockPos(this.screen.minX, this.screen.minY, this.screen.minZ), new BlockPos(this.screen.maxX + 1, this.screen.maxY + 1, this.screen.maxZ + 1));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int findTexture() {
        Screen scr = this.getScreen();
        if (scr != null) {
            BlockPos pos = this.func_174877_v();
            switch (this.getFacing()) {
                case SOUTH: {
                    return 2 * this.boolToInt(pos.func_177958_n() == scr.minX) + 1 * this.boolToInt(pos.func_177958_n() == scr.maxX) + 8 * this.boolToInt(pos.func_177956_o() == scr.minY) + 4 * this.boolToInt(pos.func_177956_o() == scr.maxY);
                }
                case WEST: {
                    return 2 * this.boolToInt(pos.func_177952_p() == scr.minZ) + 1 * this.boolToInt(pos.func_177952_p() == scr.maxZ) + 8 * this.boolToInt(pos.func_177956_o() == scr.minY) + 4 * this.boolToInt(pos.func_177956_o() == scr.maxY);
                }
                case EAST: {
                    return 1 * this.boolToInt(pos.func_177952_p() == scr.minZ) + 2 * this.boolToInt(pos.func_177952_p() == scr.maxZ) + 8 * this.boolToInt(pos.func_177956_o() == scr.minY) + 4 * this.boolToInt(pos.func_177956_o() == scr.maxY);
                }
                case NORTH: {
                    return this.boolToInt(pos.func_177958_n() == scr.minX) + 2 * this.boolToInt(pos.func_177958_n() == scr.maxX) + 8 * this.boolToInt(pos.func_177956_o() == scr.minY) + 4 * this.boolToInt(pos.func_177956_o() == scr.maxY);
                }
                case UP: {
                    return this.boolToInt(pos.func_177958_n() == scr.minX) + 2 * this.boolToInt(pos.func_177958_n() == scr.maxX) + 8 * this.boolToInt(pos.func_177952_p() == scr.minZ) + 4 * this.boolToInt(pos.func_177952_p() == scr.maxZ);
                }
                case DOWN: {
                    return this.boolToInt(pos.func_177958_n() == scr.minX) + 2 * this.boolToInt(pos.func_177958_n() == scr.maxX) + 4 * this.boolToInt(pos.func_177952_p() == scr.minZ) + 8 * this.boolToInt(pos.func_177952_p() == scr.maxZ);
                }
            }
        }
        return 15;
    }

    protected int boolToInt(boolean b) {
        return b ? 1 : 0;
    }

    public boolean runTouchAction(ItemStack stack, BlockPos pos, float hitX, float hitY, float hitZ) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        ItemStack card = this.func_70301_a(0);
        this.runTouchAction(this, card, stack, 0, true);
        return true;
    }

    public boolean isTouchCard() {
        return this.isTouchCard(this.func_70301_a(0));
    }

    public boolean isTouchCard(ItemStack stack) {
        Item item = stack.func_77973_b();
        return !stack.func_190926_b() && item instanceof ITouchAction && ((ITouchAction)item).enableTouch(stack);
    }

    public boolean hasBars() {
        return this.hasBars(this.func_70301_a(0));
    }

    public boolean hasBars(ItemStack stack) {
        Item item = stack.func_77973_b();
        return !stack.func_190926_b() && item instanceof IHasBars && ((IHasBars)item).enableBars(stack) && (this.getDisplaySettingsForCardInSlot(0) & 0x400) > 0;
    }

    public void renderImage(TextureManager manager, double displayWidth, double displayHeight) {
        ItemStack stack = this.func_70301_a(0);
        Item card = stack.func_77973_b();
        if (this.isTouchCard()) {
            ((ITouchAction)card).renderImage(manager, new ItemCardReader(stack));
        }
        if (this.hasBars()) {
            ((IHasBars)card).renderBars(manager, displayWidth, displayHeight, new ItemCardReader(stack));
        }
    }

    protected void runTouchAction(TileEntityInfoPanel panel, ItemStack cardStack, ItemStack stack, int slot, boolean needsTouchUpgrade) {
        if (!(!this.isTouchCard(cardStack) || needsTouchUpgrade && this.func_70301_a(3).func_190926_b())) {
            ItemCardReader reader = new ItemCardReader(cardStack);
            if (((ITouchAction)cardStack.func_77973_b()).runTouchAction(panel.func_145831_w(), reader, stack)) {
                reader.updateClient(cardStack, panel, slot);
            }
        }
    }
}

