/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.client.gui;

import appeng.api.AEApi;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.client.gui.GuiWT;
import p455w0rd.wct.container.ContainerCraftingCPU;
import p455w0rd.wct.init.ModNetworking;
import p455w0rd.wct.sync.packets.PacketValueConfig;

public class GuiCraftingCPU
extends GuiWT
implements ISortSource {
    private static final int GUI_HEIGHT = 184;
    private static final int GUI_WIDTH = 238;
    private static final int DISPLAYED_ROWS = 6;
    private static final int TEXT_COLOR = 0x404040;
    private static final int BACKGROUND_ALPHA = 0x5A000000;
    private static final int SECTION_LENGTH = 67;
    private static final int SCROLLBAR_TOP = 19;
    private static final int SCROLLBAR_LEFT = 218;
    private static final int SCROLLBAR_HEIGHT = 137;
    private static final int CANCEL_LEFT_OFFSET = 163;
    private static final int CANCEL_TOP_OFFSET = 25;
    private static final int CANCEL_HEIGHT = 20;
    private static final int CANCEL_WIDTH = 50;
    private static final int TITLE_TOP_OFFSET = 7;
    private static final int TITLE_LEFT_OFFSET = 8;
    private static final int ITEMSTACK_LEFT_OFFSET = 9;
    private static final int ITEMSTACK_TOP_OFFSET = 22;
    private final ContainerCraftingCPU craftingCpu;
    private IItemList<IAEItemStack> storage = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
    private IItemList<IAEItemStack> active = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
    private IItemList<IAEItemStack> pending = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
    private List<IAEItemStack> visual = new ArrayList<IAEItemStack>();
    private GuiButton cancel;
    private int tooltip = -1;

    public GuiCraftingCPU(InventoryPlayer inventoryPlayer, Object te, int wtSlot, boolean isWTBauble) {
        this(new ContainerCraftingCPU(inventoryPlayer, te, wtSlot, isWTBauble));
    }

    protected GuiCraftingCPU(ContainerCraftingCPU container) {
        super((Container)container);
        this.craftingCpu = container;
        this.field_147000_g = 184;
        this.field_146999_f = 238;
        this.setScrollBar(WTApi.instance().createScrollbar());
    }

    public void clearItems() {
        this.storage = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
        this.active = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
        this.pending = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
        this.visual = new ArrayList<IAEItemStack>();
    }

    protected void func_146284_a(GuiButton btn) throws IOException {
        super.func_146284_a(btn);
        if (this.cancel == btn) {
            ModNetworking.instance().sendToServer(new PacketValueConfig("TileCrafting.Cancel", "Cancel"));
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.setScrollBar();
        this.cancel = new GuiButton(0, this.field_147003_i + 163, this.field_147009_r + this.field_147000_g - 25, 50, 20, GuiText.Cancel.getLocal());
        this.field_146292_n.add(this.cancel);
    }

    private void setScrollBar() {
        int size = this.visual.size();
        this.getScrollBar().setTop(19).setLeft(218).setHeight(137);
        this.getScrollBar().setRange(0, (size + 2) / 3 - 6, 1);
    }

    public void func_73863_a(int mouseX, int mouseY, float btn) {
        this.cancel.field_146124_l = !this.visual.isEmpty();
        int gx = (this.field_146294_l - this.field_146999_f) / 2;
        int gy = (this.field_146295_m - this.field_147000_g) / 2;
        this.tooltip = -1;
        int offY = 23;
        int y = 0;
        int x = 0;
        for (int z = 0; z <= 20; ++z) {
            int minX = gx + 9 + x * 67;
            int minY = gy + 22 + y * 23;
            if (minX < mouseX && minX + 67 > mouseX && minY < mouseY && minY + 23 - 2 > mouseY) {
                this.tooltip = z;
                break;
            }
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        super.func_73863_a(mouseX, mouseY, btn);
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        String title = this.getGuiDisplayName(GuiText.CraftingStatus.getLocal());
        if (this.craftingCpu.getEstimatedTime() > 0L && !this.visual.isEmpty()) {
            long etaInMilliseconds = TimeUnit.MILLISECONDS.convert(this.craftingCpu.getEstimatedTime(), TimeUnit.NANOSECONDS);
            String etaTimeText = DurationFormatUtils.formatDuration((long)etaInMilliseconds, (String)GuiText.ETAFormat.getLocal());
            title = title + " - " + etaTimeText;
        }
        this.field_146289_q.func_78276_b(title, 8, 7, 0x404040);
        int x = 0;
        int y = 0;
        int viewStart = this.getScrollBar().getCurrentScroll() * 3;
        int viewEnd = viewStart + 18;
        String dspToolTip = "";
        LinkedList<String> lineList = new LinkedList<String>();
        int toolPosX = 0;
        int toolPosY = 0;
        int offY = 23;
        ReadableNumberConverter converter = ReadableNumberConverter.INSTANCE;
        for (int z = viewStart; z < Math.min(viewEnd, this.visual.size()); ++z) {
            int w;
            IAEItemStack refStack = this.visual.get(z);
            if (refStack == null) continue;
            GL11.glPushMatrix();
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            IAEItemStack stored = (IAEItemStack)this.storage.findPrecise((IAEStack)refStack);
            IAEItemStack activeStack = (IAEItemStack)this.active.findPrecise((IAEStack)refStack);
            IAEItemStack pendingStack = (IAEItemStack)this.pending.findPrecise((IAEStack)refStack);
            int lines = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                ++lines;
            }
            boolean active = false;
            if (activeStack != null && activeStack.getStackSize() > 0L) {
                ++lines;
                active = true;
            }
            boolean scheduled = false;
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                ++lines;
                scheduled = true;
            }
            if (AEConfig.instance().isUseColoredCraftingStatus() && (active || scheduled)) {
                int bgColor = (active ? AEColor.GREEN.blackVariant : AEColor.YELLOW.blackVariant) | 0x5A000000;
                int startX = (x * 68 + 9) * 2;
                int startY = (y * 23 + 22 - 3) * 2;
                GuiCraftingCPU.func_73734_a((int)startX, (int)startY, (int)(startX + 134), (int)(startY + 46 - 2), (int)bgColor);
            }
            int negY = (lines - 1) * 5 / 2;
            int downY = 0;
            if (stored != null && stored.getStackSize() > 0L) {
                String str = GuiText.Stored.getLocal() + ": " + converter.toWideReadableForm(stored.getStackSize());
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0), (y * 23 + 22 + 6 - negY + downY) * 2, 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Stored.getLocal() + ": " + Long.toString(stored.getStackSize()));
                }
                downY += 5;
            }
            if (activeStack != null && activeStack.getStackSize() > 0L) {
                String str = GuiText.Crafting.getLocal() + ": " + converter.toWideReadableForm(activeStack.getStackSize());
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0), (y * 23 + 22 + 6 - negY + downY) * 2, 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Crafting.getLocal() + ": " + Long.toString(activeStack.getStackSize()));
                }
                downY += 5;
            }
            if (pendingStack != null && pendingStack.getStackSize() > 0L) {
                String str = GuiText.Scheduled.getLocal() + ": " + converter.toWideReadableForm(pendingStack.getStackSize());
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0), (y * 23 + 22 + 6 - negY + downY) * 2, 0x404040);
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.Scheduled.getLocal() + ": " + Long.toString(pendingStack.getStackSize()));
                }
            }
            GL11.glPopMatrix();
            int posX = x * 68 + 9 + 67 - 19;
            int posY = y * 23 + 22;
            ItemStack is = refStack.copy().createItemStack();
            if (this.tooltip == z - viewStart) {
                dspToolTip = Platform.getItemDisplayName((Object)is);
                if (lineList.size() > 0) {
                    dspToolTip = dspToolTip + '\n' + Joiner.on((String)"\n").join(lineList);
                }
                toolPosX = x * 68 + 9 + 67 - 8;
                toolPosY = y * 23 + 22;
            }
            this.drawItem(posX, posY, is);
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        if (this.tooltip >= 0 && dspToolTip.length() > 0) {
            this.drawTooltip(toolPosX, toolPosY + 10, dspToolTip);
        }
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("appliedenergistics2", "textures/guis/craftingcpu.png"));
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.getScrollBar() != null) {
            this.getScrollBar().wheel(i);
        }
    }

    public void postUpdate(List<IAEItemStack> list, byte ref) {
        switch (ref) {
            case 0: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.storage, l);
                }
                break;
            }
            case 1: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.active, l);
                }
                break;
            }
            case 2: {
                for (IAEItemStack l : list) {
                    this.handleInput(this.pending, l);
                }
                break;
            }
        }
        for (IAEItemStack l : list) {
            long amt = this.getTotal(l);
            if (amt <= 0L) {
                this.deleteVisualStack(l);
                continue;
            }
            IAEItemStack is = this.findVisualStack(l);
            is.setStackSize(amt);
        }
        this.setScrollBar();
    }

    private void handleInput(IItemList<IAEItemStack> s, IAEItemStack l) {
        IAEItemStack a = (IAEItemStack)s.findPrecise((IAEStack)l);
        if (l.getStackSize() <= 0L) {
            if (a != null) {
                a.reset();
            }
        } else {
            if (a == null) {
                s.add((IAEStack)l.copy());
                a = (IAEItemStack)s.findPrecise((IAEStack)l);
            }
            if (a != null) {
                a.setStackSize(l.getStackSize());
            }
        }
    }

    private long getTotal(IAEItemStack is) {
        IAEItemStack a = (IAEItemStack)this.storage.findPrecise((IAEStack)is);
        IAEItemStack b = (IAEItemStack)this.active.findPrecise((IAEStack)is);
        IAEItemStack c = (IAEItemStack)this.pending.findPrecise((IAEStack)is);
        long total = 0L;
        if (a != null) {
            total += a.getStackSize();
        }
        if (b != null) {
            total += b.getStackSize();
        }
        if (c != null) {
            total += c.getStackSize();
        }
        return total;
    }

    private void deleteVisualStack(IAEItemStack l) {
        Iterator<IAEItemStack> i = this.visual.iterator();
        while (i.hasNext()) {
            IAEItemStack o = i.next();
            if (!o.equals(l)) continue;
            i.remove();
            return;
        }
    }

    private IAEItemStack findVisualStack(IAEItemStack l) {
        for (IAEItemStack o : this.visual) {
            if (!o.equals(l)) continue;
            return o;
        }
        IAEItemStack stack = l.copy();
        this.visual.add(stack);
        return stack;
    }

    public Enum getSortBy() {
        return SortOrder.NAME;
    }

    public Enum getSortDir() {
        return SortDir.ASCENDING;
    }

    public Enum getSortDisplay() {
        return ViewItems.ALL;
    }
}

