/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.ICBMClassic;
import icbm.classic.api.explosion.IBlastTickable;
import icbm.classic.content.blast.BlastHelpers;
import icbm.classic.content.blast.thread.ThreadSmallExplosion;
import icbm.classic.content.blast.threaded.BlastThreaded;
import icbm.classic.content.entity.flyingblock.EntityFlyingBlock;
import icbm.classic.content.entity.flyingblock.FlyingBlock;
import icbm.classic.lib.transform.PosDistanceSorter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;

public class BlastAntiGravitational
extends BlastThreaded
implements IBlastTickable {
    protected ThreadSmallExplosion thread;
    protected Set<EntityFlyingBlock> flyingBlocks = new HashSet<EntityFlyingBlock>();

    @Override
    public boolean setupBlast() {
        if (!this.world().field_72995_K) {
            this.thread = new ThreadSmallExplosion(this, (int)this.getBlastRadius(), this.field_77283_e);
            this.thread.start();
        }
        return true;
    }

    @Override
    public boolean doRun(int loops, Consumer<BlockPos> edits) {
        int ymin = -this.getPos().func_177956_o();
        int ymax = 255 - this.getPos().func_177956_o();
        BlastHelpers.forEachPosInRadius(this.getBlastRadius(), (x, y, z) -> {
            if (y >= ymin && y < ymax) {
                edits.accept(new BlockPos(this.xi() + x, this.yi() + y, this.zi() + z));
            }
        });
        return false;
    }

    @Override
    public boolean doExplode(int callCount) {
        int r = this.callCount;
        if (this.world() != null && !this.world().field_72995_K) {
            try {
                if (this.thread != null) {
                    if (this.thread.isComplete) {
                        ArrayList<BlockPos> results = new ArrayList<BlockPos>(this.getThreadResults());
                        if (r == 0) {
                            results.sort(new PosDistanceSorter(this.location, true, PosDistanceSorter.Sort.MANHATTEN));
                        }
                        int blocksToTake = 20;
                        for (BlockPos targetPosition : results) {
                            float hardness;
                            IBlockState blockState = this.field_77287_j.func_180495_p(targetPosition);
                            if (blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.field_77287_j, targetPosition) || blockState.func_177230_c().func_176200_f((IBlockAccess)this.field_77287_j, targetPosition) || blockState.func_177230_c() instanceof IFluidBlock || blockState.func_177230_c() instanceof BlockLiquid || !((hardness = blockState.func_185887_b(this.field_77287_j, targetPosition)) >= 0.0f) || !(hardness < 1000.0f) || this.world().field_73012_v.nextInt(3) <= 0) continue;
                            this.field_77287_j.func_175698_g(targetPosition);
                            if (--blocksToTake > 0) {
                                FlyingBlock.spawnFlyingBlock(this.field_77287_j, targetPosition, blockState, entity -> {
                                    entity.yawChange = 50.0f * this.world().field_73012_v.nextFloat();
                                    entity.pitchChange = 100.0f * this.world().field_73012_v.nextFloat();
                                    entity.field_70181_x += Math.max(0.15 * (double)this.world().field_73012_v.nextFloat(), 0.1);
                                    entity.field_70145_X = true;
                                    entity.gravity = 0.0f;
                                }, entityFlyingBlock -> {
                                    this.flyingBlocks.add((EntityFlyingBlock)((Object)entityFlyingBlock));
                                    ICBMClassic.logger().info("Spawned flying block" + (Object)entityFlyingBlock);
                                });
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    String msg = String.format("BlastAntiGravitational#doPostExplode() -> Failed to run due to null thread\nWorld = %s \nThread = %s\nSize = %s\nPos = ", this.field_77287_j, this.thread, Float.valueOf(this.field_77280_f), this.location);
                    ICBMClassic.logger().error(msg);
                }
            }
            catch (Exception e) {
                String msg = String.format("BlastAntiGravitational#doPostExplode() ->  Unexpected error while running post detonation code \nWorld = %s \nThread = %s\nSize = %s\nPos = ", this.field_77287_j, this.thread, Float.valueOf(this.field_77280_f), this.location);
                ICBMClassic.logger().error(msg, (Throwable)e);
            }
        }
        int radius = (int)this.getBlastRadius();
        AxisAlignedBB bounds = new AxisAlignedBB(this.location.x() - (double)radius, this.location.y() - (double)radius, this.location.z() - (double)radius, this.location.y() + (double)radius, 100.0, this.location.z() + (double)radius);
        List allEntities = this.world().func_72872_a(Entity.class, bounds);
        for (Entity entity2 : allEntities) {
            if (entity2 instanceof EntityFlyingBlock || !(entity2.field_70163_u < 100.0 + this.location.y()) || !(entity2.field_70181_x < 0.4)) continue;
            entity2.field_70181_x += 0.15;
        }
        return this.callCount > 2400;
    }

    @Override
    protected void onBlastCompleted() {
        this.flyingBlocks.forEach(EntityFlyingBlock::restoreGravity);
    }
}

