/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.api.explosion.IBlastTickable;
import icbm.classic.client.ICBMSounds;
import icbm.classic.content.blast.Blast;
import icbm.classic.content.blast.BlastHelpers;
import icbm.classic.content.entity.EntityLightBeam;
import icbm.classic.content.entity.flyingblock.EntityFlyingBlock;
import icbm.classic.content.entity.flyingblock.FlyingBlock;
import icbm.classic.lib.explosive.ThreadWorkBlast;
import icbm.classic.lib.thread.IThreadWork;
import icbm.classic.lib.thread.WorkerThreadManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public abstract class BlastBeam
extends Blast
implements IBlastTickable {
    protected final Set<EntityFlyingBlock> flyingBlocks = new HashSet<EntityFlyingBlock>();
    protected final List<BlockPos> blocksToRemove = new ArrayList<BlockPos>();
    protected EntityLightBeam lightBeam;
    protected float red;
    protected float green;
    protected float blue;
    private boolean hasDoneSetup = false;
    private boolean hasStartedFirstThread = false;
    private boolean hasCompletedFirstThread = false;
    private boolean hasGeneratedFlyingBlocks = false;
    private boolean hasStartedSecondThread = false;
    private boolean hasCompetedSecondThread = false;
    private boolean hasEnabledGravityForFlyingBlocks = false;
    private boolean hasPlacedBlocks = false;
    private int secondThreadTimer = 100;

    @Override
    protected boolean doExplode(int callCount) {
        if (!this.hasDoneSetup) {
            this.hasDoneSetup = true;
            ICBMSounds.BEAM_CHARGING.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, 0.8f, true);
            this.world().func_72876_a(this.field_77283_e, this.location.x(), this.location.y(), this.location.z(), 4.0f, true);
            this.lightBeam = new EntityLightBeam(this.world()).setPosition(this.location).setColor(this.red, this.green, this.blue);
            this.lightBeam.beamSize = 1.0f;
            this.lightBeam.beamGlowSize = 2.0f;
            this.lightBeam.setTargetBeamProgress(0.1f);
            this.world().func_72838_d((Entity)this.lightBeam);
        }
        if (!this.hasStartedFirstThread) {
            this.hasStartedFirstThread = true;
            this.lightBeam.setTargetBeamProgress(0.2f);
            WorkerThreadManager.INSTANCE.addWork(this.getFirstThread());
        }
        if (this.hasCompletedFirstThread && !this.hasStartedSecondThread) {
            if (!this.hasGeneratedFlyingBlocks) {
                this.hasGeneratedFlyingBlocks = true;
                this.lightBeam.setTargetBeamProgress(0.5f);
                for (BlockPos blockPos : this.blocksToRemove) {
                    IBlockState state = this.field_77287_j.func_180495_p(blockPos);
                    if (!this.field_77287_j.func_175698_g(blockPos)) continue;
                    FlyingBlock.spawnFlyingBlock(this.field_77287_j, blockPos, state, entity -> {
                        entity.gravity = -0.01f;
                    }, null);
                }
                this.blocksToRemove.clear();
            }
            if (this.secondThreadTimer-- <= 0) {
                this.lightBeam.setTargetBeamProgress(0.8f);
                this.hasStartedSecondThread = true;
                WorkerThreadManager.INSTANCE.addWork(this.getSecondThread());
            }
        }
        if (this.hasCompetedSecondThread) {
            this.lightBeam.setTargetBeamProgress(1.0f);
            if (!this.hasEnabledGravityForFlyingBlocks) {
                this.hasEnabledGravityForFlyingBlocks = true;
                this.flyingBlocks.forEach(entity -> {
                    entity.gravity = 0.5f;
                });
            }
            if (!this.hasPlacedBlocks) {
                this.hasPlacedBlocks = true;
                this.mutateBlocks(this.blocksToRemove);
                this.blocksToRemove.clear();
            }
        }
        return this.hasPlacedBlocks;
    }

    protected IThreadWork getFirstThread() {
        return new ThreadWorkBlast((steps, edits) -> this.collectFlyingBlocks((Consumer<BlockPos>)edits), edits -> {
            this.blocksToRemove.addAll((Collection<BlockPos>)edits);
            this.hasGeneratedFlyingBlocks = false;
            this.hasCompletedFirstThread = true;
        });
    }

    protected IThreadWork getSecondThread() {
        return new ThreadWorkBlast((steps, edits) -> this.collectBlocksToMutate((Consumer<BlockPos>)edits), edits -> {
            this.blocksToRemove.addAll((Collection<BlockPos>)edits);
            this.hasPlacedBlocks = false;
            this.hasCompetedSecondThread = true;
        });
    }

    public boolean collectFlyingBlocks(Consumer<BlockPos> edits) {
        this.collectBlocks(edits, (int)Math.max(5.0f, this.getBlastRadius() / 10.0f));
        return false;
    }

    public boolean collectBlocksToMutate(Consumer<BlockPos> edits) {
        this.collectBlocks(edits, (int)this.getBlastRadius());
        return false;
    }

    protected void collectBlocks(Consumer<BlockPos> edits, int r) {
        int radiusSQ = r * r;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        BlastHelpers.forEachPosInRadius(r, (x, y, z) -> {
            double distanceSQ = x * x + y * y + z * z;
            if (distanceSQ <= (double)radiusSQ) {
                blockPos.func_189532_c(this.location.x() + (double)x, this.location.y() + (double)y, this.location.z() + (double)z);
                IBlockState state = this.field_77287_j.func_180495_p((BlockPos)blockPos);
                Block block = state.func_177230_c();
                if (!block.isAir(state, (IBlockAccess)this.field_77287_j, (BlockPos)blockPos) && state.func_185887_b(this.field_77287_j, (BlockPos)blockPos) >= 0.0f) {
                    edits.accept(blockPos.func_185334_h());
                }
            }
        });
    }

    protected abstract void mutateBlocks(List<BlockPos> var1);

    @Override
    protected void onBlastCompleted() {
        ICBMSounds.POWER_DOWN.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, 0.8f, true);
        if (this.lightBeam != null) {
            this.lightBeam.startDeathCycle();
            this.lightBeam.setTargetBeamProgress(0.0f);
        }
    }
}

